/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingOp;
import org.esa.s3tbx.slstr.pdu.stitching.TestUtils;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.util.ArrayUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class PDUStitchingOpTest {
    public static final String EXPECTED_STITCHED_FILE_NAME_PATTERN = "S3A_SL_1_RBT____20130707T153252_20130707T154752_2[0-9]{7}T[0-9]{6}_0299_158_182______SVL_O_NR_001.SEN3";
    File targetDirectory;

    @Before
    public void setUp() {
        this.targetDirectory = new File("test_out");
        if (!this.targetDirectory.mkdirs()) {
            Assert.fail((String)"Unable to create test target directory");
        }
    }

    @After
    public void tearDown() {
        if (this.targetDirectory.isDirectory() && !FileUtils.deleteTree((File)this.targetDirectory)) {
            Assert.fail((String)"Unable to delete test directory");
        }
    }

    @Test
    @Ignore(value="takes a few seconds")
    public void testOperator() {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("targetDir", this.targetDirectory);
        HashMap sourceProductMap = new HashMap();
        String[] productPaths = new String[]{PDUStitchingOpTest.getResource(TestUtils.FIRST_FILE_NAME).getAbsolutePath(), PDUStitchingOpTest.getResource(TestUtils.SECOND_FILE_NAME).getAbsolutePath(), PDUStitchingOpTest.getResource(TestUtils.THIRD_FILE_NAME).getAbsolutePath()};
        parameterMap.put("sourceProductPaths", productPaths);
        TestCase.assertEquals((int)0, (int)this.targetDirectory.list().length);
        Operator stitchingOperator = GPF.getDefaultInstance().createOperator("PduStitching", parameterMap, sourceProductMap, null);
        stitchingOperator.execute(ProgressMonitor.NULL);
        this.assertProductHasBeenCreated();
    }

    @Test
    @Ignore(value="takes a few seconds")
    public void testOperator_wildcards() {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        HashMap sourceProductMap = new HashMap();
        parameterMap.put("targetDir", this.targetDirectory);
        String[] productPaths = new String[]{PDUStitchingOpTest.class.getResource("").getFile() + "S*/xfdumanifest.xml"};
        parameterMap.put("sourceProductPaths", productPaths);
        TestCase.assertEquals((int)0, (int)this.targetDirectory.list().length);
        Operator stitchingOperator = GPF.getDefaultInstance().createOperator("PduStitching", parameterMap, sourceProductMap, null);
        stitchingOperator.execute(ProgressMonitor.NULL);
        this.assertProductHasBeenCreated();
    }

    private void assertProductHasBeenCreated() {
        Pattern pattern = Pattern.compile(EXPECTED_STITCHED_FILE_NAME_PATTERN);
        File[] stitchedProducts = this.targetDirectory.listFiles();
        junit.framework.Assert.assertNotNull((Object)stitchedProducts);
        TestCase.assertEquals((int)1, (int)stitchedProducts.length);
        assert (pattern.matcher(stitchedProducts[0].getName()).matches());
        Object[] productContents = stitchedProducts[0].list();
        junit.framework.Assert.assertNotNull((Object)productContents);
        TestCase.assertEquals((int)4, (int)productContents.length);
        assert (ArrayUtils.isMemberOf((Object)"F1_BT_io.nc", (Object[])productContents));
        assert (ArrayUtils.isMemberOf((Object)"met_tx.nc", (Object[])productContents));
        assert (ArrayUtils.isMemberOf((Object)"viscal.nc", (Object[])productContents));
        assert (ArrayUtils.isMemberOf((Object)"xfdumanifest.xml", (Object[])productContents));
    }

    @Test
    public void testSpi() {
        PDUStitchingOp.Spi spi = new PDUStitchingOp.Spi();
        Assert.assertTrue((boolean)spi.getOperatorClass().isAssignableFrom(PDUStitchingOp.class));
    }

    private static File getResource(String fileName) {
        String fullFileName = fileName + "/xfdumanifest.xml";
        URL resource = PDUStitchingOpTest.class.getResource(fullFileName);
        return new File(resource.getFile());
    }
}

