/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.ui;

import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.grender.Rendering;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.esa.s3tbx.slstr.pdu.stitching.ui.PDUBoundariesProvider;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;

class PDUBoundaryOverlay
implements LayerCanvas.Overlay {
    private final PDUBoundariesProvider provider;
    private LayerCanvas layerCanvas;

    PDUBoundaryOverlay(PDUBoundariesProvider provider) {
        this.provider = provider;
    }

    public void paintOverlay(LayerCanvas canvas, Rendering rendering) {
        this.layerCanvas = canvas;
        for (int i = 0; i < this.provider.getNumberOfElements(); ++i) {
            String name = this.provider.getName(i);
            GeoPos[] geoBoundary = this.provider.getGeoBoundary(i);
            boolean selected = this.provider.isSelected(i);
            this.drawGeoBoundary(rendering.getGraphics(), geoBoundary, selected, name);
        }
    }

    private void drawGeoBoundary(Graphics2D g2d, GeoPos[] geoBoundary, boolean isCurrent, String text) {
        GeneralPath gp = this.convertToPixelPath(geoBoundary);
        this.drawPath(isCurrent, g2d, gp, 0.0f);
        PixelPos boundaryCenter = this.getBoundaryCenter(geoBoundary);
        this.drawText(g2d, text, boundaryCenter, 0.0f, isCurrent);
    }

    private void drawPath(boolean isCurrent, Graphics2D g2d, GeneralPath gp, float offsetX) {
        g2d = this.prepareGraphics2D(offsetX, g2d);
        if (isCurrent) {
            g2d.setColor(new Color(255, 200, 200, 30));
        } else {
            g2d.setColor(new Color(255, 255, 255, 30));
        }
        g2d.fill(gp);
        if (isCurrent) {
            g2d.setColor(new Color(255, 0, 0));
        } else {
            g2d.setColor(Color.WHITE);
        }
        g2d.draw(gp);
    }

    private GeneralPath convertToPixelPath(GeoPos[] geoBoundary) {
        GeneralPath gp = new GeneralPath();
        for (int i = 0; i < geoBoundary.length; ++i) {
            GeoPos geoPos = geoBoundary[i];
            AffineTransform m2vTransform = this.layerCanvas.getViewport().getModelToViewTransform();
            Point2D viewPos = m2vTransform.transform(new Point2D.Double(geoPos.lon, geoPos.lat), null);
            if (i == 0) {
                gp.moveTo(viewPos.getX(), viewPos.getY());
                continue;
            }
            gp.lineTo(viewPos.getX(), viewPos.getY());
        }
        gp.closePath();
        return gp;
    }

    private void drawText(Graphics2D g2d, String text, PixelPos textCenter, float offsetX, boolean isCurrent) {
        if (text == null || textCenter == null) {
            return;
        }
        g2d = this.prepareGraphics2D(offsetX, g2d);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Color color = g2d.getColor();
        if (isCurrent) {
            g2d.setColor(new Color(255, 0, 0));
        } else {
            g2d.setColor(Color.WHITE);
        }
        g2d.drawString(text, (float)(textCenter.x - (double)((float)fontMetrics.stringWidth(text) / 2.0f)), (float)(textCenter.y + (double)((float)fontMetrics.getAscent() / 2.0f)));
        g2d.setColor(color);
    }

    private Graphics2D prepareGraphics2D(float offsetX, Graphics2D g2d) {
        if (offsetX != 0.0f) {
            g2d = (Graphics2D)g2d.create();
            AffineTransform transform = g2d.getTransform();
            AffineTransform offsetTrans = new AffineTransform();
            offsetTrans.setToTranslation(offsetX, 0.0);
            transform.concatenate(offsetTrans);
            g2d.setTransform(transform);
        }
        return g2d;
    }

    private PixelPos getBoundaryCenter(GeoPos[] geoBoundary) {
        AffineTransform transform = this.layerCanvas.getViewport().getModelToViewTransform();
        double meanX = 0.0;
        double meanY = 0.0;
        for (GeoPos geoPos : geoBoundary) {
            Point2D point2D = transform.transform(new Point2D.Double(geoPos.getLon(), geoPos.getLat()), null);
            meanX += point2D.getX();
            meanY += point2D.getY();
        }
        return new PixelPos(meanX /= (double)geoBoundary.length, meanY /= (double)geoBoundary.length);
    }
}

