/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.ui;

import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.grender.Viewport;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.s3tbx.slstr.pdu.stitching.ui.PDUBoundariesProvider;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.ui.WorldMapPane;
import org.esa.snap.ui.WorldMapPaneDataModel;

class PDUWorldMapPane
extends WorldMapPane {
    private final PDUBoundariesProvider provider;
    private LayerCanvas.Overlay greyOverlay;

    PDUWorldMapPane(WorldMapPaneDataModel dataModel, PDUBoundariesProvider provider, LayerCanvas.Overlay overlay) {
        super(dataModel, overlay);
        this.provider = provider;
        this.greyOverlay = (canvas, rendering) -> {
            Graphics2D graphics = rendering.getGraphics();
            graphics.setPaint(new Color(200, 200, 200, 180));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        };
    }

    protected Action[] getOverlayActions() {
        Action[] overlayActions = super.getOverlayActions();
        if (overlayActions.length != 2) {
            return overlayActions;
        }
        Object icon = overlayActions[1].getValue("SwingLargeIconKey");
        overlayActions[1] = new ZoomToSelectedBoundariesAction(icon);
        return overlayActions;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        super.setEnabled(enabled);
        if (enabled) {
            LayerCanvas layerCanvas = this.getLayerCanvas();
            layerCanvas.removeOverlay(this.greyOverlay);
            this.setPanSupport((WorldMapPane.PanSupport)new PDUWorldMapPanePanSupport(layerCanvas));
        } else {
            this.zoomAll();
            this.getLayerCanvas().addOverlay(this.greyOverlay);
            this.setPanSupport(new NullPanSupport());
        }
    }

    private void zoomToSelectedBoundaries() {
        ArrayList<GeneralPath> generalPaths = new ArrayList<GeneralPath>();
        for (int i = 0; i < this.provider.getNumberOfElements(); ++i) {
            if (!this.provider.isSelected(i)) continue;
            GeneralPath generalPath = this.convertToGeoPath(this.provider.getGeoBoundary(i));
            generalPaths.add(generalPath);
        }
        Rectangle2D modelArea = new Rectangle2D.Double();
        Viewport viewport = this.getLayerCanvas().getViewport();
        for (GeneralPath generalPath : generalPaths) {
            Rectangle2D rectangle2D = generalPath.getBounds2D();
            if (((RectangularShape)modelArea).isEmpty()) {
                if (!viewport.isModelYAxisDown()) {
                    modelArea.setFrame(rectangle2D.getX(), rectangle2D.getMaxY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                }
                modelArea = rectangle2D;
                continue;
            }
            modelArea.add(rectangle2D);
        }
        Rectangle2D modelBounds = ((Rectangle2D)modelArea).getBounds2D();
        modelBounds.setFrame(modelBounds.getX() - 2.0, modelBounds.getY() - 2.0, modelBounds.getWidth() + 4.0, modelBounds.getHeight() + 4.0);
        modelBounds = this.cropToMaxModelBounds(modelBounds);
        viewport.zoom(modelBounds);
        this.fireScrolled();
    }

    private GeneralPath convertToGeoPath(GeoPos[] geoBoundary) {
        GeneralPath gp = new GeneralPath();
        for (int i = 0; i < geoBoundary.length; ++i) {
            GeoPos geoPos = geoBoundary[i];
            if (i == 0) {
                gp.moveTo(geoPos.getLon(), geoPos.getLat());
                continue;
            }
            gp.lineTo(geoPos.getLon(), geoPos.getLat());
        }
        gp.closePath();
        return gp;
    }

    private class PDUWorldMapPanePanSupport
    extends WorldMapPane.DefaultPanSupport {
        protected PDUWorldMapPanePanSupport(LayerCanvas layerCanvas) {
            super(layerCanvas);
        }
    }

    private class NullPanSupport
    implements WorldMapPane.PanSupport {
        private NullPanSupport() {
        }

        public void panStarted(MouseEvent event) {
        }

        public void performPan(MouseEvent event) {
        }

        public void panStopped(MouseEvent event) {
        }
    }

    private class ZoomToSelectedBoundariesAction
    extends AbstractAction {
        private ZoomToSelectedBoundariesAction(Object icon) {
            this.putValue("SwingLargeIconKey", icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                PDUWorldMapPane.this.zoomToSelectedBoundaries();
            }
        }
    }
}

