/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.ui;

import com.bc.ceres.swing.binding.ComponentAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.s3tbx.slstr.pdu.stitching.PDUStitchingOp;
import org.esa.s3tbx.slstr.pdu.stitching.Validator;
import org.esa.s3tbx.slstr.pdu.stitching.ui.PDUBoundariesProvider;
import org.esa.s3tbx.slstr.pdu.stitching.ui.PDUBoundaryOverlay;
import org.esa.s3tbx.slstr.pdu.stitching.ui.PDUStitchingModel;
import org.esa.s3tbx.slstr.pdu.stitching.ui.PDUWorldMapPane;
import org.esa.s3tbx.slstr.pdu.stitching.ui.SlstrL1bFileNameValidator;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductFilter;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.WorldMapPane;
import org.esa.snap.ui.WorldMapPaneDataModel;
import org.esa.snap.ui.product.SourceProductList;

class PDUStitchingPanel
extends JPanel {
    private static final String INPUT_PRODUCT_DIR_KEY = "gpf.slstr.pdu.stitching.input.product.dir";
    private static final String NO_SOURCE_PRODUCTS_TEXT = "No Product Dissemination Units selected";
    private static final String VALID_SOURCE_PRODUCTS_TEXT = "Selection of Product Dissemination Units is valid";
    private static final String INVALID_SELECTION_TEXT = "Selection of Product Dissemination Units is invalid: ";
    private final AppContext appContext;
    private final PDUStitchingModel model;
    private JLabel statusLabel;
    private boolean isReactingToChange;
    private SourceProductList sourceProductList;
    private PDUBoundariesProvider boundariesProvider;
    private WorldMapPane worldMapPane;

    PDUStitchingPanel(AppContext appContext, PDUStitchingModel model) {
        this.appContext = appContext;
        this.model = model;
        this.isReactingToChange = false;
        this.setLayout(new BorderLayout());
        JSplitPane pane = new JSplitPane(0, this.createSourceProductsPanel(), this.createWorldMapPanel());
        pane.setDividerLocation(0.35);
        pane.setResizeWeight(0.35);
        pane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)pane, "Center");
        this.add((Component)this.createTargetDirPanel(), "South");
    }

    private JPanel createSourceProductsPanel() {
        this.sourceProductList = new SourceProductList(this.appContext);
        this.sourceProductList.setPropertyNameLastOpenInputDir(INPUT_PRODUCT_DIR_KEY);
        this.sourceProductList.setPropertyNameLastOpenedFormat("Sen3");
        this.sourceProductList.addChangeListener((ListDataListener)new SourceListDataListener());
        this.sourceProductList.addSelectionListener((ListSelectionListener)new SourceListSelectionListener());
        this.sourceProductList.setXAxis(false);
        this.sourceProductList.setDefaultPattern("S3A_SL_1*.SEN3");
        this.sourceProductList.setProductFilter(new ProductFilter(){

            public boolean accept(Product product) {
                return SlstrL1bFileNameValidator.isValidDirectoryName(product.getName());
            }
        });
        this.model.getBindingContext().bind("sourceProductPaths", (ComponentAdapter)this.sourceProductList);
        JComponent[] panels = this.sourceProductList.getComponents();
        JPanel sourceProductPanel = new JPanel(new BorderLayout());
        sourceProductPanel.add((Component)panels[0], "Center");
        sourceProductPanel.add((Component)panels[1], "East");
        this.statusLabel = new JLabel(NO_SOURCE_PRODUCTS_TEXT);
        sourceProductPanel.add((Component)this.statusLabel, "South");
        sourceProductPanel.setBorder(BorderFactory.createTitledBorder("Product Dissemination Units"));
        return sourceProductPanel;
    }

    private JPanel createWorldMapPanel() {
        this.boundariesProvider = new PDUBoundariesProvider();
        PDUBoundaryOverlay pduBoundaryOverlay = new PDUBoundaryOverlay(this.boundariesProvider);
        this.worldMapPane = new PDUWorldMapPane(new WorldMapPaneDataModel(), this.boundariesProvider, pduBoundaryOverlay);
        this.worldMapPane.setEnabled(false);
        return this.worldMapPane;
    }

    private JPanel createTargetDirPanel() {
        JPanel targetDirPanel = new JPanel(new BorderLayout(2, 2));
        targetDirPanel.setBorder(BorderFactory.createTitledBorder("Target Directory"));
        final JTextField textField = new JTextField();
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PDUStitchingPanel.this.model.setPropertyValue("targetDir", new File(textField.getText()));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PDUStitchingPanel.this.model.setPropertyValue("targetDir", new File(textField.getText()));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PDUStitchingPanel.this.model.setPropertyValue("targetDir", new File(textField.getText()));
            }
        });
        textField.setText(SystemUtils.getUserHomeDir().getPath());
        targetDirPanel.add((Component)textField, "Center");
        JButton etcButton = new JButton("...");
        Dimension size = new Dimension(26, 16);
        etcButton.setPreferredSize(size);
        etcButton.setMinimumSize(size);
        etcButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setAcceptAllFileFilterUsed(false);
            File currentFile = (File)this.model.getPropertyValue("targetDir");
            if (currentFile != null) {
                fileChooser.setSelectedFile(currentFile);
            }
            int i = fileChooser.showDialog(targetDirPanel, "Select");
            File selectedFile = fileChooser.getSelectedFile();
            if (i == 0 && selectedFile != null) {
                textField.setText(selectedFile.getAbsolutePath());
            }
        });
        targetDirPanel.add((Component)etcButton, "East");
        final JCheckBox openInAppCheckBox = new JCheckBox("Open in " + this.appContext.getApplicationName());
        openInAppCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PDUStitchingPanel.this.model.setOpenInApp(openInAppCheckBox.isSelected());
            }
        });
        targetDirPanel.add((Component)openInAppCheckBox, "South");
        return targetDirPanel;
    }

    private class SourceListDataListener
    implements ListDataListener {
        private SourceListDataListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent event) {
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    if (!PDUStitchingPanel.this.isReactingToChange) {
                        PDUStitchingPanel.this.isReactingToChange = true;
                        PDUStitchingPanel.this.boundariesProvider.clear();
                        Product[] sourceProducts = PDUStitchingPanel.this.sourceProductList.getSourceProducts();
                        String[] filePaths = (String[])PDUStitchingPanel.this.model.getPropertyValue("sourceProductPaths");
                        File[] productFiles = new File[sourceProducts.length];
                        for (int i = 0; i < sourceProducts.length; ++i) {
                            productFiles[i] = sourceProducts[i].getFileLocation();
                        }
                        Logger logger = Logger.getLogger(PDUStitchingPanel.class.getName());
                        Set dissolvedFilePaths = PDUStitchingOp.getSourceProductsPathFileSet((String[])filePaths, (Logger)logger);
                        File[] pathFiles = dissolvedFilePaths.toArray(new File[dissolvedFilePaths.size()]);
                        Product[] validatedProducts = new Product[]{};
                        String[] validatedPaths = new String[]{};
                        ArrayList<String> validatedFileNamesList = new ArrayList<String>();
                        ArrayList<Product> validatedProductsList = new ArrayList<Product>();
                        ArrayList<String> validatedPathsList = new ArrayList<String>();
                        ArrayList<File> validatedFilesList = new ArrayList<File>();
                        for (int i = 0; i < productFiles.length; ++i) {
                            File adjustedFile = productFiles[i].getName().equals("xfdumanifest.xml") ? productFiles[i] : new File(productFiles[i], "xfdumanifest.xml");
                            String adjustedFileName = adjustedFile.getAbsolutePath();
                            String origFileName = productFiles[i].getAbsolutePath();
                            if (validatedFileNamesList.contains(adjustedFileName)) {
                                Dialogs.showInformation((String)("Removed duplicate occurence of " + origFileName + " from selection."));
                                continue;
                            }
                            if (!SlstrL1bFileNameValidator.isValidSlstrL1BFile(productFiles[i])) {
                                Dialogs.showInformation((String)(origFileName + " is not a valid SLSTR L1B product. Removed from selection."));
                                continue;
                            }
                            validatedFileNamesList.add(adjustedFileName);
                            validatedProductsList.add(sourceProducts[i]);
                            validatedFilesList.add(adjustedFile);
                            boolean selected = PDUStitchingPanel.this.sourceProductList.isSelected((Object)sourceProducts[i]);
                            PDUStitchingPanel.this.boundariesProvider.extractBoundaryFromFile(productFiles[i], sourceProducts[i], selected);
                        }
                        for (File file : pathFiles) {
                            File adjustedFile = file.getName().equals("xfdumanifest.xml") ? file : new File(file, "xfdumanifest.xml");
                            String adjustedFileName = adjustedFile.getAbsolutePath();
                            String origFileName = file.getAbsolutePath();
                            if (validatedFileNamesList.contains(adjustedFileName)) {
                                Dialogs.showInformation((String)("Removed duplicate occurence of " + origFileName + " from selection."));
                                continue;
                            }
                            if (!SlstrL1bFileNameValidator.isValidSlstrL1BFile(file)) {
                                Dialogs.showInformation((String)(origFileName + " is not a valid SLSTR L1B product. Removed from selection."));
                                continue;
                            }
                            validatedFileNamesList.add(adjustedFileName);
                            validatedPathsList.add(origFileName);
                            validatedFilesList.add(adjustedFile);
                            boolean selected = PDUStitchingPanel.this.sourceProductList.isSelected((Object)file);
                            PDUStitchingPanel.this.boundariesProvider.extractBoundaryFromFile(file, file, selected);
                        }
                        if (validatedProductsList.size() > 0) {
                            validatedProducts = validatedProductsList.toArray(new Product[validatedProductsList.size()]);
                        }
                        if (validatedPathsList.size() > 0) {
                            validatedPaths = validatedPathsList.toArray(new String[validatedPathsList.size()]);
                        }
                        if (validatedFilesList.size() == 0) {
                            PDUStitchingPanel.this.statusLabel.setForeground(Color.BLACK);
                            PDUStitchingPanel.this.statusLabel.setText(PDUStitchingPanel.NO_SOURCE_PRODUCTS_TEXT);
                            PDUStitchingPanel.this.worldMapPane.setEnabled(false);
                        } else {
                            PDUStitchingPanel.this.worldMapPane.setEnabled(true);
                            try {
                                Validator.validate((File[])validatedFilesList.toArray(new File[validatedFilesList.size()]));
                                PDUStitchingPanel.this.statusLabel.setForeground(Color.GREEN.darker());
                                PDUStitchingPanel.this.statusLabel.setText(PDUStitchingPanel.VALID_SOURCE_PRODUCTS_TEXT);
                            }
                            catch (IOException e) {
                                PDUStitchingPanel.this.statusLabel.setForeground(Color.RED);
                                PDUStitchingPanel.this.statusLabel.setText(PDUStitchingPanel.INVALID_SELECTION_TEXT + e.getMessage());
                            }
                        }
                        PDUStitchingPanel.this.model.setPropertyValue("sourceProducts", validatedProducts);
                        if (validatedPaths.length != filePaths.length) {
                            PDUStitchingPanel.this.model.setPropertyValue("sourceProductPaths", validatedPaths);
                        }
                        PDUStitchingPanel.this.sourceProductList.bindComponents();
                        PDUStitchingPanel.this.isReactingToChange = false;
                    }
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        PDUStitchingPanel.this.worldMapPane.repaint();
                    }
                    catch (Exception e) {
                        String msg = String.format("Cannot display source product files.\n%s", e.getMessage());
                        PDUStitchingPanel.this.appContext.handleError(msg, (Throwable)e);
                    }
                }
            };
            worker.execute();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.contentsChanged(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }
    }

    private class SourceListSelectionListener
    implements ListSelectionListener {
        private SourceListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() instanceof JList) {
                JList list = (JList)e.getSource();
                List selectedValuesList = list.getSelectedValuesList();
                PDUStitchingPanel.this.boundariesProvider.setSelected(selectedValuesList);
                PDUStitchingPanel.this.worldMapPane.repaint();
            }
        }
    }
}

