/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import org.esa.s3tbx.slstr.pdu.stitching.ui.PDUStitchingModel;
import org.esa.s3tbx.slstr.pdu.stitching.ui.PDUStitchingPanel;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.util.ArrayUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModelessDialog;

public class PDUStitchingDialog
extends ModelessDialog {
    private final PDUStitchingModel formModel;

    public PDUStitchingDialog(String title, AppContext appContext, String helpID) {
        super(appContext.getApplicationWindow(), title, 24, helpID);
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi("PduStitching");
        this.formModel = new PDUStitchingModel();
        OperatorParameterSupport parameterSupport = new OperatorParameterSupport(operatorSpi.getOperatorDescriptor(), this.formModel.getPropertySet(), this.formModel.getParameterMap(), null);
        OperatorMenu operatorMenu = new OperatorMenu((Component)this.getJDialog(), operatorSpi.getOperatorDescriptor(), parameterSupport, appContext, helpID);
        this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
        AbstractButton button = this.getButton(8);
        button.setText("Run");
        button.setMnemonic('R');
        this.setContent(new PDUStitchingPanel(appContext, this.formModel));
    }

    protected void onApply() {
        block6: {
            try {
                String[] after;
                Object[] before = new String[]{};
                File targetDir = (File)this.formModel.getPropertyValue("targetDir");
                if (this.formModel.openInApp() && targetDir.exists()) {
                    before = targetDir.list();
                }
                ProductReaderPlugIn sen3ReaderPlugIn = this.getSentinel3ReaderPlugin();
                Map<String, Object> parameterMap = this.formModel.getParameterMap();
                Product[] sourceProducts = this.formModel.getSourceProducts();
                GPF.createProduct((String)"PduStitching", parameterMap, (Product[])sourceProducts);
                if (!this.formModel.openInApp()) break block6;
                for (String inTargetDir : after = targetDir.list()) {
                    if (ArrayUtils.isMemberOf((Object)inTargetDir, (Object[])before)) continue;
                    try {
                        ProductReader reader = sen3ReaderPlugIn.createReaderInstance();
                        Product product = reader.readProductNodes((Object)new File(targetDir, inTargetDir), null);
                        SnapApp.getDefault().getProductManager().addProduct(product);
                    }
                    catch (IOException e) {
                        Dialogs.showError((String)("Could not open stitched product " + inTargetDir + ": " + e.getMessage()));
                    }
                    break;
                }
            }
            catch (OperatorException e) {
                Dialogs.showInformation((String)"SLSTR L1B PDU Stitching", (String)("Could not create stitched SLSTR L1B product: " + e.getMessage()), null);
                return;
            }
        }
        Dialogs.showInformation((String)"SLSTR L1B PDU Stitching", (String)"Stitched SLSTR L1B product has been successfully created in the target directory.", null);
    }

    private ProductReaderPlugIn getSentinel3ReaderPlugin() {
        ProductIOPlugInManager ioPlugInManager = ProductIOPlugInManager.getInstance();
        Iterator sen3ReaderPlugins = ioPlugInManager.getReaderPlugIns("Sen3");
        if (!sen3ReaderPlugins.hasNext()) {
            throw new IllegalStateException("No appropriate reader for reading Sentinel-3 products found");
        }
        return (ProductReaderPlugIn)sen3ReaderPlugins.next();
    }
}

