/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.slstr.pdu.stitching.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.s3tbx.slstr.pdu.stitching.ui.SlstrL1bFileNameValidator;
import org.esa.snap.core.datamodel.GeoPos;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class PDUBoundariesProvider {
    private List<String> names = new ArrayList<String>();
    private List<Object> inputs = new ArrayList<Object>();
    private List<GeoPos[]> geoBoundaries = new ArrayList<GeoPos[]>();
    private List<Boolean> selected = new ArrayList<Boolean>();

    PDUBoundariesProvider() {
    }

    int getNumberOfElements() {
        return this.names.size();
    }

    void clear() {
        this.names.clear();
        this.inputs.clear();
        this.geoBoundaries.clear();
        this.selected.clear();
    }

    void extractBoundaryFromFile(File file, Object input, boolean isSelected) {
        File metadataFile;
        String directoryName;
        String fileName = file.getName();
        if (!fileName.equals("xfdumanifest.xml")) {
            directoryName = fileName;
            metadataFile = new File(file.getAbsolutePath(), "xfdumanifest.xml");
        } else {
            directoryName = file.getParentFile().getName();
            metadataFile = file;
        }
        if (!metadataFile.exists() || !SlstrL1bFileNameValidator.isValidSlstrL1BFile(metadataFile)) {
            return;
        }
        try {
            FileInputStream inputStream = new FileInputStream(metadataFile);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            NodeList posListElements = document.getElementsByTagName("gml:posList");
            if (posListElements.getLength() != 1) {
                return;
            }
            String[] geoPositions = posListElements.item(0).getTextContent().split(" ");
            if (geoPositions.length % 2 != 0) {
                return;
            }
            GeoPos[] geoBoundary = new GeoPos[geoPositions.length / 2];
            for (int i = 0; i < geoPositions.length / 2; ++i) {
                geoBoundary[i] = new GeoPos(Double.parseDouble(geoPositions[2 * i]), Double.parseDouble(geoPositions[2 * i + 1]));
            }
            this.names.add(directoryName);
            this.geoBoundaries.add(geoBoundary);
            this.selected.add(isSelected);
            this.inputs.add(input);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
    }

    String getName(int index) {
        return this.names.get(index);
    }

    GeoPos[] getGeoBoundary(int index) {
        return this.geoBoundaries.get(index);
    }

    boolean isSelected(int index) {
        return this.selected.get(index);
    }

    void setSelected(List selectedValuesList) {
        for (int i = 0; i < this.selected.size(); ++i) {
            this.selected.set(i, selectedValuesList.contains(this.inputs.get(i)));
        }
    }
}

