/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.mph_chl;

import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;

public class OlciBrrProduct {
    static Product create() {
        Product product = new Product("OLCI L1B BRR", "S3A_OL_1_EFR__", 2, 2);
        OlciBrrProduct.addBrr_07(product);
        OlciBrrProduct.addBrr_08(product);
        OlciBrrProduct.addBrr_10(product);
        OlciBrrProduct.addBrr_11(product);
        OlciBrrProduct.addBrr_12(product);
        OlciBrrProduct.addBrr_18(product);
        OlciBrrProduct.addQualityFlags(product);
        OlciBrrProduct.addFlagCodings(product);
        return product;
    }

    private static void addBrr_07(Product olciL1BProduct) {
        Band band = olciL1BProduct.addBand("rBRR_07", 30);
        ProductData rasterData = band.createCompatibleRasterData();
        rasterData.setElemFloatAt(0, 0.056901217f);
        rasterData.setElemFloatAt(1, 0.08701459f);
        rasterData.setElemFloatAt(2, 0.09533884f);
        rasterData.setElemFloatAt(3, 0.06557705f);
        band.setData(rasterData);
    }

    private static void addBrr_08(Product olciL1BProduct) {
        Band band = olciL1BProduct.addBand("rBRR_08", 30);
        ProductData rasterData = band.createCompatibleRasterData();
        rasterData.setElemFloatAt(0, 0.047871254f);
        rasterData.setElemFloatAt(1, 0.083326936f);
        rasterData.setElemFloatAt(2, 0.085396804f);
        rasterData.setElemFloatAt(3, 0.057835124f);
        band.setData(rasterData);
    }

    private static void addBrr_10(Product olciL1BProduct) {
        Band band = olciL1BProduct.addBand("rBRR_10", 30);
        ProductData rasterData = band.createCompatibleRasterData();
        rasterData.setElemFloatAt(0, 0.04565412f);
        rasterData.setElemFloatAt(1, 0.08187773f);
        rasterData.setElemFloatAt(2, 0.080895595f);
        rasterData.setElemFloatAt(3, 0.058175918f);
        band.setData(rasterData);
    }

    private static void addBrr_11(Product olciL1BProduct) {
        Band band = olciL1BProduct.addBand("rBRR_11", 30);
        ProductData rasterData = band.createCompatibleRasterData();
        rasterData.setElemFloatAt(0, 0.042183727f);
        rasterData.setElemFloatAt(1, 0.07923279f);
        rasterData.setElemFloatAt(2, 0.082916535f);
        rasterData.setElemFloatAt(3, 0.11774466f);
        band.setData(rasterData);
    }

    private static void addBrr_12(Product olciL1BProduct) {
        Band band = olciL1BProduct.addBand("rBRR_12", 30);
        ProductData rasterData = band.createCompatibleRasterData();
        rasterData.setElemFloatAt(0, 0.02940591f);
        rasterData.setElemFloatAt(1, 0.072338045f);
        rasterData.setElemFloatAt(2, 0.06302089f);
        rasterData.setElemFloatAt(3, 0.25775266f);
        band.setData(rasterData);
    }

    private static void addBrr_18(Product olciL1BProduct) {
        Band band = olciL1BProduct.addBand("rBRR_18", 30);
        ProductData rasterData = band.createCompatibleRasterData();
        rasterData.setElemFloatAt(0, 0.020540202f);
        rasterData.setElemFloatAt(1, 0.07036572f);
        rasterData.setElemFloatAt(2, 0.05602023f);
        rasterData.setElemFloatAt(3, 0.30576614f);
        band.setData(rasterData);
    }

    private static void addQualityFlags(Product olciL1BProduct) {
        Band band = olciL1BProduct.addBand("quality_flags", 12);
        ProductData rasterData = band.createCompatibleRasterData();
        rasterData.setElemIntAt(0, 2);
        rasterData.setElemIntAt(1, 0);
        rasterData.setElemIntAt(2, 0);
        rasterData.setElemIntAt(3, 16);
        band.setData(rasterData);
    }

    private static void addFlagCodings(Product olciL1BProduct) {
        FlagCoding quality_flags = new FlagCoding("quality_flags");
        quality_flags.addFlag("land", 16, "Pixel is over land, not ocean.");
        quality_flags.addFlag("invalid", 128, "Pixel is invalid.");
        olciL1BProduct.getBand("quality_flags").setSampleCoding((SampleCoding)quality_flags);
        olciL1BProduct.getFlagCodingGroup().add((ProductNode)quality_flags);
    }
}

