/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.mph_chl;

import org.esa.s3tbx.olci.mph_chl.MphChlOp;
import org.esa.s3tbx.olci.mph_chl.MphChlUtils;
import org.esa.s3tbx.olci.mph_chl.TestSample;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.junit.Assert;
import org.junit.Test;

public class MphChlUtilsTest {
    @Test
    public void testSetToInvalid() {
        WritableSample[] samples = MphChlUtilsTest.createSampleArray(6);
        MphChlUtils.setToInvalid((WritableSample[])samples, (boolean)false);
        Assert.assertEquals((double)Double.NaN, (double)samples[0].getDouble(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)samples[1].getDouble(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)samples[2].getDouble(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)samples[3].getDouble(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)samples[4].getDouble(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)samples[4].getDouble(), (double)1.0E-8);
    }

    @Test
    public void testSetToInvalid_withMph() {
        WritableSample[] samples = MphChlUtilsTest.createSampleArray(7);
        MphChlUtils.setToInvalid((WritableSample[])samples, (boolean)true);
        Assert.assertEquals((double)Double.NaN, (double)samples[0].getDouble(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)samples[1].getDouble(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)samples[2].getDouble(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)samples[3].getDouble(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)samples[4].getDouble(), (double)1.0E-8);
        Assert.assertEquals((double)Double.NaN, (double)samples[5].getDouble(), (double)1.0E-8);
    }

    @Test
    public void testComputeMph() {
        double mph = MphChlUtils.computeMph((double)1.0, (double)2.0, (double)3.0, (double)6.0, (double)4.0, (double)5.0);
        Assert.assertEquals((double)-3.0, (double)mph, (double)1.0E-8);
        mph = MphChlUtils.computeMph((double)0.0, (double)2.0, (double)3.0, (double)6.0, (double)4.0, (double)5.0);
        Assert.assertEquals((double)-4.0, (double)mph, (double)1.0E-8);
        mph = MphChlUtils.computeMph((double)1.0, (double)0.0, (double)3.0, (double)6.0, (double)4.0, (double)5.0);
        Assert.assertEquals((double)-5.0, (double)mph, (double)1.0E-8);
        mph = MphChlUtils.computeMph((double)1.0, (double)2.0, (double)0.0, (double)6.0, (double)4.0, (double)5.0);
        Assert.assertEquals((double)3.0, (double)mph, (double)1.0E-8);
        mph = MphChlUtils.computeMph((double)1.0, (double)2.0, (double)3.0, (double)6.0, (double)0.0, (double)5.0);
        Assert.assertEquals((double)-2.2, (double)mph, (double)1.0E-8);
        mph = MphChlUtils.computeMph((double)1.0, (double)2.0, (double)3.0, (double)6.0, (double)4.0, (double)0.0);
        Assert.assertEquals((double)-0.5, (double)mph, (double)1.0E-8);
        mph = MphChlUtils.computeMph((double)1.0, (double)2.0, (double)3.0, (double)0.0, (double)4.0, (double)5.0);
        Assert.assertEquals((double)3.0, (double)mph, (double)1.0E-8);
    }

    @Test
    public void testIsCyano_threeArgs() {
        Assert.assertFalse((boolean)MphChlUtils.isCyano((double)0.0, (double)1.0, (double)1.0));
        Assert.assertFalse((boolean)MphChlUtils.isCyano((double)0.5, (double)1.0, (double)1.0));
        Assert.assertTrue((boolean)MphChlUtils.isCyano((double)-0.1, (double)1.0, (double)1.0));
        Assert.assertFalse((boolean)MphChlUtils.isCyano((double)-1.0, (double)0.0, (double)1.0));
        Assert.assertFalse((boolean)MphChlUtils.isCyano((double)-1.0, (double)-0.1, (double)1.0));
        Assert.assertTrue((boolean)MphChlUtils.isCyano((double)-1.0, (double)0.5, (double)1.0));
        Assert.assertFalse((boolean)MphChlUtils.isCyano((double)-1.0, (double)1.0, (double)0.0));
        Assert.assertFalse((boolean)MphChlUtils.isCyano((double)-1.0, (double)1.0, (double)0.0019));
        Assert.assertTrue((boolean)MphChlUtils.isCyano((double)-1.0, (double)1.0, (double)0.0021));
    }

    @Test
    public void testIsCyano_twoArgs() {
        Assert.assertFalse((boolean)MphChlUtils.isCyano((double)1.0, (double)-1.0));
        Assert.assertFalse((boolean)MphChlUtils.isCyano((double)-0.1, (double)-1.0));
        Assert.assertFalse((boolean)MphChlUtils.isCyano((double)1.0, (double)0.1));
        Assert.assertTrue((boolean)MphChlUtils.isCyano((double)-0.1, (double)0.1));
    }

    @Test
    public void testComputeChlPolynomial() {
        Assert.assertEquals((double)353732.6926, (double)MphChlUtils.computeChlPolynomial((double)0.1), (double)1.0E-8);
        Assert.assertEquals((double)8.2646992, (double)MphChlUtils.computeChlPolynomial((double)0.001), (double)1.0E-8);
        Assert.assertEquals((double)1.9726, (double)MphChlUtils.computeChlPolynomial((double)0.0), (double)1.0E-8);
    }

    @Test
    public void testComputeChlExponential() {
        Assert.assertEquals((double)22.520456651295124, (double)MphChlUtils.computeChlExponential((double)1.0E-4), (double)1.0E-8);
        Assert.assertEquals((double)23.25767257114881, (double)MphChlUtils.computeChlExponential((double)0.001), (double)1.0E-8);
        Assert.assertEquals((double)22.44, (double)MphChlUtils.computeChlExponential((double)0.0), (double)1.0E-8);
    }

    @Test
    public void testEncodeFlags() {
        Assert.assertEquals((long)0L, (long)MphChlUtils.encodeFlags((boolean)false, (boolean)false, (boolean)false));
        Assert.assertEquals((long)1L, (long)MphChlUtils.encodeFlags((boolean)true, (boolean)false, (boolean)false));
        Assert.assertEquals((long)2L, (long)MphChlUtils.encodeFlags((boolean)false, (boolean)true, (boolean)false));
        Assert.assertEquals((long)4L, (long)MphChlUtils.encodeFlags((boolean)false, (boolean)false, (boolean)true));
        Assert.assertEquals((long)3L, (long)MphChlUtils.encodeFlags((boolean)true, (boolean)true, (boolean)false));
        Assert.assertEquals((long)5L, (long)MphChlUtils.encodeFlags((boolean)true, (boolean)false, (boolean)true));
    }

    @Test
    public void testSpi() {
        MphChlOp.Spi spi = new MphChlOp.Spi();
        Class operatorClass = spi.getOperatorClass();
        Assert.assertTrue((boolean)operatorClass.isAssignableFrom(MphChlOp.class));
    }

    private static TestSample[] createSampleArray(int numSamples) {
        TestSample[] samples = new TestSample[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            samples[i] = new TestSample();
        }
        return samples;
    }
}

