/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.mph_chl;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.esa.s3tbx.olci.mph_chl.MphChlOp;
import org.esa.s3tbx.olci.mph_chl.OlciBrrProduct;
import org.esa.s3tbx.olci.mph_chl.TestProductConfigurer;
import org.esa.s3tbx.olci.mph_chl.TestSourceSampleConfigurer;
import org.esa.s3tbx.olci.mph_chl.TestTargetSampleConfigurer;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MphChlOpTest {
    private MphChlOp mphChlOp;

    @Before
    public void setUp() {
        this.mphChlOp = new MphChlOp();
        this.mphChlOp.setSourceProduct(OlciBrrProduct.create());
        this.mphChlOp.setParameterDefaultValues();
    }

    @Test
    public void testOperatorMetadata() {
        OperatorMetadata operatorMetadata = MphChlOp.class.getAnnotation(OperatorMetadata.class);
        Assert.assertNotNull((Object)operatorMetadata);
        Assert.assertEquals((Object)"MphChl", (Object)operatorMetadata.alias());
        Assert.assertEquals((Object)"1.0", (Object)operatorMetadata.version());
        Assert.assertEquals((Object)"Mark William Matthews, Daniel Odermatt, Tom Block, Olaf Danne", (Object)operatorMetadata.authors());
        Assert.assertEquals((Object)"(c) 2013, 2014, 2017 by Brockmann Consult", (Object)operatorMetadata.copyright());
        Assert.assertEquals((Object)"Computes maximum peak height of chlorophyll for OLCI", (Object)operatorMetadata.description());
    }

    @Test
    public void testSourceProductAnnotation() throws NoSuchFieldException {
        Field productField = MphChlOp.class.getDeclaredField("sourceProduct");
        Assert.assertNotNull((Object)productField);
        SourceProduct productFieldAnnotation = productField.getAnnotation(SourceProduct.class);
        Assert.assertNotNull((Object)productFieldAnnotation);
        Assert.assertEquals((Object)"Name", (Object)productFieldAnnotation.alias());
    }

    @Test
    public void testInvalidPixelExpressionAnnotation() throws NoSuchFieldException {
        Field validPixelField = MphChlOp.class.getDeclaredField("validPixelExpression");
        Parameter annotation = validPixelField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"not (quality_flags.land or quality_flags.invalid)", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Expression defining pixels considered for processing.", (Object)annotation.description());
    }

    @Test
    public void testCyanoMaxValueAnnotation() throws NoSuchFieldException {
        Field cyanoMaxValueField = MphChlOp.class.getDeclaredField("cyanoMaxValue");
        Parameter annotation = cyanoMaxValueField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"1000.0", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Maximum chlorophyll, arithmetically higher values are capped.", (Object)annotation.description());
    }

    @Test
    public void testChlThreshForFloatFlagAnnotation() throws NoSuchFieldException {
        Field chlThreshForFloatFlagField = MphChlOp.class.getDeclaredField("chlThreshForFloatFlag");
        Parameter annotation = chlThreshForFloatFlagField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"350.0", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Chlorophyll threshold, above which all cyanobacteria dominated waters are 'float.", (Object)annotation.description());
    }

    @Test
    public void testExportMphAnnotation() throws NoSuchFieldException {
        Field exportMphField = MphChlOp.class.getDeclaredField("exportMph");
        Parameter annotation = exportMphField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"false", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Switch to true to write 'mph' band.", (Object)annotation.description());
    }

    @Test
    public void testConfigureTargetProduct() {
        TestProductConfigurer productConfigurer = new TestProductConfigurer();
        this.mphChlOp.configureTargetProduct((ProductConfigurer)productConfigurer);
        Product targetProduct = productConfigurer.getTargetProduct();
        Assert.assertNotNull((Object)targetProduct);
        Band chlBand = targetProduct.getBand("chl");
        Assert.assertNotNull((Object)chlBand);
        Assert.assertEquals((long)30L, (long)chlBand.getDataType());
        Assert.assertEquals((Object)"mg/m^3", (Object)chlBand.getUnit());
        Assert.assertEquals((double)Double.NaN, (double)chlBand.getGeophysicalNoDataValue(), (double)1.0E-8);
        Band immersed_cyanobacteriaBand = targetProduct.getBand("immersed_cyanobacteria");
        Assert.assertNotNull((Object)immersed_cyanobacteriaBand);
        Assert.assertEquals((long)10L, (long)immersed_cyanobacteriaBand.getDataType());
        Band floating_cyanobacteriaBand = targetProduct.getBand("floating_cyanobacteria");
        Assert.assertNotNull((Object)floating_cyanobacteriaBand);
        Assert.assertEquals((long)10L, (long)floating_cyanobacteriaBand.getDataType());
        Band floating_vegetationBand = targetProduct.getBand("floating_vegetation");
        Assert.assertNotNull((Object)floating_vegetationBand);
        Assert.assertEquals((long)10L, (long)floating_vegetationBand.getDataType());
        Band flagBand = targetProduct.getBand("mph_chl_flags");
        Assert.assertNotNull((Object)flagBand);
        Assert.assertEquals((long)10L, (long)flagBand.getDataType());
        Assert.assertTrue((boolean)productConfigurer.isCopyGeoCodingCalled());
        FlagCoding flagCoding = (FlagCoding)targetProduct.getFlagCodingGroup().get("mph_chl_flags");
        Assert.assertNotNull((Object)flagCoding);
        FlagCoding bandFlagcoding = flagBand.getFlagCoding();
        Assert.assertSame((Object)flagCoding, (Object)bandFlagcoding);
        MetadataAttribute cyanoFlag = flagCoding.getFlag("mph_cyano");
        Assert.assertEquals((Object)"mph_cyano", (Object)cyanoFlag.getName());
        Assert.assertEquals((Object)"Cyanobacteria dominated waters", (Object)cyanoFlag.getDescription());
        Assert.assertEquals((long)1L, (long)cyanoFlag.getData().getElemInt());
        MetadataAttribute floatingFlag = flagCoding.getFlag("mph_floating");
        Assert.assertNotNull((Object)floatingFlag);
        Assert.assertEquals((Object)"mph_floating", (Object)floatingFlag.getName());
        Assert.assertEquals((Object)"Floating vegetation or cyanobacteria on water surface", (Object)floatingFlag.getDescription());
        Assert.assertEquals((long)2L, (long)floatingFlag.getData().getElemInt());
        MetadataAttribute adjacencyFlag = flagCoding.getFlag("mph_adjacency");
        Assert.assertNotNull((Object)adjacencyFlag);
        Assert.assertEquals((Object)"mph_adjacency", (Object)adjacencyFlag.getName());
        Assert.assertEquals((Object)"Pixel suspect of adjacency effects", (Object)adjacencyFlag.getDescription());
        Assert.assertEquals((long)4L, (long)adjacencyFlag.getData().getElemInt());
        ProductNodeGroup maskGroup = targetProduct.getMaskGroup();
        Assert.assertNotNull((Object)maskGroup);
        Mask cyanoMask = (Mask)maskGroup.get("mph_cyano");
        Assert.assertNotNull((Object)cyanoMask);
        Assert.assertEquals((Object)"Cyanobacteria dominated waters", (Object)cyanoMask.getDescription());
        Assert.assertEquals((Object)Color.cyan, (Object)cyanoMask.getImageColor());
        Assert.assertEquals((double)0.5, (double)cyanoMask.getImageTransparency(), (double)1.0E-8);
        Mask floatingMask = (Mask)maskGroup.get("mph_floating");
        Assert.assertNotNull((Object)floatingMask);
        Assert.assertEquals((Object)"Floating vegetation or cyanobacteria on water surface", (Object)floatingMask.getDescription());
        Assert.assertEquals((Object)Color.green, (Object)floatingMask.getImageColor());
        Assert.assertEquals((double)0.5, (double)floatingMask.getImageTransparency(), (double)1.0E-8);
        Mask adjacencyMask = (Mask)maskGroup.get("mph_adjacency");
        Assert.assertNotNull((Object)adjacencyMask);
        Assert.assertEquals((Object)"Pixel suspect of adjacency effects", (Object)adjacencyMask.getDescription());
        Assert.assertEquals((Object)Color.red, (Object)adjacencyMask.getImageColor());
        Assert.assertEquals((double)0.5, (double)adjacencyMask.getImageTransparency(), (double)1.0E-8);
    }

    @Test
    public void testConfigureTargetProduct_withMphBand() {
        TestProductConfigurer productConfigurer = new TestProductConfigurer();
        this.mphChlOp.exportMph = true;
        this.mphChlOp.configureTargetProduct((ProductConfigurer)productConfigurer);
        Product targetProduct = productConfigurer.getTargetProduct();
        Assert.assertNotNull((Object)targetProduct);
        Band mphBand = targetProduct.getBand("mph");
        Assert.assertNotNull((Object)mphBand);
        Assert.assertEquals((long)30L, (long)mphBand.getDataType());
        Assert.assertEquals((Object)"dl", (Object)mphBand.getUnit());
        Assert.assertEquals((double)Double.NaN, (double)mphBand.getGeophysicalNoDataValue(), (double)1.0E-8);
    }

    @Test
    public void testConfigureSourceSample() {
        TestSourceSampleConfigurer sampleConfigurer = new TestSourceSampleConfigurer();
        this.mphChlOp.configureSourceSamples((SourceSampleConfigurer)sampleConfigurer);
        HashMap<Integer, String> sampleMap = sampleConfigurer.getSampleMap();
        Assert.assertEquals((Object)"rBRR_07", (Object)sampleMap.get(0));
        Assert.assertEquals((Object)"rBRR_08", (Object)sampleMap.get(1));
        Assert.assertEquals((Object)"rBRR_10", (Object)sampleMap.get(2));
        Assert.assertEquals((Object)"rBRR_11", (Object)sampleMap.get(3));
        Assert.assertEquals((Object)"rBRR_12", (Object)sampleMap.get(4));
        Assert.assertEquals((Object)"rBRR_18", (Object)sampleMap.get(5));
    }

    @Test
    public void testConfigureTargetSample() {
        TestTargetSampleConfigurer sampleConfigurer = new TestTargetSampleConfigurer();
        this.mphChlOp.configureTargetSamples((TargetSampleConfigurer)sampleConfigurer);
        HashMap<Integer, String> sampleMap = sampleConfigurer.getSampleMap();
        Assert.assertEquals((long)5L, (long)sampleMap.size());
        Assert.assertEquals((Object)"chl", (Object)sampleMap.get(0));
        Assert.assertEquals((Object)"mph_chl_flags", (Object)sampleMap.get(1));
        Assert.assertEquals((Object)"immersed_cyanobacteria", (Object)sampleMap.get(2));
        Assert.assertEquals((Object)"floating_cyanobacteria", (Object)sampleMap.get(3));
        Assert.assertEquals((Object)"floating_vegetation", (Object)sampleMap.get(4));
    }

    @Test
    public void testConfigureTargetSample_withMph() {
        TestTargetSampleConfigurer sampleConfigurer = new TestTargetSampleConfigurer();
        this.mphChlOp.exportMph = true;
        this.mphChlOp.configureTargetSamples((TargetSampleConfigurer)sampleConfigurer);
        HashMap<Integer, String> sampleMap = sampleConfigurer.getSampleMap();
        Assert.assertEquals((long)6L, (long)sampleMap.size());
        Assert.assertEquals((Object)"chl", (Object)sampleMap.get(0));
        Assert.assertEquals((Object)"mph_chl_flags", (Object)sampleMap.get(1));
        Assert.assertEquals((Object)"immersed_cyanobacteria", (Object)sampleMap.get(2));
        Assert.assertEquals((Object)"floating_cyanobacteria", (Object)sampleMap.get(3));
        Assert.assertEquals((Object)"floating_vegetation", (Object)sampleMap.get(4));
        Assert.assertEquals((Object)"mph", (Object)sampleMap.get(5));
    }
}

