/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.mph_chl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.olci.mph_chl.MphChlMasterOp;
import org.esa.s3tbx.olci.mph_chl.MphChlOp;
import org.esa.s3tbx.olci.mph_chl.OlciBrrProduct;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MphChlMasterOpTest {
    @Before
    public void setUp() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)new MphChlMasterOp.Spi());
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi((OperatorSpi)new MphChlOp.Spi());
    }

    @After
    public void tearDown() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)new MphChlMasterOp.Spi());
        GPF.getDefaultInstance().getOperatorSpiRegistry().removeOperatorSpi((OperatorSpi)new MphChlOp.Spi());
    }

    @Test
    public void testOperatorMetadata() {
        OperatorMetadata operatorMetadata = MphChlMasterOp.class.getAnnotation(OperatorMetadata.class);
        Assert.assertNotNull((Object)operatorMetadata);
        Assert.assertEquals((Object)"OlciMphChl", (Object)operatorMetadata.alias());
        Assert.assertEquals((Object)"1.0", (Object)operatorMetadata.version());
        Assert.assertEquals((Object)"Mark William Matthews, Daniel Odermatt, Tom Block, Olaf Danne", (Object)operatorMetadata.authors());
        Assert.assertEquals((Object)"(c) 2013, 2014, 2017 by Brockmann Consult", (Object)operatorMetadata.copyright());
        Assert.assertEquals((Object)"This operator computes maximum peak height of chlorophyll (MPH/CHL) from OLCI.", (Object)operatorMetadata.description());
    }

    @Test
    public void testSourceProductAnnotation() throws NoSuchFieldException {
        Field productField = MphChlMasterOp.class.getDeclaredField("sourceProduct");
        Assert.assertNotNull((Object)productField);
        SourceProduct productFieldAnnotation = productField.getAnnotation(SourceProduct.class);
        Assert.assertNotNull((Object)productFieldAnnotation);
    }

    @Test
    public void testInvalidPixelExpressionAnnotation() throws NoSuchFieldException {
        Field validPixelField = MphChlMasterOp.class.getDeclaredField("validPixelExpression");
        Parameter annotation = validPixelField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"not (quality_flags.land or quality_flags.invalid)", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Expression defining pixels considered for processing.", (Object)annotation.description());
    }

    @Test
    public void testCyanoMaxValueAnnotation() throws NoSuchFieldException {
        Field cyanoMaxValueField = MphChlMasterOp.class.getDeclaredField("cyanoMaxValue");
        Parameter annotation = cyanoMaxValueField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"1000.0", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Maximum chlorophyll, arithmetically higher values are capped.", (Object)annotation.description());
    }

    @Test
    public void testChlThreshForFloatFlagAnnotation() throws NoSuchFieldException {
        Field chlThreshForFloatFlagField = MphChlMasterOp.class.getDeclaredField("chlThreshForFloatFlag");
        Parameter annotation = chlThreshForFloatFlagField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"500.0", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Chlorophyll threshold, above which all cyanobacteria dominated waters are 'float.", (Object)annotation.description());
    }

    @Test
    public void testExportMphAnnotation() throws NoSuchFieldException {
        Field exportMphField = MphChlMasterOp.class.getDeclaredField("exportMph");
        Parameter annotation = exportMphField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"false", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Switch to true to write 'mph' band.", (Object)annotation.description());
    }

    @Test
    public void testApplyLowPassFilterAnnotation() throws NoSuchFieldException {
        Field applyLowPassFilterField = MphChlMasterOp.class.getDeclaredField("applyLowPassFilter");
        Parameter annotation = applyLowPassFilterField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"false", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Switch to true to apply a 3x3 low-pass filter on the result.", (Object)annotation.description());
    }

    @Test
    public void testComputeMphChlProduct() throws IOException {
        Product brrProduct = OlciBrrProduct.create();
        Product mphChlPixelProduct = GPF.createProduct((String)"MphChl", (Map)GPF.NO_PARAMS, (Product)brrProduct);
        Assert.assertNotNull((Object)mphChlPixelProduct);
        HashMap<String, Boolean> mphChlParams = new HashMap<String, Boolean>();
        mphChlParams.put("applyLowPassFilter", false);
        Product mphChlProduct = GPF.createProduct((String)"MphChl", mphChlParams, (Product)brrProduct);
        Assert.assertNotNull((Object)mphChlProduct);
        Band chlBand = mphChlProduct.getBand("chl");
        Assert.assertNotNull((Object)chlBand);
        Band chlPixelBand = mphChlPixelProduct.getBand("chl");
        Assert.assertNotNull((Object)chlPixelBand);
        Assert.assertEquals((double)chlBand.getSampleFloat(0, 0), (double)chlPixelBand.getSampleFloat(0, 0), (double)1.0E-8);
        Assert.assertEquals((double)chlBand.getSampleFloat(0, 1), (double)chlPixelBand.getSampleFloat(0, 1), (double)1.0E-8);
        Assert.assertEquals((double)chlBand.getSampleFloat(1, 0), (double)chlPixelBand.getSampleFloat(1, 0), (double)1.0E-8);
        Assert.assertEquals((double)chlBand.getSampleFloat(1, 1), (double)chlPixelBand.getSampleFloat(1, 1), (double)1.0E-8);
    }
}

