/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.productdb;

import java.util.HashMap;
import java.util.Vector;
import org.esa.s3tbx.dataio.modis.productdb.ModisBandDescription;
import org.esa.s3tbx.dataio.modis.productdb.ModisSpectralInfo;
import org.esa.s3tbx.dataio.modis.productdb.ModisTiePointDescription;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;

public class ModisProductDescription {
    private Vector _bandVec;
    private HashMap _bands = new HashMap();
    private HashMap _tiePoints;
    private Vector _tiePointVec;
    private String[] _geolocationDatasetNames;
    private String _externalGeolocationPattern;
    private boolean _flipTopDown;

    public ModisProductDescription() {
        this._bandVec = new Vector();
        this._tiePoints = new HashMap();
        this._tiePointVec = new Vector();
    }

    public void addBand(String name, String isSpectral, String scalingMethod, String scaleName, String offsetName, String unitName, String bandName, String descName) {
        this.addBand(new ModisBandDescription(name, isSpectral, scalingMethod, scaleName, offsetName, unitName, bandName, descName));
    }

    public void addBand(String name, String isSpectral, String scalingMethod, String scaleName, String offsetName, String unitName, String bandName, String descName, String spectralWaveLength, String spectralBandWidth, String spectralBandIndex) {
        ModisBandDescription bandDesc = new ModisBandDescription(name, isSpectral, scalingMethod, scaleName, offsetName, unitName, bandName, descName);
        bandDesc.setSpecInfo(new ModisSpectralInfo(spectralWaveLength, spectralBandWidth, spectralBandIndex));
        this.addBand(bandDesc);
    }

    private void addBand(ModisBandDescription bandDesc) {
        this._bandVec.add(bandDesc);
        this._bands.put(bandDesc.getName(), bandDesc);
    }

    public String[] getBandNames() {
        String[] strRet = new String[this._bandVec.size()];
        for (int n = 0; n < this._bandVec.size(); ++n) {
            strRet[n] = ((ModisBandDescription)this._bandVec.get(n)).getName();
        }
        return strRet;
    }

    public ModisBandDescription getBandDescription(String bandName) {
        return (ModisBandDescription)this._bands.get(bandName);
    }

    public void setGeolocationDatasetNames(String lat, String lon) {
        Guardian.assertNotNullOrEmpty((String)"lat", (String)lat);
        Guardian.assertNotNullOrEmpty((String)"lon", (String)lon);
        this.setGeolocationDatasetNames(new String[]{lat, lon});
    }

    public void setGeolocationDatasetNames(String[] geolocationDatasetNames) {
        Guardian.assertNotNull((String)"geolocationDatasetNames", (Object)geolocationDatasetNames);
        if (geolocationDatasetNames.length != 2) {
            throw new IllegalArgumentException("geolocationDatasetNames.length != 2");
        }
        Guardian.assertNotNull((String)"geolocationDatasetNames[0]", (Object)geolocationDatasetNames[0]);
        Guardian.assertNotNull((String)"geolocationDatasetNames[1]", (Object)geolocationDatasetNames[1]);
        this._geolocationDatasetNames = geolocationDatasetNames;
    }

    public String[] getGeolocationDatasetNames() {
        return this._geolocationDatasetNames;
    }

    public void setExternalGeolocationPattern(String externalGeolocationPattern) {
        Debug.trace((String)("ModisProductDescription.externalGeolocationPattern = " + externalGeolocationPattern));
        this._externalGeolocationPattern = externalGeolocationPattern;
    }

    public String getExternalGeolocationPattern() {
        return this._externalGeolocationPattern;
    }

    public boolean hasExternalGeolocation() {
        return this._externalGeolocationPattern != null;
    }

    void addTiePointGrid(ModisTiePointDescription desc) {
        this._tiePoints.put(desc.getName(), desc);
        this._tiePointVec.add(desc);
    }

    public String[] getTiePointNames() {
        String[] strRet = new String[this._tiePointVec.size()];
        for (int n = 0; n < this._tiePointVec.size(); ++n) {
            strRet[n] = ((ModisTiePointDescription)this._tiePointVec.get(n)).getName();
        }
        return strRet;
    }

    public ModisTiePointDescription getTiePointDescription(String name) {
        return (ModisTiePointDescription)this._tiePoints.get(name);
    }

    void setTopDownFlip(boolean bFlip) {
        this._flipTopDown = bFlip;
    }

    public boolean mustFlipTopDown() {
        return this._flipTopDown;
    }
}

