/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.productdb;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import org.esa.s3tbx.dataio.modis.ModisConstants;
import org.esa.s3tbx.dataio.modis.productdb.ModisBandDescription;
import org.esa.s3tbx.dataio.modis.productdb.ModisProductDescription;
import org.esa.s3tbx.dataio.modis.productdb.ModisTiePointDescription;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.CsvReader;

public class ModisProductDb {
    private static final String DB_PATH = "/org/esa/s3tbx/resources/modisdb";
    public static final int EXP_NUM_SDS_DEFAULT_RECORD = 9;
    public static final int EXP_NUM_SDS_SPECTRAL_RECORD = 12;
    private static final int EXP_NUM_GEO_RECORDS_MIN = 2;
    private static final int EXP_NUM_GEO_RECORDS_MAX = 3;
    private static final int EXP_NUM_FLIP_RECORDS = 2;
    private static final int EXP_NUM_TIEP_RECORDS = 5;
    private HashMap<String, String> _productTypes = null;
    private HashMap _productDescriptions = new HashMap();
    private Logger logger = SystemUtils.LOG;
    private static final String META_KEY = "META";
    private static final String SDS_KEY = "SDS";
    private static final String GEO_KEY = "GEO";
    private static final String FLIP_KEY = "FLIP";
    private static final String TIEPOINT_KEY = "TIEP";

    public static ModisProductDb getInstance() {
        return Holder.instance;
    }

    public boolean isSupportedProduct(String typeString) throws ProductIOException {
        this.ensureSupportedProductTypes();
        return this._productTypes.get(typeString) != null;
    }

    public String[] getSupportetProductTypes() throws ProductIOException {
        this.ensureSupportedProductTypes();
        Set<String> keySet = this._productTypes.keySet();
        String[] result = new String[keySet.size()];
        return keySet.toArray(result);
    }

    public String[] getBandNames(String prodType) {
        String[] bandNames = null;
        try {
            ModisProductDescription prod = this.getProductDescription(prodType);
            bandNames = prod.getBandNames();
        }
        catch (IOException e) {
            this.logger.severe("Unable to retrieve the band names for product of type '" + prodType + "'.");
        }
        return bandNames;
    }

    public ModisBandDescription getBandDescription(String prodType, String bandName) {
        ModisBandDescription bandDesc = null;
        try {
            ModisProductDescription prod = this.getProductDescription(prodType);
            bandDesc = prod.getBandDescription(bandName);
        }
        catch (IOException e) {
            this.logger.severe("Unable to retrieve information for band '" + bandName + "' of product type '" + prodType + "'.");
        }
        return bandDesc;
    }

    public String[] getTiePointNames(String prodType) {
        String[] tpNames = null;
        try {
            ModisProductDescription prod = this.getProductDescription(prodType);
            tpNames = prod.getTiePointNames();
        }
        catch (IOException e) {
            this.logger.severe("Unable to retrieve tie point names for product type '" + prodType + "'.");
        }
        return tpNames;
    }

    public ModisTiePointDescription getTiePointDescription(String prodType, String tpName) {
        ModisTiePointDescription tpDesc = null;
        try {
            ModisProductDescription prod = this.getProductDescription(prodType);
            tpDesc = prod.getTiePointDescription(tpName);
        }
        catch (IOException e) {
            this.logger.severe("Unable to retrieve description for tie point grid '" + tpName + "' of product type '" + prodType + "'.");
        }
        return tpDesc;
    }

    public String[] getGeolocationInformation(String prodType) {
        String[] strRet = null;
        try {
            ModisProductDescription prod = this.getProductDescription(prodType);
            strRet = prod.getGeolocationDatasetNames();
        }
        catch (IOException e) {
            this.logger.severe("Unable to retrieve geolocation information for product type '" + prodType + "'.");
        }
        return strRet;
    }

    public boolean mustFlip(String prodType) {
        boolean bRet = false;
        try {
            ModisProductDescription prod = this.getProductDescription(prodType);
            bRet = prod.mustFlipTopDown();
        }
        catch (IOException e) {
            this.logger.severe("Unable to retrieve flipping information for product type '" + prodType + "'.");
        }
        return bRet;
    }

    private ModisProductDb() {
    }

    private void ensureSupportedProductTypes() throws ProductIOException {
        if (this._productTypes == null) {
            try {
                this.loadProductTypes();
            }
            catch (IOException e) {
                throw new ProductIOException(e.getMessage());
            }
        }
    }

    private void loadProductTypes() throws IOException {
        this._productTypes = new HashMap();
        CsvReader reader = this.getCsvReader("products.dd");
        String[] records = reader.readRecord();
        while (records != null) {
            if (records.length == 2) {
                this._productTypes.put(records[0], records[1]);
            } else {
                this.logger.severe("Invalid number of records in MODISDB - please check the resources for correctness.");
            }
            records = reader.readRecord();
        }
        reader.close();
    }

    public ModisProductDescription getProductDescription(String prodType) throws MalformedURLException, IOException {
        Guardian.assertNotNull((String)"prodType", (Object)prodType);
        ModisProductDescription description = (ModisProductDescription)this._productDescriptions.get(prodType);
        if (description == null) {
            description = this.loadProductDescription(prodType);
        }
        return description;
    }

    private ModisProductDescription loadProductDescription(String prodType) throws MalformedURLException, IOException {
        String[] records;
        this.ensureSupportedProductTypes();
        ModisProductDescription description = new ModisProductDescription();
        String productFile = this._productTypes.get(prodType);
        CsvReader reader = this.getCsvReader(productFile);
        while ((records = reader.readRecord()) != null) {
            for (int n = 0; n < records.length; ++n) {
                if (!records[n].equalsIgnoreCase("*")) continue;
                records[n] = null;
            }
            if (records[0].equalsIgnoreCase(META_KEY)) continue;
            if (records[0].equalsIgnoreCase(SDS_KEY)) {
                if (records.length == 12) {
                    description.addBand(records[1], records[2], records[3], records[4], records[5], records[6], records[7], records[8], records[9], records[10], records[11]);
                    continue;
                }
                if (records.length == 9) {
                    description.addBand(records[1], records[2], records[3], records[4], records[5], records[6], records[7], records[8]);
                    continue;
                }
                this.logger.severe("Invalid number of records in SDS description for product type '" + prodType + "'.");
                continue;
            }
            if (records[0].equalsIgnoreCase(GEO_KEY)) {
                if (records.length < 2 || records.length > 3) {
                    this.logger.severe("Invalid number of records in GEO description for product type '" + prodType + "'.");
                    continue;
                }
                if (records.length == 3) {
                    description.setGeolocationDatasetNames(records[1], records[2]);
                    continue;
                }
                description.setExternalGeolocationPattern(records[1]);
                continue;
            }
            if (records[0].equalsIgnoreCase(FLIP_KEY)) {
                if (records.length == 2) {
                    description.setTopDownFlip(Boolean.valueOf(records[1]));
                    continue;
                }
                this.logger.severe("Invalid number of records in FLIP description for product type '" + prodType + "'.");
                continue;
            }
            if (!records[0].equalsIgnoreCase(TIEPOINT_KEY)) continue;
            if (records.length == 5) {
                description.addTiePointGrid(new ModisTiePointDescription(records[1], records[2], records[3], records[4]));
                continue;
            }
            this.logger.severe("Invalid number of records in TIEP description for product type '" + prodType + "'.");
        }
        reader.close();
        this._productDescriptions.put(prodType, description);
        return description;
    }

    private CsvReader getCsvReader(String filename) throws IOException {
        CsvReader reader;
        URL dbResource = this.getDatabaseResource(filename);
        try {
            reader = new CsvReader((Reader)new InputStreamReader(dbResource.openStream()), ModisConstants.FIELD_SEPARATORS, true, "#");
        }
        catch (MalformedURLException e) {
            throw new IOException(e.getMessage());
        }
        return reader;
    }

    private URL getDatabaseResource(String resourcePath) throws IOException {
        String databasePath = "/org/esa/s3tbx/resources/modisdb/" + resourcePath;
        Debug.trace((String)("MODISDB: searching for resource file '" + databasePath + "'"));
        URL url = ModisProductDb.class.getResource(databasePath);
        if (url == null) {
            throw new IOException("MODISDB resource not found: missing file " + url);
        }
        return url;
    }

    private static class Holder {
        private static final ModisProductDb instance = new ModisProductDb();

        private Holder() {
        }
    }
}

