/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.productdb;

import org.esa.s3tbx.dataio.modis.productdb.ModisSpectralInfo;

public class ModisBandDescription {
    private String _name;
    private boolean isSpectral;
    private String scaleMethod;
    private String _scaleName;
    private String _offsetName;
    private String _unitName;
    private String _bandName;
    private String _descName;
    private ModisSpectralInfo _specInfo;

    public ModisBandDescription(String name, String isSpectral, String scalingMethod, String scaleName, String offsetName, String unitName, String bandName, String descName) {
        this._name = name;
        this.isSpectral = isSpectral != null && isSpectral.equalsIgnoreCase("true");
        this.scaleMethod = scalingMethod;
        this._scaleName = scaleName;
        this._offsetName = offsetName;
        this._unitName = unitName;
        this._bandName = bandName;
        this._descName = descName;
    }

    public String getName() {
        return this._name;
    }

    public String getScalingMethod() {
        return this.scaleMethod;
    }

    public String getOffsetAttribName() {
        return this._offsetName;
    }

    public String getScaleAttribName() {
        return this._scaleName;
    }

    public String getUnitAttribName() {
        return this._unitName;
    }

    public String getBandAttribName() {
        return this._bandName;
    }

    public boolean isSpectral() {
        return this.isSpectral;
    }

    public String getDescriptionAttribName() {
        return this._descName;
    }

    public void setSpecInfo(ModisSpectralInfo specInfo) {
        this._specInfo = specInfo;
    }

    public ModisSpectralInfo getSpecInfo() {
        return this._specInfo;
    }

    public boolean hasSpectralInfo() {
        return this._specInfo != null;
    }

    public boolean isExponentialScaled() {
        return "exp".equalsIgnoreCase(this.scaleMethod);
    }

    public boolean isLinearScaled() {
        return "lin".equalsIgnoreCase(this.scaleMethod);
    }

    public boolean isLinearInvertedScaled() {
        return "lin_inv".equalsIgnoreCase(this.scaleMethod);
    }

    public boolean isSlopeInterceptScaled() {
        return "sli".equalsIgnoreCase(this.scaleMethod);
    }

    public boolean isPow10Scaled() {
        return "p10".equalsIgnoreCase(this.scaleMethod);
    }
}

