/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.netcdf;

import java.io.IOException;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFAttributes;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.ProductData;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class NetCDFUtils {
    public static String getNamedStringAttribute(String bandNameAttribName, NetCDFAttributes attributes) {
        String attributeValue = "";
        Attribute attribute = attributes.get(bandNameAttribName);
        if (attribute != null) {
            attributeValue = attribute.getStringValue();
        }
        return attributeValue;
    }

    public static MetadataAttribute toMetadataAttribute(Attribute attribute) {
        ProductData prodData;
        MetadataAttribute attrib = null;
        DataType dataType = attribute.getDataType();
        switch (dataType) {
            case STRING: {
                prodData = ProductData.createInstance((String)attribute.getStringValue());
                break;
            }
            case BYTE: 
            case INT: {
                int[] intValues = NetCDFUtils.getIntValues(attribute);
                prodData = ProductData.createInstance((int[])intValues);
                break;
            }
            case FLOAT: {
                float[] floatValues = NetCDFUtils.getFloatValues(attribute);
                prodData = ProductData.createInstance((float[])floatValues);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = NetCDFUtils.getDoubleValues(attribute);
                prodData = ProductData.createInstance((double[])doubleValues);
                break;
            }
            default: {
                System.out.println("dataType = " + dataType);
                throw new NotImplementedException();
            }
        }
        if (prodData != null) {
            attrib = new MetadataAttribute(attribute.getShortName(), prodData, true);
        }
        return attrib;
    }

    public static MetadataAttribute toMetadataAttribute(Variable variable) throws IOException {
        String variableValue = variable.readScalarString();
        ProductData prodData = ProductData.createInstance((String)variableValue);
        return new MetadataAttribute(variable.getFullName(), prodData, true);
    }

    public static float[] getFloatValues(Attribute attribute) {
        Array values = attribute.getValues();
        long size = values.getSize();
        float[] result = new float[(int)size];
        int i = 0;
        while ((long)i < size) {
            result[i] = values.getFloat(i);
            ++i;
        }
        return result;
    }

    public static double[] getDoubleValues(Attribute attribute) {
        Array values = attribute.getValues();
        long size = values.getSize();
        double[] result = new double[(int)size];
        int i = 0;
        while ((long)i < size) {
            result[i] = values.getDouble(i);
            ++i;
        }
        return result;
    }

    public static int[] getIntValues(Attribute attribute) {
        Array values = attribute.getValues();
        long size = values.getSize();
        int[] result = new int[(int)size];
        int i = 0;
        while ((long)i < size) {
            result[i] = values.getInt(i);
            ++i;
        }
        return result;
    }
}

