/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.hdf;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.esa.s3tbx.dataio.modis.hdf.HdfDataField;
import org.esa.s3tbx.dataio.modis.hdf.HdfDimension;
import org.esa.s3tbx.dataio.modis.hdf.HdfDimensionMap;
import org.esa.snap.core.dataio.IllegalFileFormatException;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.dataop.maptransf.CartographicMapTransform;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.dataop.maptransf.MapInfo;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.MapTransform;
import org.esa.snap.core.dataop.maptransf.MapTransformDescriptor;
import org.esa.snap.core.dataop.maptransf.MapTransformUI;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.core.util.StringUtils;

public class HdfEosStructMetadata {
    private EosMetadata eosMetadata;

    public HdfEosStructMetadata(String structMetaString) throws ProductIOException {
        this.parse(structMetaString);
    }

    public HdfDataField getDatafield(String name) {
        return this.eosMetadata.getDatafield(name);
    }

    public Dimension getProductDimensions() {
        return this.eosMetadata.getProductDimensions();
    }

    public int[] getSubsamplingAndOffset(String dimName) {
        return this.eosMetadata.getSubsamplingAndOffset(dimName);
    }

    public String getEosType() {
        return this.eosMetadata.getEosType();
    }

    public GeoCoding createGeocoding() {
        return this.eosMetadata.createGeocoding();
    }

    private void parse(String metaString) throws ProductIOException {
        String ssStartKey = "GROUP=SwathStructure";
        String ssEndKey = "END_GROUP=SwathStructure";
        String gsStartKey = "GROUP=GridStructure";
        String gsEndKey = "END_GROUP=GridStructure";
        String psStartKey = "GROUP=PointStructure";
        String psEndKey = "END_GROUP=PointStructure";
        int ssStartIdx = metaString.indexOf("GROUP=SwathStructure") + "GROUP=SwathStructure".length();
        int ssEndIdx = metaString.indexOf("END_GROUP=SwathStructure");
        int gsStartIdx = metaString.indexOf("GROUP=GridStructure") + "GROUP=GridStructure".length();
        int gsEndIdx = metaString.indexOf("END_GROUP=GridStructure");
        int psStartIdx = metaString.indexOf("GROUP=PointStructure") + "GROUP=PointStructure".length();
        int psEndIdx = metaString.indexOf("END_GROUP=PointStructure");
        String swathStructureMetadata = metaString.substring(ssStartIdx, ssEndIdx).trim();
        String gridStructureMetadata = metaString.substring(gsStartIdx, gsEndIdx).trim();
        String pointStructureMetadata = metaString.substring(psStartIdx, psEndIdx).trim();
        if (this.isGridStructure(gridStructureMetadata)) {
            this.eosMetadata = GridMetadata.parse(gridStructureMetadata);
        } else if (this.isSwathStructure(swathStructureMetadata)) {
            this.eosMetadata = SwathMetadata.parse(swathStructureMetadata);
        } else if (this.isPointStructure(pointStructureMetadata)) {
            this.eosMetadata = PointMetadata.parse(pointStructureMetadata);
        }
    }

    private boolean isPointStructure(String pointStructureMetadata) {
        return pointStructureMetadata != null && pointStructureMetadata.length() > 0;
    }

    private boolean isGridStructure(String gridStructureMetadata) {
        return gridStructureMetadata != null && gridStructureMetadata.length() > 0;
    }

    private boolean isSwathStructure(String swathStructureMetadata) {
        return swathStructureMetadata != null && swathStructureMetadata.length() > 0;
    }

    private static String getAssignedValue(String line) {
        int posEqual = line.indexOf(61);
        String value = line.substring(posEqual + 1, line.length());
        if ((value = value.trim()).startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private static void parseDimensionGroup(LineNumberReader reader, Map<String, HdfDimension> dimensions) throws IOException {
        String line;
        HdfDimension dim = null;
        String name = "";
        String value = "";
        while (!(line = reader.readLine()).contains("END_GROUP")) {
            if ((line = line.trim()).contains("DimensionName")) {
                name = HdfEosStructMetadata.getAssignedValue(line);
                continue;
            }
            if (line.contains("Size")) {
                value = HdfEosStructMetadata.getAssignedValue(line);
                continue;
            }
            if (line.contains("END_OBJECT")) {
                if (dim == null) continue;
                dim.setName(name);
                dim.setValue(Integer.parseInt(value));
                dimensions.put(name, dim);
                continue;
            }
            if (!line.contains("OBJECT")) continue;
            dim = new HdfDimension();
        }
    }

    private static void parseDimensionMapGroup(LineNumberReader reader, Map<String, HdfDimensionMap> dimensionMaps) throws IOException {
        String line;
        HdfDimensionMap dim = null;
        while (!(line = reader.readLine()).contains("END_GROUP")) {
            if ((line = line.trim()).startsWith("GeoDimension")) {
                dim.setGeoDim(HdfEosStructMetadata.getAssignedValue(line));
                continue;
            }
            if (line.startsWith("DataDimension")) {
                dim.setDataDim(HdfEosStructMetadata.getAssignedValue(line));
                continue;
            }
            if (line.startsWith("Offset")) {
                dim.setOffset(Integer.parseInt(HdfEosStructMetadata.getAssignedValue(line)));
                continue;
            }
            if (line.startsWith("Increment")) {
                dim.setIncrement(Integer.parseInt(HdfEosStructMetadata.getAssignedValue(line)));
                continue;
            }
            if (line.startsWith("END_OBJECT")) {
                String geoDim = dim.getGeoDim();
                if (geoDim == null || "".equals(geoDim)) continue;
                dimensionMaps.put(geoDim, dim);
                dim = null;
                continue;
            }
            if (!line.startsWith("OBJECT")) continue;
            dim = new HdfDimensionMap();
        }
    }

    private static void parseDataFields(LineNumberReader reader, Map<String, HdfDataField> target, Map<String, HdfDimension> dimensions) throws IOException {
        String line;
        HdfDataField field = null;
        while (!(line = reader.readLine()).contains("END_GROUP")) {
            if ((line = line.trim()).startsWith("GeoFieldName") || line.contains("DataFieldName")) {
                field.setName(HdfEosStructMetadata.getAssignedValue(line));
                continue;
            }
            if (line.startsWith("DataType")) continue;
            if (line.startsWith("DimList")) {
                String dimList = HdfEosStructMetadata.getAssignedValue(line);
                String[] dimNames = HdfEosStructMetadata.parseValues(dimList);
                field.setDimensionNames(dimNames);
                int[] dims = HdfEosStructMetadata.decodeDimNames(dimensions, dimNames);
                if (dims.length == 1) {
                    field.setWidth(dims[0]);
                    continue;
                }
                if (dims.length == 2) {
                    field.setHeight(dims[0]);
                    field.setWidth(dims[1]);
                    continue;
                }
                if (dims.length != 3) continue;
                field.setLayers(dims[0]);
                field.setHeight(dims[1]);
                field.setWidth(dims[2]);
                continue;
            }
            if (line.startsWith("END_OBJECT")) {
                if (field == null) continue;
                target.put(field.getName(), field);
                field = null;
                continue;
            }
            if (!line.startsWith("OBJECT")) continue;
            field = new HdfDataField();
        }
    }

    private static int[] decodeDimNames(Map<String, HdfDimension> _dimensions, String[] dimNames) {
        int[] ints = new int[dimNames.length];
        for (int i = 0; i < dimNames.length; ++i) {
            HdfDimension dim = _dimensions.get(dimNames[i]);
            if (dim == null) continue;
            ints[i] = dim.getValue();
        }
        return ints;
    }

    private static String[] parseValues(String values) {
        ArrayList tokens = new ArrayList();
        StringUtils.split((String)values, (char[])new char[]{'(', '\"', ',', ')'}, (boolean)true, tokens);
        while (tokens.contains("")) {
            tokens.remove("");
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static class PointMetadata
    implements EosMetadata {
        private PointMetadata() {
        }

        @Override
        public HdfDataField getDatafield(String name) {
            return null;
        }

        @Override
        public Dimension getProductDimensions() {
            return null;
        }

        @Override
        public int[] getSubsamplingAndOffset(String dimName) {
            return new int[0];
        }

        @Override
        public String getEosType() {
            return "EOS_TYPE_POINT";
        }

        @Override
        public GeoCoding createGeocoding() {
            return null;
        }

        public static EosMetadata parse(String pointStructureMetadata) {
            return new PointMetadata();
        }
    }

    private static class GridMetadata
    implements EosMetadata {
        public static final String KEY_XDIM = "XDim";
        public static final String KEY_YDIM = "YDim";
        public static final String KEY_UL_METERS = "UpperLeftPointMtrs";
        public static final String KEY_LR_METERS = "LowerRightMtrs";
        public static final String KEY_PROJECTION = "Projection";
        public static final String KEY_PROJ_PARAMS = "ProjParams";
        public static final String KEY_SPHERE_CODE = "SphereCode";
        public static final String KEY_GRID_ORIGIN = "GridOrigin";
        public static final String KEY_PIXEL_ORIGIN = "PixelRegistration";
        public static final String GRID_ORIGIN_UPPER_LEFT = "HDFE_GD_UL";
        public static final String GRID_ORIGIN_UPPER_RIGHT = "HDFE_GD_UR";
        public static final String GRID_ORIGIN_LOWER_LEFT = "HDFE_GD_LL";
        public static final String GRID_ORIGIN_LOWER_RIGHT = "HDFE_GD_LR";
        private final Dimension _productDimension;
        private final HashMap<String, HdfDataField> _dataFields;
        private final GeoCodingParams _geoCodingParams;

        public GridMetadata(Dimension productDimension, HashMap<String, HdfDataField> dataFields, GeoCodingParams geoCodingParams) {
            this._productDimension = productDimension;
            this._dataFields = dataFields;
            this._geoCodingParams = geoCodingParams;
            this._geoCodingParams.setProductDimension(productDimension);
        }

        @Override
        public HdfDataField getDatafield(String name) {
            return this._dataFields.get(name);
        }

        @Override
        public Dimension getProductDimensions() {
            return new Dimension(this._productDimension.width, this._productDimension.height);
        }

        @Override
        public int[] getSubsamplingAndOffset(String dimName) {
            boolean subsampling = true;
            boolean offset = false;
            return new int[]{1, 0};
        }

        @Override
        public String getEosType() {
            return "EOS_TYPE_GRID";
        }

        @Override
        public GeoCoding createGeocoding() {
            return this._geoCodingParams.createGeocoding();
        }

        public static EosMetadata parse(String gridStructureMetadata) throws ProductIOException {
            Dimension productDimension = new Dimension();
            HashMap<String, HdfDataField> dataFields = new HashMap<String, HdfDataField>();
            HashMap<String, HdfDimension> dimensions = new HashMap<String, HdfDimension>();
            GeoCodingParams geoCodingParams = new GeoCodingParams();
            LineNumberReader reader = new LineNumberReader(new StringReader(gridStructureMetadata));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    int dimVal;
                    line = line.trim();
                    String value = HdfEosStructMetadata.getAssignedValue(line);
                    if (line.startsWith(KEY_XDIM)) {
                        dimVal = Integer.parseInt(value);
                        GridMetadata.addDimension(dimensions, KEY_XDIM, dimVal);
                        productDimension.width = dimVal;
                        continue;
                    }
                    if (line.startsWith(KEY_YDIM)) {
                        dimVal = Integer.parseInt(value);
                        GridMetadata.addDimension(dimensions, KEY_YDIM, dimVal);
                        productDimension.height = dimVal;
                        continue;
                    }
                    if (line.startsWith(KEY_UL_METERS)) {
                        geoCodingParams.setUlMeters(GridMetadata.getDoubles(value));
                        continue;
                    }
                    if (line.startsWith(KEY_LR_METERS)) {
                        geoCodingParams.setLrMeters(GridMetadata.getDoubles(value));
                        continue;
                    }
                    if (line.startsWith(KEY_PROJECTION)) {
                        geoCodingParams.setProjection(value);
                        continue;
                    }
                    if (line.startsWith(KEY_PROJ_PARAMS)) {
                        geoCodingParams.setProjParams(GridMetadata.getDoubles(value));
                        continue;
                    }
                    if (line.startsWith(KEY_SPHERE_CODE)) {
                        geoCodingParams.setSphereCode(value);
                        continue;
                    }
                    if (line.startsWith(KEY_GRID_ORIGIN)) {
                        geoCodingParams.setGridOrigin(value);
                        continue;
                    }
                    if (line.startsWith(KEY_PIXEL_ORIGIN)) {
                        geoCodingParams.setPixelOrigin(value);
                        continue;
                    }
                    if (!line.startsWith("GROUP") || !value.equalsIgnoreCase("DataField")) continue;
                    HdfEosStructMetadata.parseDataFields(reader, dataFields, dimensions);
                }
            }
            catch (IOException e) {
                throw new IllegalFileFormatException(e.getMessage());
            }
            return new GridMetadata(productDimension, dataFields, geoCodingParams);
        }

        private static void addDimension(HashMap<String, HdfDimension> dimensions, String dimName, int dimVal) {
            HdfDimension dimension = new HdfDimension(dimName, dimVal);
            dimensions.put(dimension.getName(), dimension);
        }

        private static double[] getDoubles(String value) {
            return GridMetadata.getDoubles(value, null);
        }

        private static double[] getDoubles(String value, double[] target) {
            String[] values = HdfEosStructMetadata.parseValues(value);
            if (target == null || target.length != values.length) {
                target = new double[values.length];
            }
            for (int i = 0; i < target.length; ++i) {
                target[i] = Double.parseDouble(values[i]);
            }
            return target;
        }

        private static class GeoCodingParams {
            private Dimension productDimension;
            private double[] ulMeters = null;
            private double[] lrMeters = null;
            private String projection = null;
            private double[] projParams = null;
            private String sphereCode = null;
            private String gridOrigin = null;
            private String pixelOrigin = null;

            private GeoCodingParams() {
            }

            public void setProductDimension(Dimension productDimension) {
                this.productDimension = productDimension;
            }

            public void setUlMeters(double[] ulMeters) {
                this.ulMeters = ulMeters;
            }

            public void setLrMeters(double[] lrMeters) {
                this.lrMeters = lrMeters;
            }

            public void setProjection(String projection) {
                this.projection = projection;
            }

            public void setProjParams(double[] projParams) {
                this.projParams = projParams;
            }

            public void setSphereCode(String sphereCode) {
                this.sphereCode = sphereCode;
            }

            public void setGridOrigin(String gridOrigin) {
                this.gridOrigin = gridOrigin;
            }

            public void setPixelOrigin(String pixelOrigin) {
                this.pixelOrigin = pixelOrigin;
            }

            public GeoCoding createGeocoding() {
                String mapProjectionName = "Sinusoidal";
                SinMapTransform mapAlgorithm = new SinMapTransform(this.projParams);
                MapProjection mapProjection = new MapProjection("Sinusoidal", (MapTransform)mapAlgorithm);
                int w = this.productDimension.width;
                int h = this.productDimension.height;
                double ulx = this.ulMeters[0];
                double uly = this.ulMeters[1];
                double lrx = this.lrMeters[0];
                double lry = this.lrMeters[1];
                double xMeters = lrx - ulx;
                double yMeters = uly - lry;
                float pixelX = 0.5f;
                float pixelY = 0.5f;
                float easting = (float)ulx;
                float northing = (float)uly;
                float pixelSizeX = (float)(xMeters / (double)w);
                float pixelSizeY = (float)(yMeters / (double)h);
                MapInfo mapInfo = new MapInfo(mapProjection, 0.5f, 0.5f, easting, northing, pixelSizeX, pixelSizeY, Datum.WGS_84);
                mapInfo.setSceneWidth(this.productDimension.width);
                mapInfo.setSceneHeight(this.productDimension.height);
                mapInfo.setOrientation(0.0f);
                return new MapGeoCoding(mapInfo);
            }

            private static class SinMapTransform
            extends CartographicMapTransform {
                private final double[] projectionParameters;

                protected SinMapTransform(double[] projectionParameters) {
                    super(0.0, 0.0, 0.0, projectionParameters[0]);
                    this.projectionParameters = projectionParameters;
                }

                protected Point2D forward_impl(double lat, double lon, Point2D mapPoint) {
                    double phi = Math.toRadians(lat);
                    double lam = Math.toRadians(lon);
                    double cosphi = Math.cos(phi);
                    double x = (lam - this._centralMeridian) * cosphi;
                    double y = phi;
                    if (mapPoint == null) {
                        mapPoint = new Point2D.Double();
                    }
                    mapPoint.setLocation(x, y);
                    return mapPoint;
                }

                protected GeoPos inverse_impl(double x, double y, GeoPos geoPoint) {
                    double cm = this._centralMeridian;
                    double phi = y;
                    double lam = cm + x / Math.cos(phi);
                    if (geoPoint == null) {
                        geoPoint = new GeoPos();
                    }
                    geoPoint.setLocation(Math.toDegrees(phi), Math.toDegrees(lam));
                    return geoPoint;
                }

                public MapTransformDescriptor getDescriptor() {
                    return new MapTransformDescriptor(){
                        public static final String TYPE_ID = "Sinusuidal";
                        public static final String NAME = "Sinusuidal";
                        public static final String MAP_UNIT = "meter";
                        public static final double semiMajor = 6371007.181;
                        public static final double VAL = 0.0;

                        public void registerProjections() {
                        }

                        public MapTransform createTransform(double[] parameterValues) {
                            return new SinMapTransform(parameterValues);
                        }

                        public String getTypeID() {
                            return "Sinusuidal";
                        }

                        public String getName() {
                            return "Sinusuidal";
                        }

                        public String getMapUnit() {
                            return MAP_UNIT;
                        }

                        public double[] getParameterDefaultValues() {
                            return new double[]{6371007.181, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                        }

                        public Parameter[] getParameters() {
                            Parameter parameter = new Parameter("SemiMajor", (Object)6371007.181);
                            parameter.getProperties().setLabel("semiMajor");
                            parameter.getProperties().setPhysicalUnit("meters");
                            return new Parameter[]{parameter};
                        }

                        public boolean hasTransformUI() {
                            return false;
                        }

                        public MapTransformUI getTransformUI(MapTransform transform) {
                            return null;
                        }
                    };
                }

                public double[] getParameterValues() {
                    double[] doubles = new double[this.projectionParameters.length];
                    System.arraycopy(this.projectionParameters, 0, doubles, 0, doubles.length);
                    return doubles;
                }

                public MapTransform createDeepClone() {
                    return new SinMapTransform(this.getParameterValues());
                }
            }
        }
    }

    private static class SwathMetadata
    implements EosMetadata {
        private final Map<String, HdfDataField> _dataFields;
        private final Map<String, HdfDimensionMap> _dimensionMaps;
        private final Map<String, HdfDataField> _geoFields;

        public SwathMetadata(Map<String, HdfDataField> dataFields, Map<String, HdfDimensionMap> dimensionMaps, Map<String, HdfDataField> geoFields) {
            this._dataFields = dataFields;
            this._dimensionMaps = dimensionMaps;
            this._geoFields = geoFields;
        }

        @Override
        public HdfDataField getDatafield(String name) {
            HdfDataField dfRet = this._dataFields.get(name);
            if (dfRet != null) {
                return dfRet;
            }
            return this._geoFields.get(name);
        }

        @Override
        public Dimension getProductDimensions() {
            Iterator<HdfDataField> it = this._dataFields.values().iterator();
            int width = -1;
            int height = -1;
            while (it.hasNext()) {
                HdfDataField data = it.next();
                width = Math.max(width, data.getWidth());
                height = Math.max(height, data.getHeight());
            }
            return new Dimension(width, height);
        }

        @Override
        public int[] getSubsamplingAndOffset(String dimName) {
            HdfDimensionMap dim = this._dimensionMaps.get(dimName);
            if (dim != null) {
                int subsampling = dim.getIncrement();
                int offset = dim.getOffset();
                return new int[]{subsampling, offset};
            }
            int subsampling = 1;
            int offset = 0;
            return new int[]{subsampling, offset};
        }

        @Override
        public String getEosType() {
            return "EOS_TYPE_SWATH";
        }

        @Override
        public GeoCoding createGeocoding() {
            return null;
        }

        public static EosMetadata parse(String swathStructureMetadata) throws ProductIOException {
            LineNumberReader reader = new LineNumberReader(new StringReader(swathStructureMetadata));
            HashMap dimensions = new HashMap();
            HashMap<String, HdfDimensionMap> dimensionMaps = new HashMap<String, HdfDimensionMap>();
            HashMap<String, HdfDataField> geoDataFields = new HashMap<String, HdfDataField>();
            HashMap<String, HdfDataField> dataFields = new HashMap<String, HdfDataField>();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!(line = line.trim()).startsWith("GROUP")) continue;
                    String value = HdfEosStructMetadata.getAssignedValue(line);
                    if (value.equalsIgnoreCase("Dimension")) {
                        HdfEosStructMetadata.parseDimensionGroup(reader, dimensions);
                        continue;
                    }
                    if (value.equalsIgnoreCase("DimensionMap")) {
                        HdfEosStructMetadata.parseDimensionMapGroup(reader, dimensionMaps);
                        continue;
                    }
                    if (value.equalsIgnoreCase("GeoField")) {
                        HdfEosStructMetadata.parseDataFields(reader, geoDataFields, dimensions);
                        continue;
                    }
                    if (!value.equalsIgnoreCase("DataField")) continue;
                    HdfEosStructMetadata.parseDataFields(reader, dataFields, dimensions);
                }
            }
            catch (IOException e) {
                throw new ProductIOException(e.getMessage());
            }
            return new SwathMetadata(dataFields, dimensionMaps, geoDataFields);
        }
    }

    private static interface EosMetadata {
        public HdfDataField getDatafield(String var1);

        public Dimension getProductDimensions();

        public int[] getSubsamplingAndOffset(String var1);

        public String getEosType();

        public GeoCoding createGeocoding();
    }
}

