/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.bandreader;

import java.io.IOException;
import org.esa.s3tbx.dataio.modis.bandreader.ModisBandReader;
import org.esa.snap.core.datamodel.ProductData;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Variable;

public class ModisUint8ExpBandReader
extends ModisBandReader {
    private byte[] line;
    private short min;
    private short max;
    private byte fill;
    private double invScale;
    private float[] targetData;
    private int targetDataIdx;

    public ModisUint8ExpBandReader(Variable variable, int layer, boolean is3d) {
        super(variable, layer, is3d);
    }

    @Override
    public int getDataType() {
        return 30;
    }

    @Override
    protected void prepareForReading(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer) {
        this.fill = (byte)Math.floor(this.fillValue + 0.5);
        if (this.validRange == null) {
            this.min = 0;
            this.max = (short)255;
        } else {
            this.min = (short)Math.floor(this.validRange.getMin() + 0.5);
            this.max = (short)Math.floor(this.validRange.getMax() + 0.5);
        }
        this.targetData = (float[])destBuffer.getElems();
        this.targetDataIdx = 0;
        this.invScale = 1.0 / (double)this.scale;
        this.ensureLineWidth(sourceWidth);
    }

    @Override
    protected void readLine() throws IOException {
        try {
            Section section = new Section(this.start, this.count, this.stride);
            Array array = this.variable.read(section);
            for (int i = 0; i < this.line.length; ++i) {
                this.line[i] = array.getByte(i);
            }
        }
        catch (InvalidRangeException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void validate(int x) {
        int value = this.line[x] & 0xFF;
        if (value < this.min || value > this.max) {
            this.line[x] = this.fill;
        }
    }

    @Override
    protected void assign(int x) {
        this.targetData[this.targetDataIdx++] = this.offset * (float)Math.exp((double)this.line[x] * this.invScale);
    }

    private void ensureLineWidth(int sourceWidth) {
        if (this.line == null || this.line.length != sourceWidth) {
            this.line = new byte[sourceWidth];
        }
    }
}

