/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.bandreader;

import java.io.IOException;
import org.esa.s3tbx.dataio.modis.bandreader.ModisBandReader;
import org.esa.snap.core.datamodel.ProductData;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Variable;

public class ModisUint32BandReader
extends ModisBandReader {
    private int[] line;
    private int min;
    private long max;
    private int fill;
    private int[] targetData;
    private int targetIdx;

    public ModisUint32BandReader(Variable variable, int layer, boolean is3d) {
        super(variable, layer, is3d);
    }

    @Override
    public int getDataType() {
        return 22;
    }

    @Override
    protected void prepareForReading(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer) {
        this.fill = (int)Math.round(this.fillValue);
        if (this.validRange == null) {
            this.min = 0;
            this.max = 0xFFFFFFFFL;
        } else {
            this.min = (int)Math.round(this.validRange.getMin());
            this.max = Math.round(this.validRange.getMax());
        }
        this.targetData = (int[])destBuffer.getElems();
        this.targetIdx = 0;
        this.ensureLineWidth(sourceWidth);
    }

    @Override
    protected void readLine() throws IOException {
        try {
            Section section = new Section(this.start, this.count, this.stride);
            Array array = this.variable.read(section);
            for (int i = 0; i < this.line.length; ++i) {
                this.line[i] = array.getShort(i);
            }
        }
        catch (InvalidRangeException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void validate(int x) {
        long value = (long)this.line[x] & 0xFFFFFFFFL;
        if (value < (long)this.min || value > this.max) {
            this.line[x] = this.fill;
        }
    }

    @Override
    protected void assign(int x) {
        this.targetData[this.targetIdx++] = this.line[x];
    }

    private void ensureLineWidth(int sourceWidth) {
        if (this.line == null || this.line.length != sourceWidth) {
            this.line = new int[sourceWidth];
        }
    }
}

