/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.bandreader;

import java.io.IOException;
import org.esa.s3tbx.dataio.modis.bandreader.ModisBandReader;
import org.esa.snap.core.datamodel.ProductData;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Variable;

public class ModisUint16PowBandReader
extends ModisBandReader {
    private short[] line;
    private int min;
    private int max;
    private short fill;
    private float[] targetData;
    private int targetIdx;

    public ModisUint16PowBandReader(Variable variable, int layer, boolean is3d) {
        super(variable, layer, is3d);
    }

    @Override
    public int getDataType() {
        return 30;
    }

    @Override
    protected void prepareForReading(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer) {
        this.fill = (short)Math.floor(this.fillValue + 0.5);
        if (this.validRange == null) {
            this.min = 0;
            this.max = 65535;
        } else {
            this.min = (int)Math.floor(this.validRange.getMin() + 0.5);
            this.max = (int)Math.floor(this.validRange.getMax() + 0.5);
        }
        this.targetData = (float[])destBuffer.getElems();
        this.targetIdx = 0;
        this.ensureLineWidth(sourceWidth);
    }

    @Override
    protected void readLine() throws IOException {
        try {
            Section section = new Section(this.start, this.count, this.stride);
            Array array = this.variable.read(section);
            for (int i = 0; i < this.line.length; ++i) {
                this.line[i] = array.getShort(i);
            }
        }
        catch (InvalidRangeException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void validate(int x) {
        int value = this.line[x] & 0xFFFF;
        if (value < this.min || value > this.max) {
            this.line[x] = this.fill;
        }
    }

    @Override
    protected void assign(int x) {
        this.targetData[this.targetIdx++] = (float)Math.pow(10.0, this.scale * (float)this.line[x] + this.offset);
    }

    private void ensureLineWidth(int sourceWidth) {
        if (this.line == null || this.line.length != sourceWidth) {
            this.line = new short[sourceWidth];
        }
    }
}

