/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.bandreader;

import java.io.IOException;
import org.esa.s3tbx.dataio.modis.bandreader.ModisBandReader;
import org.esa.snap.core.datamodel.ProductData;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Variable;

public class ModisInt8BandReader
extends ModisBandReader {
    private byte[] line;
    private byte min;
    private byte max;
    private byte fill;
    private byte[] targetData;
    private int targetIdx;

    public ModisInt8BandReader(Variable variable, int layer, boolean is3d) {
        super(variable, layer, is3d);
    }

    @Override
    public int getDataType() {
        return 10;
    }

    @Override
    protected void prepareForReading(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer) {
        this.fill = (byte)Math.floor(this.fillValue + 0.5);
        if (this.validRange == null) {
            this.min = (byte)-128;
            this.max = (byte)127;
        } else {
            this.min = (byte)Math.floor(this.validRange.getMin() + 0.5);
            this.max = (byte)Math.floor(this.validRange.getMax() + 0.5);
        }
        this.targetData = (byte[])destBuffer.getElems();
        this.targetIdx = 0;
        this.ensureLineWidth(sourceWidth);
    }

    @Override
    protected void readLine() throws IOException {
        try {
            Section section = new Section(this.start, this.count, this.stride);
            Array array = this.variable.read(section);
            for (int i = 0; i < this.line.length; ++i) {
                this.line[i] = array.getByte(i);
            }
        }
        catch (InvalidRangeException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void validate(int x) {
        byte value = this.line[x];
        if (value < this.min || value > this.max) {
            this.line[x] = this.fill;
        }
    }

    @Override
    protected void assign(int x) {
        this.targetData[this.targetIdx++] = this.line[x];
    }

    private void ensureLineWidth(int sourceWidth) {
        if (this.line == null || this.line.length != sourceWidth) {
            this.line = new byte[sourceWidth];
        }
    }
}

