/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.bandreader;

import java.io.IOException;
import org.esa.s3tbx.dataio.modis.ModisUtils;
import org.esa.s3tbx.dataio.modis.bandreader.ModisBandReader;
import org.esa.s3tbx.dataio.modis.bandreader.ModisInt16BandReader;
import org.esa.s3tbx.dataio.modis.bandreader.ModisInt8BandReader;
import org.esa.s3tbx.dataio.modis.bandreader.ModisUint16BandReader;
import org.esa.s3tbx.dataio.modis.bandreader.ModisUint16PowBandReader;
import org.esa.s3tbx.dataio.modis.bandreader.ModisUint32BandReader;
import org.esa.s3tbx.dataio.modis.bandreader.ModisUint8BandReader;
import org.esa.s3tbx.dataio.modis.bandreader.ModisUint8ExpBandReader;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFVariables;
import org.esa.s3tbx.dataio.modis.productdb.ModisBandDescription;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;

public class ModisBandReaderFactory {
    public static ModisBandReader[] getReaders(NetCDFVariables netCDFVariables, ModisBandDescription desc) throws IOException {
        Variable variable = netCDFVariables.get(desc.getName());
        if (variable == null) {
            return new ModisBandReader[0];
        }
        int scaleMethod = ModisBandReader.decodeScalingMethod(desc.getScalingMethod());
        int productDataType = DataTypeUtils.getEquivalentProductDataType((DataType)variable.getDataType(), (boolean)variable.isUnsigned(), (boolean)true);
        boolean is3d = ModisBandReaderFactory.is3d(variable);
        ModisBandReader[] modisBandReaders = ModisBandReaderFactory.createBandReaderArray(variable, is3d);
        for (int i = 0; i < modisBandReaders.length; ++i) {
            if (productDataType == 10) {
                modisBandReaders[i] = new ModisInt8BandReader(variable, i, is3d);
            } else if (productDataType == 20) {
                if (scaleMethod == 1 || scaleMethod == 0) {
                    modisBandReaders[i] = new ModisUint8BandReader(variable, i, is3d);
                } else if (scaleMethod == 2) {
                    modisBandReaders[i] = new ModisUint8ExpBandReader(variable, i, is3d);
                }
            } else if (productDataType == 21) {
                if (scaleMethod == 0 || scaleMethod == 1 || scaleMethod == 4) {
                    modisBandReaders[i] = new ModisUint16BandReader(variable, i, is3d);
                } else if (scaleMethod == 3) {
                    modisBandReaders[i] = new ModisUint16PowBandReader(variable, i, is3d);
                }
            } else if (productDataType == 11) {
                if (scaleMethod == 0 || scaleMethod == 1) {
                    modisBandReaders[i] = new ModisInt16BandReader(variable, i, is3d);
                }
            } else if (productDataType == 22 && (scaleMethod == 0 || scaleMethod == 1 || scaleMethod == 4)) {
                modisBandReaders[i] = new ModisUint32BandReader(variable, i, is3d);
            }
            String bandName = ModisUtils.extractBandName(variable.getFullName());
            modisBandReaders[i].setName(bandName);
        }
        return modisBandReaders;
    }

    private static ModisBandReader[] createBandReaderArray(Variable variable, boolean is3d) {
        ModisBandReader[] modisBandReaders;
        if (is3d) {
            Dimension numLayers = variable.getDimension(0);
            modisBandReaders = new ModisBandReader[numLayers.getLength()];
        } else {
            modisBandReaders = new ModisBandReader[1];
        }
        return modisBandReaders;
    }

    private static boolean is3d(Variable variable) {
        int rank = variable.getRank();
        return rank > 2;
    }
}

