/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.bandreader;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.math.Range;
import ucar.nc2.Variable;

public abstract class ModisBandReader {
    public static final int SCALE_UNKNOWN = 0;
    public static final int SCALE_LINEAR = 1;
    public static final int SCALE_EXPONENTIAL = 2;
    public static final int SCALE_POW_10 = 3;
    public static final int SCALE_SLOPE_INTERCEPT = 4;
    protected int layer;
    protected float scale;
    protected float offset;
    private String name;
    protected int[] start;
    protected int[] stride;
    protected int[] count;
    protected int xCoord;
    protected int yCoord;
    protected Range validRange;
    protected double fillValue;
    protected Variable variable;

    public ModisBandReader(Variable variable, int layer, boolean is3d) {
        this.variable = variable;
        this.layer = layer;
        if (is3d) {
            this.count = new int[3];
            this.stride = new int[3];
            this.start = new int[3];
            this.stride[2] = 1;
            this.stride[1] = 1;
            this.stride[0] = 1;
            this.start[0] = layer;
            this.count[0] = 1;
            this.xCoord = 2;
            this.yCoord = 1;
        } else {
            this.count = new int[2];
            this.stride = new int[2];
            this.start = new int[2];
            this.start[0] = layer;
            this.count[0] = 1;
            this.stride[1] = 1;
            this.stride[0] = 1;
            this.xCoord = 1;
            this.yCoord = 0;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static int decodeScalingMethod(String scaleMethod) {
        if (scaleMethod != null) {
            if (scaleMethod.equalsIgnoreCase("lin")) {
                return 1;
            }
            if (scaleMethod.equalsIgnoreCase("exp")) {
                return 2;
            }
            if (scaleMethod.equalsIgnoreCase("p10")) {
                return 3;
            }
            if (scaleMethod.equalsIgnoreCase("sli")) {
                return 4;
            }
        }
        return 0;
    }

    public void setScaleAndOffset(float scale, float offset) {
        this.scale = scale;
        this.offset = offset;
    }

    public void setValidRange(Range validRange) {
        this.validRange = validRange;
    }

    protected abstract void prepareForReading(int var1, int var2, int var3, int var4, int var5, int var6, ProductData var7);

    protected abstract void readLine() throws IOException;

    protected abstract void validate(int var1);

    protected abstract void assign(int var1);

    public void setFillValue(double fillValue) {
        this.fillValue = fillValue;
    }

    public abstract int getDataType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBandData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        this.start[this.yCoord] = sourceOffsetY;
        this.start[this.xCoord] = sourceOffsetX;
        this.count[this.yCoord] = 1;
        this.count[this.xCoord] = sourceWidth;
        this.stride[this.yCoord] = sourceStepY;
        this.stride[this.xCoord] = sourceStepX;
        this.prepareForReading(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBuffer);
        pm.beginTask("Reading band '" + this.getName() + "'...", sourceHeight);
        try {
            for (int y = 0; y < sourceHeight; y += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                this.readLine();
                for (int x = 0; x < sourceWidth; ++x) {
                    this.validate(x);
                    this.assign(x);
                }
                int n = this.yCoord;
                this.start[n] = this.start[n] + sourceStepY;
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }
}

