/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.attribute;

import java.awt.Dimension;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.esa.s3tbx.dataio.modis.IncrementOffset;
import org.esa.s3tbx.dataio.modis.ModisGlobalAttributes;
import org.esa.s3tbx.dataio.modis.ModisUtils;
import org.esa.s3tbx.dataio.modis.hdf.HdfDataField;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFAttributes;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFUtils;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFVariables;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class ImappAttributes
implements ModisGlobalAttributes {
    private final File inputFile;
    private final Logger logger;
    private final NetCDFVariables netCDFVariables;
    private final NetCDFAttributes netCDFAttributes;
    private HashMap<String, IncrementOffset> subsamplingMap;
    private Date sensingStart;
    private Date sensingStop;

    public ImappAttributes(File inputFile, NetCDFVariables netCDFVariables, NetCDFAttributes netCDFAttributes) {
        this.inputFile = inputFile;
        this.netCDFVariables = netCDFVariables;
        this.netCDFAttributes = netCDFAttributes;
        this.logger = SystemUtils.LOG;
    }

    @Override
    public String getProductName() {
        return FileUtils.getFilenameWithoutExtension((File)this.inputFile);
    }

    @Override
    public String getProductType() {
        String inputFileName = FileUtils.getFilenameWithoutExtension((File)this.inputFile);
        int dotIndex = inputFileName.indexOf(".");
        if (dotIndex > 0) {
            return inputFileName.substring(0, dotIndex);
        }
        this.logger.warning("Unable to retrieve the product type from the file name.");
        return "unknown";
    }

    @Override
    public Dimension getProductDimensions(List<ucar.nc2.Dimension> netcdfFileDimensions) {
        Variable[] all;
        int width = 0;
        int height = 0;
        for (Variable variable : all = this.netCDFVariables.getAll()) {
            int rank = variable.getRank();
            int[] shape = variable.getShape();
            if (rank == 2) {
                if (width < shape[1]) {
                    width = shape[1];
                }
                if (height >= shape[0]) continue;
                height = shape[0];
                continue;
            }
            if (rank != 3) continue;
            if (width < shape[2]) {
                width = shape[2];
            }
            if (height >= shape[1]) continue;
            height = shape[1];
        }
        return new Dimension(width, height);
    }

    @Override
    public HdfDataField getDatafield(String name) throws ProductIOException {
        Variable variable = this.netCDFVariables.get(name);
        List dimensions = variable.getDimensions();
        HdfDataField result = new HdfDataField();
        String[] dimensionNames = new String[dimensions.size()];
        for (int i = 0; i < dimensions.size(); ++i) {
            ucar.nc2.Dimension dimension = (ucar.nc2.Dimension)dimensions.get(i);
            dimensionNames[i] = dimension.getShortName();
        }
        result.setDimensionNames(dimensionNames);
        return result;
    }

    @Override
    public Date getSensingStart() {
        if (this.sensingStart == null) {
            this.parseSensingTimes();
        }
        return this.sensingStart;
    }

    @Override
    public Date getSensingStop() {
        if (this.sensingStop == null) {
            this.parseSensingTimes();
        }
        return this.sensingStop;
    }

    @Override
    public int[] getSubsamplingAndOffset(String dimensionName) {
        IncrementOffset incrementOffset;
        if (this.subsamplingMap == null) {
            this.parseTiePointSubsamplingAndOffset();
        }
        if ((incrementOffset = this.subsamplingMap.get(dimensionName)) != null) {
            int[] result = new int[]{incrementOffset.increment, incrementOffset.offset};
            return result;
        }
        return null;
    }

    @Override
    public boolean isImappFormat() {
        return true;
    }

    @Override
    public String getEosType() {
        return null;
    }

    @Override
    public GeoCoding createGeocoding() {
        return null;
    }

    private void parseTiePointSubsamplingAndOffset() {
        Variable[] all;
        this.subsamplingMap = new HashMap();
        for (Variable variable : all = this.netCDFVariables.getAll()) {
            NetCDFAttributes netCDFAttributes = new NetCDFAttributes();
            netCDFAttributes.add(variable.getAttributes());
            ucar.nc2.Dimension heightDimension = variable.getDimension(0);
            String line_numbers = NetCDFUtils.getNamedStringAttribute("line_numbers", netCDFAttributes);
            if (StringUtils.isNotNullAndNotEmpty((String)line_numbers)) {
                this.subsamplingMap.put(heightDimension.getShortName(), ModisUtils.getIncrementOffset(line_numbers));
            }
            ucar.nc2.Dimension widthDimension = variable.getDimension(1);
            String frame_numbers = NetCDFUtils.getNamedStringAttribute("frame_numbers", netCDFAttributes);
            if (!StringUtils.isNotNullAndNotEmpty((String)frame_numbers)) continue;
            this.subsamplingMap.put(widthDimension.getShortName(), ModisUtils.getIncrementOffset(frame_numbers));
        }
    }

    private void parseSensingTimes() {
        Attribute startDateAttribute = this.netCDFAttributes.get("RANGEBEGINNINGDATE");
        Attribute startTimeAttribute = this.netCDFAttributes.get("RANGEBEGINNINGTIME");
        Attribute stopDateAttribute = this.netCDFAttributes.get("RANGEENDINGDATE");
        Attribute stopTimeAttribute = this.netCDFAttributes.get("RANGEENDINGTIME");
        try {
            if (startDateAttribute == null || startTimeAttribute == null) {
                this.logger.warning("Unable to retrieve sensing start time from metadata");
                this.sensingStart = null;
            } else {
                this.sensingStart = ModisUtils.createDateFromStrings(startDateAttribute.getStringValue(), startTimeAttribute.getStringValue());
            }
            if (stopDateAttribute == null || stopTimeAttribute == null) {
                this.logger.warning("Unable to retrieve sensing stop time from metadata");
                this.sensingStop = null;
            } else {
                this.sensingStop = ModisUtils.createDateFromStrings(stopDateAttribute.getStringValue(), stopTimeAttribute.getStringValue());
            }
        }
        catch (ParseException e) {
            this.logger.warning("Unable to parse sensing times: " + e.getMessage());
        }
    }
}

