/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.attribute;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.esa.s3tbx.dataio.modis.ModisDaacUtils;
import org.esa.s3tbx.dataio.modis.ModisGlobalAttributes;
import org.esa.s3tbx.dataio.modis.ModisUtils;
import org.esa.s3tbx.dataio.modis.hdf.HdfDataField;
import org.esa.s3tbx.dataio.modis.hdf.HdfEosStructMetadata;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFVariables;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import ucar.nc2.Variable;

public class DaacAttributes
implements ModisGlobalAttributes {
    private final NetCDFVariables netCDFVariables;
    private String ecsCoreString;
    private HdfEosStructMetadata hdfEosStructMetadata;
    private Date sensingStart;
    private Date sensingStop;

    public DaacAttributes(NetCDFVariables netCDFVariables) {
        this.netCDFVariables = netCDFVariables;
    }

    @Override
    public String getProductName() throws IOException {
        String productName;
        if (StringUtils.isNullOrEmpty((String)this.ecsCoreString)) {
            this.readEcsCoreString();
        }
        if (StringUtils.isNullOrEmpty((String)(productName = ModisUtils.extractValueForKey(this.ecsCoreString, "LOCALGRANULEID")))) {
            throw new ProductIOException("Unknown MODIS format: ECSCore metadata field 'LOCALGRANULEID' missing");
        }
        return FileUtils.getFilenameWithoutExtension((File)new File(productName));
    }

    @Override
    public String getProductType() throws IOException {
        String productName = this.getProductName();
        return ModisDaacUtils.extractProductType(productName);
    }

    @Override
    public Dimension getProductDimensions(List<ucar.nc2.Dimension> netcdfFileDimensions) {
        int width = 0;
        int height = 0;
        for (ucar.nc2.Dimension dimension : netcdfFileDimensions) {
            int dimHeight;
            int dimWidth;
            if (DaacAttributes.isWidthDimension(dimension) && (dimWidth = dimension.getLength()) > width) {
                width = dimWidth;
            }
            if (!DaacAttributes.isHeightDimension(dimension) || (dimHeight = dimension.getLength()) <= height) continue;
            height = dimHeight;
        }
        return new Dimension(width, height);
    }

    @Override
    public HdfDataField getDatafield(String name) throws ProductIOException {
        Variable variable = this.netCDFVariables.get(name);
        List dimensions = variable.getDimensions();
        HdfDataField result = new HdfDataField();
        String[] dimensionNames = new String[dimensions.size()];
        for (int i = 0; i < dimensions.size(); ++i) {
            ucar.nc2.Dimension dimension = (ucar.nc2.Dimension)dimensions.get(i);
            dimensionNames[i] = dimension.getShortName();
        }
        result.setDimensionNames(dimensionNames);
        return result;
    }

    @Override
    public Date getSensingStart() throws ProductIOException {
        if (this.sensingStart == null) {
            this.parseSensingTimes();
        }
        return this.sensingStart;
    }

    @Override
    public Date getSensingStop() throws ProductIOException {
        if (this.sensingStop == null) {
            this.parseSensingTimes();
        }
        return this.sensingStop;
    }

    @Override
    public int[] getSubsamplingAndOffset(String dimensionName) throws IOException {
        if (this.hdfEosStructMetadata == null) {
            this.readHdfEosStructMeta();
        }
        return this.hdfEosStructMetadata.getSubsamplingAndOffset(dimensionName);
    }

    @Override
    public boolean isImappFormat() {
        return false;
    }

    @Override
    public String getEosType() throws IOException {
        if (this.hdfEosStructMetadata == null) {
            this.readHdfEosStructMeta();
        }
        return this.hdfEosStructMetadata.getEosType();
    }

    @Override
    public GeoCoding createGeocoding() {
        return this.hdfEosStructMetadata.createGeocoding();
    }

    static boolean isHeightDimension(ucar.nc2.Dimension dimension) {
        String dimensionName = dimension.getShortName();
        return dimensionName.contains("10*nscans") || dimensionName.contains("20*nscans") || dimensionName.contains("YDim") || dimensionName.contains("Number_of_records");
    }

    static boolean isWidthDimension(ucar.nc2.Dimension dimension) {
        String dimensionName = dimension.getShortName();
        return dimensionName.contains("Max_EV_frames") || dimensionName.contains("XDim") || dimensionName.contains("Number_of_samples_per_record");
    }

    private void readEcsCoreString() throws IOException {
        this.ecsCoreString = ModisDaacUtils.extractCoreString(this.netCDFVariables);
    }

    private void readHdfEosStructMeta() throws IOException {
        Variable structMetaVariable = this.netCDFVariables.get("StructMetadata\\.0");
        if (structMetaVariable == null) {
            throw new ProductIOException("Unknown MODIS format: no StructMetadata available");
        }
        String structMetaString = structMetaVariable.readScalarString();
        if (StringUtils.isNullOrEmpty((String)structMetaString)) {
            throw new ProductIOException("Unknown MODIS format: no StructMetadata available");
        }
        this.hdfEosStructMetadata = new HdfEosStructMetadata(structMetaString);
    }

    private void parseSensingTimes() throws ProductIOException {
        try {
            String startDate = ModisUtils.extractValueForKey(this.ecsCoreString, "RANGEBEGINNINGDATE");
            String startTime = ModisUtils.extractValueForKey(this.ecsCoreString, "RANGEBEGINNINGTIME");
            String endDate = ModisUtils.extractValueForKey(this.ecsCoreString, "RANGEENDINGDATE");
            String endTime = ModisUtils.extractValueForKey(this.ecsCoreString, "RANGEENDINGTIME");
            if (startDate == null || startTime == null) {
                throw new ProductIOException("Unable to retrieve sensing start time from metadata");
            }
            this.sensingStart = ModisUtils.createDateFromStrings(startDate, startTime);
            if (endDate == null || endTime == null) {
                throw new ProductIOException("Unable to retrieve sensing stop time from metadata");
            }
            this.sensingStop = ModisUtils.createDateFromStrings(endDate, endTime);
        }
        catch (ParseException e) {
            throw new ProductIOException(e.getMessage());
        }
    }
}

