/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import java.text.ParseException;
import java.util.Date;
import org.esa.s3tbx.dataio.modis.IncrementOffset;
import org.esa.s3tbx.dataio.modis.ModisConstants;
import org.esa.snap.core.util.DateTimeUtils;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.math.Range;

public class ModisUtils {
    public static String decodeBandName(String names, int layerIdx) {
        String strRet = ".";
        String[] namesArray = StringUtils.toStringArray((String)names, (String)",");
        strRet = strRet + namesArray[layerIdx];
        strRet = strRet.trim();
        return strRet;
    }

    public static float[] decodeSpectralInformation(String bandExt, float[] recycle) {
        if (recycle == null || recycle.length < 3) {
            recycle = new float[3];
        }
        bandExt = bandExt.replaceAll("\\D", "");
        int idx = Integer.parseInt(bandExt) - 1;
        recycle[0] = ModisConstants.BAND_CENTER_WAVELENGTHS[idx];
        recycle[1] = ModisConstants.BAND_WIDTHS[idx];
        recycle[2] = ModisConstants.SPECTRAL_BAND_INDEX[idx];
        return recycle;
    }

    public static String extractValueForKey(String metaDataString, String key) {
        int endPos;
        Guardian.assertNotNull((String)"metaDataString", (Object)metaDataString);
        Guardian.assertNotNull((String)"key", (Object)key);
        int pos = metaDataString.indexOf(key);
        if (pos >= 0 && (pos = metaDataString.indexOf("VALUE", pos)) >= 0 && (pos = metaDataString.indexOf(61, pos)) >= 0 && (endPos = metaDataString.indexOf(10, pos + 1)) >= 0) {
            String value = metaDataString.substring(pos + 1, endPos);
            value = value.replace('\"', ' ');
            return value.trim();
        }
        return null;
    }

    public static Date createDateFromStrings(String date, String time) throws ParseException {
        String dateTimeString;
        String expectedTimeString = "00:00:00.000";
        if (time.length() < "00:00:00.000".length()) {
            String perfection = "00:00:00.000".substring(time.length());
            dateTimeString = date + " " + time + perfection;
        } else {
            dateTimeString = date + ' ' + time.substring(0, "00:00:00.000".length());
        }
        return DateTimeUtils.stringToUTC((String)dateTimeString);
    }

    public static IncrementOffset getIncrementOffset(String attribute) {
        IncrementOffset incrementOffset = new IncrementOffset();
        Range range = ModisUtils.getRangeFromString(attribute);
        incrementOffset.offset = (int)(range.getMin() - 1.0);
        incrementOffset.increment = (int)(range.getMax() - range.getMin());
        return incrementOffset;
    }

    public static Range getRangeFromString(String rangeString) {
        int stop;
        Range range = new Range();
        String[] intStringArray = StringUtils.toStringArray((String)rangeString, (String)",");
        int start = Integer.parseInt(intStringArray[0]);
        if (start < (stop = Integer.parseInt(intStringArray[1]))) {
            range.setMin((double)start);
            range.setMax((double)stop);
        } else {
            range.setMin((double)stop);
            range.setMax((double)start);
        }
        return range;
    }

    public static String extractBandName(String variableName) {
        int slashIndex = variableName.lastIndexOf(47);
        if (slashIndex > 0) {
            return variableName.substring(slashIndex + 1, variableName.length());
        }
        return variableName;
    }
}

