/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.AbstractGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.math.IndexValidator;
import org.esa.snap.core.util.math.Range;

public class ModisTiePointGeoCoding
extends AbstractGeoCoding {
    private final Datum datum;
    private TiePointGrid latgrid;
    private TiePointGrid lonGrid;
    private List<GeoCoding> gcList;
    private boolean cross180;
    private List<PolyLine> centerLineList;
    private int lastCenterLineIndex;
    private int smallestValidIndex;
    private int biggestValidIndex;
    private int gcStripeSceneHeight;

    public ModisTiePointGeoCoding(TiePointGrid latGrid, TiePointGrid lonGrid) {
        Guardian.assertNotNull((String)"latGrid", (Object)latGrid);
        Guardian.assertNotNull((String)"lonGrid", (Object)lonGrid);
        if (latGrid.getGridWidth() != lonGrid.getGridWidth() || latGrid.getGridHeight() != lonGrid.getGridHeight() || latGrid.getOffsetX() != lonGrid.getOffsetX() || latGrid.getOffsetY() != lonGrid.getOffsetY() || latGrid.getSubSamplingX() != lonGrid.getSubSamplingX() || latGrid.getSubSamplingY() != lonGrid.getSubSamplingY()) {
            throw new IllegalArgumentException("latGrid is not compatible with lonGrid");
        }
        this.latgrid = latGrid;
        this.lonGrid = lonGrid;
        this.datum = Datum.WGS_84;
        this.lastCenterLineIndex = 0;
        this.init();
    }

    public boolean canGetPixelPos() {
        return true;
    }

    public boolean canGetGeoPos() {
        return true;
    }

    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        int index;
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        pixelPos.x = -1.0;
        pixelPos.y = -1.0;
        this.lastCenterLineIndex = index = this.getGeoCodingIndexfor(geoPos);
        GeoCoding gc = this.gcList.get(index);
        if (gc != null) {
            gc.getPixelPos(geoPos, pixelPos);
        }
        if (pixelPos.x == -1.0 || pixelPos.y == -1.0) {
            return pixelPos;
        }
        pixelPos.y += (double)(this.lastCenterLineIndex * this.gcStripeSceneHeight);
        return pixelPos;
    }

    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        int index = this.computeIndex(pixelPos);
        GeoCoding gc = this.gcList.get(index);
        if (gc != null) {
            return gc.getGeoPos(new PixelPos(pixelPos.x, pixelPos.y - (double)(this.gcStripeSceneHeight * index)), geoPos);
        }
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        geoPos.setInvalid();
        return geoPos;
    }

    public Datum getDatum() {
        return this.datum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ModisTiePointGeoCoding that = (ModisTiePointGeoCoding)((Object)o);
        if (this.latgrid == null || that.latgrid == null) {
            return false;
        }
        if (!this.latgrid.equals(that.latgrid)) {
            return false;
        }
        if (this.lonGrid == null || that.lonGrid == null) {
            return false;
        }
        return this.lonGrid.equals(that.lonGrid);
    }

    public int hashCode() {
        int result = this.latgrid != null ? this.latgrid.hashCode() : 0;
        result = 31 * result + (this.lonGrid != null ? this.lonGrid.hashCode() : 0);
        return result;
    }

    public void dispose() {
        for (GeoCoding gc : this.gcList) {
            if (gc == null) continue;
            gc.dispose();
        }
        this.gcList.clear();
        this.latgrid = null;
        this.lonGrid = null;
    }

    public boolean isCrossingMeridianAt180() {
        return this.cross180;
    }

    private void init() {
        int stripeH;
        this.cross180 = false;
        this.gcList = new ArrayList<GeoCoding>();
        this.centerLineList = new ArrayList<PolyLine>();
        double osX = this.lonGrid.getOffsetX();
        double osY = this.lonGrid.getOffsetY();
        double ssX = this.lonGrid.getSubSamplingX();
        double ssY = this.lonGrid.getSubSamplingY();
        float[] latFloats = (float[])this.latgrid.getDataElems();
        float[] lonFloats = (float[])this.lonGrid.getDataElems();
        int stripeW = this.lonGrid.getGridWidth();
        int gcStripeSceneWidth = this.lonGrid.getRasterWidth();
        int tpRasterHeight = this.lonGrid.getGridHeight();
        int sceneHeight = this.lonGrid.getRasterHeight();
        if (ModisTiePointGeoCoding.isHighResolution(sceneHeight, tpRasterHeight)) {
            stripeH = 10;
            this.gcStripeSceneHeight = 20;
        } else {
            stripeH = 2;
            this.gcStripeSceneHeight = 10;
        }
        int gcRawWidth = stripeW * stripeH;
        for (int y = 0; y < tpRasterHeight; y += stripeH) {
            float[] lats = new float[gcRawWidth];
            float[] lons = new float[gcRawWidth];
            System.arraycopy(lonFloats, y * stripeW, lons, 0, stripeW * stripeH);
            System.arraycopy(latFloats, y * stripeW, lats, 0, stripeW * stripeH);
            Range range = Range.computeRangeFloat((float[])lats, (IndexValidator)IndexValidator.TRUE, null, (ProgressMonitor)ProgressMonitor.NULL);
            if (range.getMin() < -90.0) {
                this.gcList.add(null);
                this.centerLineList.add(null);
                continue;
            }
            ModisTiePointGrid latTPG = new ModisTiePointGrid("lat" + y, stripeW, stripeH, osX, osY, ssX, ssY, lats);
            ModisTiePointGrid lonTPG = new ModisTiePointGrid("lon" + y, stripeW, stripeH, osX, osY, ssX, ssY, lons, true);
            TiePointGeoCoding geoCoding = new TiePointGeoCoding((TiePointGrid)latTPG, (TiePointGrid)lonTPG, this.getGeoCRS());
            this.cross180 = this.cross180 || geoCoding.isCrossingMeridianAt180();
            this.gcList.add((GeoCoding)geoCoding);
            this.centerLineList.add(ModisTiePointGeoCoding.createCenterPolyLine(geoCoding, gcStripeSceneWidth, this.gcStripeSceneHeight));
        }
        this.initSmallestAndLargestValidGeocodingIndices();
    }

    private void initSmallestAndLargestValidGeocodingIndices() {
        int i;
        for (i = 0; i < this.gcList.size(); ++i) {
            if (this.gcList.get(i) == null) continue;
            this.smallestValidIndex = i;
            break;
        }
        for (i = this.gcList.size() - 1; i > 0; --i) {
            if (this.gcList.get(i) == null) continue;
            this.biggestValidIndex = i;
            break;
        }
    }

    private static PolyLine createCenterPolyLine(TiePointGeoCoding geoCoding, int sceneWidth, int sceneHeight) {
        double numberOfSegments = 100.0;
        double stepX = (double)sceneWidth / 100.0;
        PixelPos pixelPos = new PixelPos();
        GeoPos geoPos = new GeoPos();
        PolyLine polyLine = new PolyLine();
        pixelPos.y = (float)sceneHeight / 2.0f;
        pixelPos.x = 0.0;
        while (pixelPos.x < (double)sceneWidth + 0.5) {
            geoCoding.getGeoPos(pixelPos, geoPos);
            if (pixelPos.x == 0.0) {
                polyLine.moveTo(geoPos.lon, geoPos.lat);
            } else {
                polyLine.lineTo(geoPos.lon, geoPos.lat);
            }
            pixelPos.x += stepX;
        }
        return polyLine;
    }

    private int computeIndex(PixelPos pixelPos) {
        int y = (int)pixelPos.getY();
        int index = y / this.gcStripeSceneHeight;
        if (index < this.smallestValidIndex) {
            return this.smallestValidIndex;
        }
        if (index > this.biggestValidIndex) {
            return this.biggestValidIndex;
        }
        return index;
    }

    private int getGeoCodingIndexfor(GeoPos geoPos) {
        int index = this.lastCenterLineIndex;
        index = this.getNextCenterLineIndex(index, 1);
        PolyLine centerLine1 = this.centerLineList.get(index);
        double v = centerLine1.getDistance(geoPos.lon, geoPos.lat);
        int vIndex = index;
        int direction = -1;
        if (index == this.smallestValidIndex) {
            direction = 1;
        }
        while (true) {
            index += direction;
            PolyLine centerLine2 = this.centerLineList.get(index = this.getNextCenterLineIndex(index, direction));
            double v2 = centerLine2.getDistance(geoPos.lon, geoPos.lat);
            if (v2 < v) {
                if (index == this.smallestValidIndex || index == this.biggestValidIndex) {
                    return index;
                }
                v = v2;
                vIndex = index;
                continue;
            }
            if (direction == -1) {
                direction = 1;
                if (++index != this.biggestValidIndex) continue;
                return index;
            }
            if (direction == 1) break;
        }
        return vIndex;
    }

    private int getNextCenterLineIndex(int index, int direction) {
        while (this.centerLineList.get(index) == null) {
            if ((index += direction) < this.smallestValidIndex) {
                index = this.biggestValidIndex;
                continue;
            }
            if (index <= this.biggestValidIndex) continue;
            index = this.smallestValidIndex;
        }
        return index;
    }

    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        String latGridName = this.latgrid.getName();
        String lonGridName = this.lonGrid.getName();
        if (ModisTiePointGeoCoding.mustRecalculateTiePointGrids(subsetDef)) {
            try {
                this.recalculateTiePointGrids(srcScene, destScene, subsetDef, latGridName, lonGridName);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return this.createGeocoding(destScene);
    }

    private boolean recalculateTiePointGrids(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef, String latGridName, String lonGridName) throws IOException {
        TiePointGrid falseTiePointGrid = destScene.getProduct().getTiePointGrid(latGridName);
        double rightOffsetX = falseTiePointGrid.getOffsetX();
        double falseOffsetY = falseTiePointGrid.getOffsetY();
        double rightSubsamplingX = falseTiePointGrid.getSubSamplingX();
        double rightSubsamplingY = falseTiePointGrid.getSubSamplingY();
        this.removeTiePointGrid(destScene, latGridName);
        this.removeTiePointGrid(destScene, lonGridName);
        Product srcProduct = srcScene.getProduct();
        int sceneRasterHeight = srcProduct.getSceneRasterHeight();
        int tpGridHeight = srcProduct.getTiePointGrid(lonGridName).getGridHeight();
        int scanlineHeight = ModisTiePointGeoCoding.isHighResolution(sceneRasterHeight, tpGridHeight) ? 20 : 10;
        Rectangle region = subsetDef.getRegion();
        int startY = ModisTiePointGeoCoding.calculateStartLine(scanlineHeight, region);
        int stopY = ModisTiePointGeoCoding.calculateStopLine(scanlineHeight, region);
        int extendedHeight = stopY - startY;
        float[] recalculatedLatFloats = new float[region.width * extendedHeight];
        recalculatedLatFloats = srcProduct.getTiePointGrid(latGridName).getPixels(region.x, startY, region.width, extendedHeight, recalculatedLatFloats);
        float[] recalculatedLonFloats = new float[region.width * extendedHeight];
        recalculatedLonFloats = srcProduct.getTiePointGrid(lonGridName).getPixels(region.x, startY, region.width, extendedHeight, recalculatedLonFloats);
        int yOffsetIncrement = startY - region.y;
        TiePointGrid correctedLatTiePointGrid = new TiePointGrid(latGridName, region.width, extendedHeight, rightOffsetX, falseOffsetY + (double)yOffsetIncrement, rightSubsamplingX, rightSubsamplingY, recalculatedLatFloats);
        TiePointGrid correctedLonTiePointGrid = new TiePointGrid(lonGridName, region.width, extendedHeight, rightOffsetX, falseOffsetY + (double)yOffsetIncrement, rightSubsamplingX, rightSubsamplingY, recalculatedLonFloats);
        destScene.getProduct().addTiePointGrid(correctedLatTiePointGrid);
        destScene.getProduct().addTiePointGrid(correctedLonTiePointGrid);
        return false;
    }

    private void removeTiePointGrid(Scene destScene, String gridName) {
        TiePointGrid tiePointGrid = destScene.getProduct().getTiePointGrid(gridName);
        if (tiePointGrid != null) {
            destScene.getProduct().removeTiePointGrid(tiePointGrid);
        }
    }

    private boolean createGeocoding(Scene destScene) {
        String latGridName = this.latgrid.getName();
        String lonGridName = this.lonGrid.getName();
        TiePointGrid latGrid = destScene.getProduct().getTiePointGrid(latGridName);
        TiePointGrid lonGrid = destScene.getProduct().getTiePointGrid(lonGridName);
        if (latGrid != null && lonGrid != null) {
            destScene.setGeoCoding((GeoCoding)new ModisTiePointGeoCoding(latGrid, lonGrid));
            return true;
        }
        return false;
    }

    static boolean mustRecalculateTiePointGrids(ProductSubsetDef subsetDef) {
        return subsetDef != null && subsetDef.getRegion() != null;
    }

    static boolean isHighResolution(int sceneHeight, int tpGridHeight) {
        return sceneHeight / tpGridHeight == 2;
    }

    static int calculateStartLine(int scanlineHeight, Rectangle region) {
        return region.y / scanlineHeight * scanlineHeight;
    }

    static int calculateStopLine(int scanlineHeight, Rectangle region) {
        return (region.y + region.height) / scanlineHeight * scanlineHeight + scanlineHeight;
    }

    private class ModisTiePointGrid
    extends TiePointGrid {
        public ModisTiePointGrid(String name, int gridWidth, int gridHeight, double offsetX, double offsetY, double subSamplingX, double subSamplingY, float[] tiePoints) {
            super(name, gridWidth, gridHeight, offsetX, offsetY, subSamplingX, subSamplingY, tiePoints);
        }

        public ModisTiePointGrid(String name, int gridWidth, int gridHeight, double offsetX, double offsetY, double subSamplingX, double subSamplingY, float[] tiePoints, boolean containsAngles) {
            super(name, gridWidth, gridHeight, offsetX, offsetY, subSamplingX, subSamplingY, tiePoints, containsAngles);
        }

        public ProductNode getOwner() {
            return ModisTiePointGeoCoding.this.lonGrid.getOwner();
        }
    }

    private static class PolyLine {
        private double _x1;
        private double _y1;
        private boolean _started = false;
        private ArrayList<Line2D.Double> _lines;

        public void lineTo(double x, double y) {
            this._lines.add(new Line2D.Double(this._x1, this._y1, x, y));
            this.setXY1(x, y);
        }

        public void moveTo(double x, double y) {
            if (this._started) {
                throw new IllegalStateException("Polyline alredy started");
            }
            this.setXY1(x, y);
            this._lines = new ArrayList();
            this._started = true;
        }

        private void setXY1(double x, double y) {
            this._x1 = x;
            this._y1 = y;
        }

        public double getDistance(double x, double y) {
            double smallestDistPoints;
            double pointsDist = smallestDistPoints = Double.MAX_VALUE;
            if (this._lines != null && this._lines.size() > 0) {
                for (Line2D.Double line : this._lines) {
                    double distPoints = line.ptSegDistSq(x, y);
                    if (!(distPoints < smallestDistPoints)) continue;
                    smallestDistPoints = distPoints;
                }
                pointsDist = Math.sqrt(smallestDistPoints);
            }
            return pointsDist;
        }
    }
}

