/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.esa.s3tbx.dataio.modis.ModisGlobalAttributes;
import org.esa.s3tbx.dataio.modis.ModisProductReader;
import org.esa.s3tbx.dataio.modis.attribute.DaacAttributes;
import org.esa.s3tbx.dataio.modis.attribute.ImappAttributes;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFAttributes;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFVariables;
import org.esa.s3tbx.dataio.modis.productdb.ModisProductDb;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class ModisProductReaderPlugIn
implements ProductReaderPlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DecodeQualification getDecodeQualification(Object input) {
        File inputFile = ModisProductReaderPlugIn.getInputFile(input);
        if (!ModisProductReaderPlugIn.isValidInputFile(inputFile)) {
            return DecodeQualification.UNABLE;
        }
        NetcdfFile netcdfFile = null;
        try {
            String inputFilePath = inputFile.getPath();
            netcdfFile = NetcdfFileOpener.open((Object)inputFilePath);
            if (netcdfFile == null) {
                DecodeQualification decodeQualification = DecodeQualification.UNABLE;
                return decodeQualification;
            }
            NetCDFVariables variables = new NetCDFVariables();
            variables.add(netcdfFile.getVariables());
            NetCDFAttributes attributes = new NetCDFAttributes();
            attributes.add(netcdfFile.getGlobalAttributes());
            Variable structMeta = variables.get("StructMetadata\\.0");
            ModisGlobalAttributes modisAttributes = structMeta == null ? new ImappAttributes(inputFile, variables, attributes) : new DaacAttributes(variables);
            String productType = modisAttributes.getProductType();
            if (!ModisProductDb.getInstance().isSupportedProduct(productType)) return DecodeQualification.UNABLE;
            if (modisAttributes.isImappFormat()) {
                DecodeQualification decodeQualification = DecodeQualification.INTENDED;
                return decodeQualification;
            }
            DecodeQualification decodeQualification = DecodeQualification.SUITABLE;
            return decodeQualification;
        }
        catch (IOException iOException) {
            return DecodeQualification.UNABLE;
        }
        finally {
            if (netcdfFile != null) {
                try {
                    netcdfFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    public ProductReader createReaderInstance() {
        return new ModisProductReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        String[] formatNames = this.getFormatNames();
        String formatName = "";
        if (formatNames.length > 0) {
            formatName = formatNames[0];
        }
        return new SnapFileFilter(formatName, this.getDefaultFileExtensions(), this.getDescription(null));
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".hdf"};
    }

    public String getDescription(Locale locale) {
        return "MODIS HDF4 Data Products";
    }

    public String[] getFormatNames() {
        return new String[]{"MODIS"};
    }

    static File getInputFile(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        return null;
    }

    static boolean hasHdfFileExtension(File inputFile) {
        if (inputFile == null) {
            return false;
        }
        return inputFile.getPath().toLowerCase().endsWith(".hdf");
    }

    static boolean isValidInputFile(File inputFile) {
        return inputFile != null && inputFile.isFile() && ModisProductReaderPlugIn.hasHdfFileExtension(inputFile);
    }

    private static void registerRGBProfiles() {
        RGBImageProfileManager manager = RGBImageProfileManager.getInstance();
        manager.addProfile(new RGBImageProfile("MOD021KM High Quality", new String[]{"log(1 + 0.04 * EV_1KM_RefSB.8 + 0.35 * EV_1KM_RefSB.9 + 0.03 * EV_1KM_RefSB.10 + 0.17 * EV_1KM_RefSB.11 + 0.43 * EV_1KM_RefSB.12 + 1.00 * EV_1KM_RefSB.13lo + 0.13 * EV_1KM_RefSB.14lo + 0.05 * EV_1KM_RefSB.15)", "log(1 + 0.02 * EV_1KM_RefSB.9 + 0.21 * EV_1KM_RefSB.10 + 0.86 * EV_1KM_RefSB.11 + 1.00 * EV_1KM_RefSB.12 + 0.38 * EV_1KM_RefSB.13lo + 0.04 * EV_1KM_RefSB.14lo + 0.02 * EV_1KM_RefSB.15)", "log(1 + 0.21 * EV_1KM_RefSB.8 + 1.75 * EV_1KM_RefSB.9 + 0.47 * EV_1KM_RefSB.10 + 0.04 * EV_1KM_RefSB.11 + 0.01 * EV_1KM_RefSB.12)"}));
        manager.addProfile(new RGBImageProfile("MOD021KM Night", new String[]{"EV_1KM_Emissive.32", "EV_1KM_Emissive.31", "EV_1KM_Emissive.21"}));
    }

    static {
        ModisProductReaderPlugIn.registerRGBProfiles();
    }
}

