/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.esa.s3tbx.dataio.modis.ModisFileReader;
import org.esa.s3tbx.dataio.modis.ModisGlobalAttributes;
import org.esa.s3tbx.dataio.modis.ModisProductReaderPlugIn;
import org.esa.s3tbx.dataio.modis.attribute.DaacAttributes;
import org.esa.s3tbx.dataio.modis.attribute.ImappAttributes;
import org.esa.s3tbx.dataio.modis.bandreader.ModisBandReader;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFAttributes;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFUtils;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFVariables;
import org.esa.s3tbx.dataio.modis.productdb.ModisProductDb;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class ModisProductReader
extends AbstractProductReader {
    private ModisFileReader fileReader;
    private ModisGlobalAttributes globalAttributes;
    private NetcdfFile netcdfFile;
    private NetCDFAttributes netCDFAttributes;
    private NetCDFVariables netCDFVariables;

    public ModisProductReader(ModisProductReaderPlugIn plugin) {
        super((ProductReaderPlugIn)plugin);
    }

    public void close() throws IOException {
        if (this.fileReader != null) {
            this.fileReader.close();
            this.fileReader = null;
        }
        if (this.netcdfFile != null) {
            this.netcdfFile.close();
            this.netcdfFile = null;
        }
        super.close();
    }

    static boolean isGlobalAttributeName(String variableName) {
        return "StructMetadata\\.0".equalsIgnoreCase(variableName) || "CoreMetadata\\.0".equalsIgnoreCase(variableName) || "ArchiveMetadata\\.0".equalsIgnoreCase(variableName);
    }

    protected synchronized void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        ModisBandReader reader = this.fileReader.getBandReader(destBand);
        if (reader == null) {
            throw new IOException("No band reader for band '" + destBand.getName() + "' available!");
        }
        reader.readBandData(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBuffer, pm);
    }

    protected Product readProductNodesImpl() throws IOException {
        Date sensingStop;
        Date sensingStart;
        File inFile = this.getInputFile();
        String inputFilePath = inFile.getPath();
        this.netcdfFile = NetcdfFileOpener.open((Object)inputFilePath);
        if (this.netcdfFile == null) {
            throw new IOException("Failed top open file: " + inputFilePath);
        }
        this.readGlobalMetaData(inFile);
        this.checkProductType();
        this.fileReader = this.createFileReader();
        Dimension productDim = this.globalAttributes.getProductDimensions(this.netcdfFile.getDimensions());
        Product product = new Product(this.globalAttributes.getProductName(), this.globalAttributes.getProductType(), productDim.width, productDim.height, (ProductReader)this);
        product.setFileLocation(inFile);
        NetCDFVariables netCDFVariables = new NetCDFVariables();
        netCDFVariables.add(this.netcdfFile.getVariables());
        this.fileReader.addRastersAndGeoCoding(product, this.globalAttributes, netCDFVariables);
        if (!this.isMetadataIgnored()) {
            this.addMetadata(product);
        }
        if ((sensingStart = this.globalAttributes.getSensingStart()) != null) {
            product.setStartTime(ProductData.UTC.create((Date)sensingStart, (long)0L));
        }
        if ((sensingStop = this.globalAttributes.getSensingStop()) != null) {
            product.setEndTime(ProductData.UTC.create((Date)sensingStop, (long)0L));
        }
        return product;
    }

    private ModisFileReader createFileReader() {
        return new ModisFileReader();
    }

    private File getInputFile() {
        File inFile;
        if (this.getInput() instanceof String) {
            inFile = new File((String)this.getInput());
        } else if (this.getInput() instanceof File) {
            inFile = (File)this.getInput();
        } else {
            throw new IllegalArgumentException("unsupported input source: " + this.getInput());
        }
        return inFile;
    }

    private void readGlobalMetaData(File inFile) throws IOException {
        this.netCDFAttributes = new NetCDFAttributes();
        this.netCDFAttributes.add(this.netcdfFile.getGlobalAttributes());
        this.netCDFVariables = new NetCDFVariables();
        this.netCDFVariables.add(this.netcdfFile.getVariables());
        this.globalAttributes = this.isImappFormat() ? new ImappAttributes(inFile, this.netCDFVariables, this.netCDFAttributes) : new DaacAttributes(this.netCDFVariables);
    }

    private boolean isImappFormat() {
        return this.netCDFVariables.get("StructMetadata\\.0") == null;
    }

    private void addMetadata(Product prod) throws IOException {
        Variable[] variables;
        Attribute[] attributes;
        MetadataElement mdElem = prod.getMetadataRoot();
        if (mdElem == null) {
            return;
        }
        MetadataElement globalElem = new MetadataElement("GLOBAL_METADATA");
        for (Attribute attribute : attributes = this.netCDFAttributes.getAll()) {
            globalElem.addAttribute(NetCDFUtils.toMetadataAttribute(attribute));
        }
        for (Variable variable : variables = this.netCDFVariables.getAll()) {
            if (!ModisProductReader.isGlobalAttributeName(variable.getFullName())) continue;
            globalElem.addAttribute(NetCDFUtils.toMetadataAttribute(variable));
        }
        mdElem.addElement(globalElem);
    }

    private void checkProductType() throws IOException {
        String productType = this.globalAttributes.getProductType();
        ModisProductDb db = ModisProductDb.getInstance();
        if (!db.isSupportedProduct(productType)) {
            throw new ProductIOException("Unsupported product of type '" + productType + '\'');
        }
    }
}

