/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.esa.s3tbx.dataio.modis.ModisGlobalAttributes;
import org.esa.s3tbx.dataio.modis.ModisTiePointGeoCoding;
import org.esa.s3tbx.dataio.modis.ModisUtils;
import org.esa.s3tbx.dataio.modis.attribute.DaacAttributes;
import org.esa.s3tbx.dataio.modis.attribute.ImappAttributes;
import org.esa.s3tbx.dataio.modis.bandreader.ModisBandReader;
import org.esa.s3tbx.dataio.modis.bandreader.ModisBandReaderFactory;
import org.esa.s3tbx.dataio.modis.hdf.HdfDataField;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFAttributes;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFUtils;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFVariables;
import org.esa.s3tbx.dataio.modis.productdb.ModisBandDescription;
import org.esa.s3tbx.dataio.modis.productdb.ModisProductDb;
import org.esa.s3tbx.dataio.modis.productdb.ModisProductDescription;
import org.esa.s3tbx.dataio.modis.productdb.ModisSpectralInfo;
import org.esa.s3tbx.dataio.modis.productdb.ModisTiePointDescription;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.math.Range;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

class ModisFileReader {
    private Logger logger;
    private HashMap<Band, ModisBandReader> bandReaderMap;
    private ModisProductDb prodDb = ModisProductDb.getInstance();
    private NetcdfFile qcFile;

    public ModisFileReader() {
        this.logger = SystemUtils.LOG;
        this.bandReaderMap = new HashMap();
    }

    public void addRastersAndGeoCoding(Product product, ModisGlobalAttributes globalAttribs, NetCDFVariables netCDFVariables) throws IOException {
        String productType = product.getProductType();
        if (globalAttribs.isImappFormat()) {
            productType = productType + "_IMAPP";
        }
        this.addBandsToProduct(netCDFVariables, productType, product);
        if (ModisFileReader.isEosGridType(globalAttribs)) {
            this.addMapGeocoding(product, globalAttribs);
        } else {
            this.addTiePointGrids(netCDFVariables, productType, product, globalAttribs);
            this.addModisTiePointGeoCoding(product, null);
        }
    }

    public ModisBandReader getBandReader(Band band) {
        return this.bandReaderMap.get(band);
    }

    static boolean isEosGridType(ModisGlobalAttributes globalAttribs) throws IOException {
        return "EOS_TYPE_GRID".equals(globalAttribs.getEosType());
    }

    private static int[] getNamedIntAttribute(Variable variable, String name) {
        List attributes = variable.getAttributes();
        for (Attribute attribute : attributes) {
            if (!attribute.getShortName().equals(name)) continue;
            Array values = attribute.getValues();
            long size = values.getSize();
            int[] result = new int[(int)size];
            int i = 0;
            while ((long)i < size) {
                result[i] = values.getInt(i);
                ++i;
            }
            return result;
        }
        return new int[0];
    }

    private static float[] getNamedFloatAttribute(NetCDFAttributes attributes, String name) {
        Attribute attribute = attributes.get(name);
        if (attribute != null) {
            return NetCDFUtils.getFloatValues(attribute);
        }
        return new float[0];
    }

    private void addBandsToProduct(NetCDFVariables netCDFVariables, String type, Product product) throws IOException {
        String[] bandNames;
        String prodType = ModisFileReader.getTypeString(type, product);
        int width = product.getSceneRasterWidth();
        int height = product.getSceneRasterHeight();
        for (String bandName : bandNames = this.prodDb.getBandNames(prodType)) {
            ModisBandDescription bandDesc = this.prodDb.getBandDescription(prodType, bandName);
            if (bandDesc == null) {
                this.logger.warning("No band description for band '" + bandName + "' of product type '" + prodType + "'");
                continue;
            }
            ModisBandReader[] bandReaders = ModisBandReaderFactory.getReaders(netCDFVariables, bandDesc);
            Variable variable = netCDFVariables.get(bandName);
            if (variable == null) {
                this.logger.warning("Name Variable '" + bandName + "' of product type '" + prodType + "' not found");
                continue;
            }
            List attributes = variable.getAttributes();
            NetCDFAttributes netCDFAttributes = new NetCDFAttributes();
            netCDFAttributes.add(attributes);
            String bandNameExtensions = this.getBandNameExtensions(bandDesc.getBandAttribName(), prodType, netCDFAttributes, netCDFVariables);
            float[] scales = ModisFileReader.getNamedFloatAttribute(netCDFAttributes, bandDesc.getScaleAttribName());
            float[] offsets = ModisFileReader.getNamedFloatAttribute(netCDFAttributes, bandDesc.getOffsetAttribName());
            for (int readerIdx = 0; readerIdx < bandReaders.length; ++readerIdx) {
                ModisBandReader bandReader = bandReaders[readerIdx];
                String bandNameExt = null;
                if (bandNameExtensions != null) {
                    if (bandReaders.length > 1) {
                        bandNameExt = ModisUtils.decodeBandName(bandNameExtensions, readerIdx);
                        String name = bandReader.getName() + bandNameExt;
                        bandReader.setName(name);
                    } else {
                        bandNameExt = bandNameExtensions;
                    }
                }
                String readerBandName = bandReader.getName();
                Band band = new Band(readerBandName, bandReader.getDataType(), width, height);
                ModisFileReader.setValidRangeAndFillValue(variable, bandReader, band);
                if (bandDesc.getScalingMethod() != null) {
                    if (ModisFileReader.hasInvalidScaleAndOffset(scales, offsets, readerIdx)) {
                        this.logger.warning("Unable to assign the scaling method '" + bandDesc.getScalingMethod() + "' to the band '" + bandName + '\'');
                    } else if (bandDesc.isExponentialScaled()) {
                        bandReader.setScaleAndOffset(scales[readerIdx], offsets[readerIdx]);
                    } else if (bandDesc.isLinearScaled()) {
                        band.setScalingFactor((double)scales[readerIdx]);
                        band.setScalingOffset((double)(-offsets[readerIdx] * scales[readerIdx]));
                    } else if (bandDesc.isLinearInvertedScaled()) {
                        ModisFileReader.invert(scales);
                        band.setScalingFactor((double)scales[readerIdx]);
                        band.setScalingOffset((double)(-offsets[readerIdx] * scales[readerIdx]));
                    } else if (bandDesc.isSlopeInterceptScaled()) {
                        band.setScalingFactor((double)scales[readerIdx]);
                        band.setScalingOffset((double)offsets[readerIdx]);
                    } else if (bandDesc.isPow10Scaled()) {
                        bandReader.setScaleAndOffset(scales[readerIdx], offsets[readerIdx]);
                    }
                }
                ModisFileReader.setBandSpectralInformation(bandDesc, bandNameExt, band);
                ModisFileReader.setBandPhysicalUnit(variable, bandDesc, band);
                ModisFileReader.setBandDescription(variable, bandDesc, band);
                product.addBand(band);
                this.bandReaderMap.put(band, bandReader);
            }
        }
    }

    static void invert(float[] scales) {
        for (int i = 0; i < scales.length; ++i) {
            if (scales[i] == 0.0f) continue;
            scales[i] = 1.0f / scales[i];
        }
    }

    static String getTypeString(String type, Product product) {
        String prodType = type == null ? product.getProductType() : type;
        return prodType;
    }

    static boolean hasInvalidScaleAndOffset(float[] scales, float[] offsets, int readerIdx) {
        return scales.length <= readerIdx || offsets.length <= readerIdx;
    }

    private static void setValidRangeAndFillValue(Variable variable, ModisBandReader reader, Band band) throws IOException {
        int[] fillValue;
        int[] rangeArray = ModisFileReader.getNamedIntAttribute(variable, "valid_range");
        Range range = ModisFileReader.createRangeFromArray(rangeArray);
        if (range != null) {
            reader.setValidRange(range);
        }
        if ((fillValue = ModisFileReader.getNamedIntAttribute(variable, "_FillValue")) != null && fillValue.length >= 1) {
            reader.setFillValue(fillValue[0]);
            band.setNoDataValue((double)fillValue[0]);
            band.setNoDataValueUsed(true);
        }
    }

    private static void setBandDescription(Variable variable, ModisBandDescription bandDesc, Band band) throws IOException {
        String descriptionAttribName = bandDesc.getDescriptionAttribName();
        List attributes = variable.getAttributes();
        for (Attribute attribute : attributes) {
            if (!attribute.getShortName().equalsIgnoreCase(descriptionAttribName)) continue;
            String description = attribute.getStringValue();
            band.setDescription(description);
            return;
        }
    }

    private static void setBandPhysicalUnit(Variable variable, ModisBandDescription bandDesc, Band band) throws IOException {
        String unitAttribName = bandDesc.getUnitAttribName();
        List attributes = variable.getAttributes();
        for (Attribute attribute : attributes) {
            if (!attribute.getShortName().equalsIgnoreCase(unitAttribName)) continue;
            String unit = attribute.getStringValue();
            band.setUnit(unit);
            return;
        }
    }

    static void setBandSpectralInformation(ModisBandDescription bandDesc, String bandNameExt, Band band) {
        if (bandDesc.isSpectral()) {
            if (bandDesc.hasSpectralInfo()) {
                ModisSpectralInfo specInfo = bandDesc.getSpecInfo();
                band.setSpectralWavelength(specInfo.getSpectralWavelength());
                band.setSpectralBandwidth(specInfo.getSpectralBandwidth());
                band.setSpectralBandIndex(specInfo.getSpectralBandIndex());
            } else {
                float[] data = ModisUtils.decodeSpectralInformation(bandNameExt, null);
                band.setSpectralWavelength(data[0]);
                band.setSpectralBandwidth(data[1]);
                band.setSpectralBandIndex((int)data[2]);
            }
        } else {
            band.setSpectralBandIndex(-1);
        }
    }

    private void addModisTiePointGeoCoding(Product product, NetCDFVariables netCDFVariables) throws IOException {
        ModisProductDescription prodDesc = this.prodDb.getProductDescription(product.getProductType());
        String[] geolocationDatasetNames = prodDesc.hasExternalGeolocation() ? this.loadExternalQCFile(product, prodDesc, netCDFVariables) : prodDesc.getGeolocationDatasetNames();
        if (geolocationDatasetNames != null) {
            TiePointGrid latGrid = product.getTiePointGrid(geolocationDatasetNames[0]);
            TiePointGrid lonGrid = product.getTiePointGrid(geolocationDatasetNames[1]);
            if (latGrid != null && lonGrid != null) {
                lonGrid.setDiscontinuity(180);
                ModisTiePointGeoCoding coding = new ModisTiePointGeoCoding(latGrid, lonGrid);
                product.setSceneGeoCoding((GeoCoding)coding);
            }
        }
    }

    private void addTiePointGrids(NetCDFVariables netCDFVariables, String productType, Product prod, ModisGlobalAttributes globalAttribs) throws IOException {
        String[] tiePointGridNames;
        for (String tiePointGridName : tiePointGridNames = this.prodDb.getTiePointNames(productType)) {
            Variable variable = netCDFVariables.get(tiePointGridName);
            if (variable == null) {
                this.logger.warning("Unable to access tie point grid: '" + tiePointGridName + '\'');
                continue;
            }
            NetCDFAttributes attributes = new NetCDFAttributes();
            attributes.add(variable.getAttributes());
            TiePointGrid grid = this.readNamedTiePointGrid(variable, attributes, productType, tiePointGridName, globalAttribs);
            if (grid == null) continue;
            prod.addTiePointGrid(grid);
        }
    }

    private TiePointGrid readNamedTiePointGrid(Variable variable, NetCDFAttributes netCDFAttributes, String prodType, String name, ModisGlobalAttributes globalAttribs) throws IOException {
        TiePointGrid gridRet = null;
        ModisTiePointDescription desc = this.prodDb.getTiePointDescription(prodType, name);
        DataType ncDataType = variable.getDataType();
        int dataType1 = DataTypeUtils.getEquivalentProductDataType((DataType)ncDataType, (boolean)false, (boolean)false);
        List dimensions = variable.getDimensions();
        int height = ((Dimension)dimensions.get(0)).getLength();
        int width = ((Dimension)dimensions.get(1)).getLength();
        float[] floatBuffer = new float[width * height];
        Array array = variable.read();
        for (int i = 0; i < floatBuffer.length; ++i) {
            floatBuffer[i] = array.getFloat(i);
        }
        String scaleAttribName = desc.getScaleAttribName();
        float[] scale = new float[]{1.0f};
        if (scaleAttribName != null && ((scale = ModisFileReader.getNamedFloatAttribute(netCDFAttributes, scaleAttribName)) == null || scale.length <= 0)) {
            scale = new float[]{1.0f};
        }
        String offsetAttribName = desc.getOffsetAttribName();
        float[] offset = new float[]{0.0f};
        if (offsetAttribName != null && ((offset = ModisFileReader.getNamedFloatAttribute(netCDFAttributes, offsetAttribName)) == null || offset.length <= 0)) {
            offset = new float[]{0.0f};
        }
        floatBuffer = ModisFileReader.scaleArray(dataType1, floatBuffer, scale[0], offset[0]);
        HdfDataField field = globalAttribs.getDatafield(name);
        String[] dimNames = field.getDimensionNames();
        int[] tiePtInfoX = globalAttribs.getSubsamplingAndOffset(dimNames[0]);
        int[] tiePtInfoY = globalAttribs.getSubsamplingAndOffset(dimNames[1]);
        if (tiePtInfoX != null && tiePtInfoY != null && tiePtInfoX.length > 1 && tiePtInfoY.length > 1) {
            String units;
            gridRet = new TiePointGrid(name, width, height, (double)tiePtInfoX[1], (double)((float)tiePtInfoY[1] + 0.5f), (double)tiePtInfoX[0], (double)tiePtInfoY[0], floatBuffer);
            String unitAttribName = desc.getUnitAttribName();
            if (unitAttribName != null && (units = NetCDFUtils.getNamedStringAttribute(unitAttribName, netCDFAttributes)) != null) {
                gridRet.setUnit(units);
            }
        } else {
            this.logger.warning("Unable to access tie point grid: '" + name + '\'');
        }
        return gridRet;
    }

    private static float[] scaleArray(int dataType, float[] buffer, float scale, float offset) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (dataType != 30) break block5;
                            for (int n = 0; n < buffer.length; ++n) {
                                buffer[n] = scale * buffer[n] + offset;
                            }
                            break block6;
                        }
                        if (dataType != 10) break block7;
                        for (int n = 0; n < buffer.length; ++n) {
                            buffer[n] = buffer[n] * scale + offset;
                        }
                        break block6;
                    }
                    if (dataType != 20) break block8;
                    for (int n = 0; n < buffer.length; ++n) {
                        buffer[n] = buffer[n] < 0.0f ? (buffer[n] + 256.0f) * scale + offset : buffer[n] * scale + offset;
                    }
                    break block6;
                }
                if (dataType != 11) break block9;
                for (int n = 0; n < buffer.length; ++n) {
                    buffer[n] = buffer[n] * scale + offset;
                }
                break block6;
            }
            if (dataType != 21) break block6;
            for (int n = 0; n < buffer.length; ++n) {
                buffer[n] = buffer[n] < 0.0f ? (buffer[n] + 65536.0f) * scale + offset : buffer[n] * scale + offset;
            }
        }
        return buffer;
    }

    private String[] loadExternalQCFile(Product product, ModisProductDescription prodDesc, NetCDFVariables netCDFVariables) throws IOException {
        String[] tiePointGridNames;
        FileContainer qcFileContainer = ModisFileReader.assembleQCFile(product, prodDesc);
        if (qcFileContainer == null) {
            this.logger.warning("MODIS QC file not found.");
            return null;
        }
        File qcFileContainerFile = qcFileContainer.getFile();
        this.logger.info("MODIS QC file found: " + qcFileContainerFile.getPath());
        this.qcFile = NetcdfFileOpener.open((Object)qcFileContainerFile.getPath());
        if (this.qcFile == null) {
            throw new IOException("Failed to open file " + qcFileContainerFile.getPath());
        }
        NetCDFAttributes netCDFQCAttributes = new NetCDFAttributes();
        netCDFQCAttributes.add(this.qcFile.getGlobalAttributes());
        NetCDFVariables netCDFQCVariables = new NetCDFVariables();
        netCDFQCVariables.add(this.qcFile.getVariables());
        ModisGlobalAttributes globalAttributes = this.isImappFormat(netCDFQCVariables) ? new ImappAttributes(qcFileContainerFile, netCDFQCVariables, netCDFQCAttributes) : new DaacAttributes(netCDFQCVariables);
        for (String tiePointGridName : tiePointGridNames = this.prodDb.getTiePointNames(qcFileContainer.getType())) {
            TiePointGrid grid;
            Variable variable = netCDFQCVariables.get(tiePointGridName);
            if (variable == null || (grid = this.readNamedTiePointGrid(variable, netCDFQCAttributes, qcFileContainer.getType(), tiePointGridName, globalAttributes)) == null) continue;
            product.addTiePointGrid(grid);
        }
        this.addBandsToProduct(netCDFVariables, qcFileContainer.getType(), product);
        return tiePointGridNames;
    }

    private static FileContainer assembleQCFile(Product product, ModisProductDescription desc) {
        if (product.getProductType().length() < 2) {
            return null;
        }
        String qcProductType = ModisFileReader.getQcFileType(product, desc);
        File productFile = product.getFileLocation();
        String qcFileNamePart = ModisFileReader.getQcFileNamePart(productFile, qcProductType);
        File productDir = productFile.getParentFile();
        if (productDir != null) {
            Debug.trace((String)("searching for MODIS QC file: " + new File(productDir, '*' + qcFileNamePart + '*').getPath()));
            File[] qcFileList = productDir.listFiles(new QCFileFilter(qcFileNamePart));
            if (qcFileList != null && qcFileList.length > 0) {
                File qcFile = qcFileList[0];
                Debug.trace((String)("MODIS QC file found: " + qcFile.getPath()));
                return new FileContainer(qcFile, qcProductType);
            }
        }
        return null;
    }

    private static String getQcFileNamePart(File productFile, String qcProductType) {
        String fileName = FileUtils.getFilenameWithoutExtension((String)productFile.getName());
        int startPos = fileName.indexOf(46);
        int endPos = fileName.lastIndexOf(46);
        String toAppend = "";
        if (startPos > 0 && endPos > startPos) {
            toAppend = fileName.substring(startPos, endPos);
        }
        return qcProductType + toAppend;
    }

    private static String getQcFileType(Product product, ModisProductDescription desc) {
        String replaceWith = product.getProductType().substring(1, 2);
        String pattern = desc.getExternalGeolocationPattern();
        return pattern.replaceFirst("[xX]", replaceWith);
    }

    private String getBandNameExtensions(String bandNameAttribName, String productType, NetCDFAttributes attributes, NetCDFVariables netCDFVariables) {
        if (StringUtils.isNullOrEmpty((String)bandNameAttribName)) {
            return null;
        }
        String bandNameExtensions = null;
        if (bandNameAttribName.startsWith("@")) {
            String correspBand = bandNameAttribName.substring(1);
            ModisBandDescription desc = this.prodDb.getBandDescription(productType, correspBand);
            String bandAttribName = desc.getBandAttribName();
            String attributeValue = NetCDFUtils.getNamedStringAttribute(bandAttribName, attributes);
            if (StringUtils.isNullOrEmpty((String)attributeValue)) {
                Variable correspVariable = netCDFVariables.get(correspBand);
                if (correspVariable != null) {
                    NetCDFAttributes correspAttributes = new NetCDFAttributes();
                    correspAttributes.add(correspVariable.getAttributes());
                    bandNameExtensions = NetCDFUtils.getNamedStringAttribute(bandAttribName, correspAttributes);
                }
            } else {
                bandNameExtensions = attributeValue;
            }
        } else {
            bandNameExtensions = StringUtils.isIntegerString((String)bandNameAttribName) ? bandNameAttribName : NetCDFUtils.getNamedStringAttribute(bandNameAttribName, attributes);
        }
        return bandNameExtensions;
    }

    static Range createRangeFromArray(int[] rangeArray) {
        if (rangeArray != null && rangeArray.length >= 2) {
            Range range = new Range();
            range.setMin(rangeArray[0] < rangeArray[1] ? (double)rangeArray[0] : (double)rangeArray[1]);
            range.setMax(rangeArray[0] > rangeArray[1] ? (double)rangeArray[0] : (double)rangeArray[1]);
            return range;
        }
        return null;
    }

    private void addMapGeocoding(Product product, ModisGlobalAttributes globalAttribs) {
        product.setSceneGeoCoding(globalAttribs.createGeocoding());
    }

    private boolean isImappFormat(NetCDFVariables netCDFQCVariables) {
        return netCDFQCVariables.get("StructMetadata\\.0") == null;
    }

    public void close() throws IOException {
        if (this.qcFile != null) {
            this.qcFile.close();
            this.qcFile = null;
        }
    }

    static class FileContainer {
        private String _fileType;
        private File _file;

        public FileContainer(File file, String type) {
            this._file = file;
            this._fileType = type;
        }

        public File getFile() {
            return this._file;
        }

        public String getType() {
            return this._fileType;
        }
    }

    static class QCFileFilter
    implements FilenameFilter {
        private final String _fileNamePart;

        public QCFileFilter(String fileNamePart) {
            this._fileNamePart = fileNamePart;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.contains(this._fileNamePart);
        }
    }
}

