/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.esa.s3tbx.dataio.modis.netcdf.NetCDFVariables;
import org.esa.s3tbx.dataio.modis.productdb.ModisProductDb;
import org.esa.snap.core.dataio.ProductIOException;
import ucar.nc2.Variable;

public class ModisDaacUtils {
    public static String extractCoreString(NetCDFVariables netCDFVariables) throws IOException {
        Variable[] variables;
        String coreKey = "CoreMetadata\\.0";
        String coreString = "CoreMetadata\\.0".substring(0, "CoreMetadata\\.0".length() - 2);
        StringBuilder buffer = new StringBuilder();
        for (Variable variable : variables = netCDFVariables.getAll()) {
            String name = variable.getFullName();
            if (!name.startsWith(coreString) || name.length() != "CoreMetadata\\.0".length()) continue;
            buffer.append(variable.readScalarString());
        }
        return ModisDaacUtils.correctAmpersandWrap(buffer.toString());
    }

    public static String correctAmpersandWrap(String input) {
        StringReader reader = new StringReader(input);
        StringWriter result = new StringWriter();
        boolean ampersandMode = false;
        boolean maybeAmpersandMode = false;
        try {
            int current = reader.read();
            while (current > -1) {
                if (maybeAmpersandMode) {
                    if (current == 10 || current == 13) {
                        ampersandMode = true;
                        maybeAmpersandMode = false;
                    } else {
                        result.write(38);
                        maybeAmpersandMode = false;
                    }
                }
                if (ampersandMode) {
                    if (current != 10 && current != 13 && current != 32) {
                        result.write(current);
                        ampersandMode = false;
                    }
                } else if (current == 38) {
                    maybeAmpersandMode = true;
                } else {
                    result.write(current);
                }
                current = reader.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toString();
    }

    public static String extractProductType(String s) throws ProductIOException {
        ModisProductDb db = ModisProductDb.getInstance();
        ArrayList<String> prodType = ModisDaacUtils.extractProductTypeBySeparatorChar(s, db, ".");
        if (prodType.size() == 1) {
            return prodType.get(0);
        }
        prodType = ModisDaacUtils.extractProductTypeBySeparatorChar(s, db, "_");
        if (prodType.size() == 1) {
            return prodType.get(0);
        }
        return "";
    }

    private static ArrayList<String> extractProductTypeBySeparatorChar(String s, ModisProductDb db, String delim) throws ProductIOException {
        ArrayList<String> prodType = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(s, delim);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!db.isSupportedProduct(token)) continue;
            prodType.add(token);
        }
        return prodType;
    }
}

