/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.merisl3;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.esa.beam.dataio.merisl3.MerisL3FileFilter;
import org.esa.beam.dataio.merisl3.MerisL3ProductReader;
import org.esa.beam.dataio.netcdf.util.NetcdfFileOpener;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;
import ucar.nc2.NetcdfFile;

public class MerisL3ProductReaderPlugIn
implements ProductReaderPlugIn {
    public static final String FORMAT_NAME = "L3_ENV_MER";
    public static final String FORMAT_DESCRIPTION = "MERIS Binned Level-3 (netCDF) Data Product";
    public static final String FILE_EXTENSION = ".nc";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecodeQualification getDecodeQualification(Object input) {
        NetcdfFile netcdfFile;
        if (input == null) {
            return DecodeQualification.UNABLE;
        }
        String path = input.toString();
        String name = new File(path).getName();
        if (!MerisL3FileFilter.isMerisBinnedL3Name(name)) {
            return DecodeQualification.UNABLE;
        }
        try {
            netcdfFile = NetcdfFileOpener.open((Object)path);
            if (netcdfFile == null) {
                return DecodeQualification.UNABLE;
            }
        }
        catch (IOException e) {
            return DecodeQualification.UNABLE;
        }
        try {
            if (netcdfFile.getRootGroup().findVariable("idx") == null) {
                DecodeQualification e = DecodeQualification.UNABLE;
                return e;
            }
        }
        finally {
            try {
                netcdfFile.close();
            }
            catch (IOException e) {}
        }
        return DecodeQualification.INTENDED;
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class};
    }

    public ProductReader createReaderInstance() {
        return new MerisL3ProductReader(this);
    }

    public BeamFileFilter getProductFileFilter() {
        return new MerisL3FileFilter();
    }

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{FILE_EXTENSION};
    }

    public String getDescription(Locale locale) {
        return "Reader for the MERIS binned Level-3 netCDF format";
    }
}

