/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.smilecorr;

import java.io.IOException;
import java.nio.file.Path;
import org.esa.s3tbx.meris.radiometry.smilecorr.SmileCorrectionAuxdata;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SmileCorrectionAuxdataTest {
    private static SmileCorrectionAuxdata rrData;
    private static SmileCorrectionAuxdata frData;
    private static Path auxdataDir;

    @BeforeClass
    public static void beforeClass() throws Exception {
        auxdataDir = SmileCorrectionAuxdata.installAuxdata();
        rrData = SmileCorrectionAuxdata.loadRRAuxdata((Path)auxdataDir);
        frData = SmileCorrectionAuxdata.loadFRAuxdata((Path)auxdataDir);
    }

    @Test
    public void testThatDataIsReloadedWithoutUsingStaticArrayInstances() {
        SmileCorrectionAuxdata rrData = null;
        try {
            rrData = SmileCorrectionAuxdata.loadRRAuxdata((Path)auxdataDir);
        }
        catch (IOException e) {
            Assert.fail((String)("IOException not expected: " + e.getMessage()));
        }
        Assert.assertNotSame((Object)rrData.getRadCorrFlagsLand(), (Object)SmileCorrectionAuxdataTest.rrData.getRadCorrFlagsLand());
        Assert.assertNotSame((Object)rrData.getRadCorrFlagsWater(), (Object)SmileCorrectionAuxdataTest.rrData.getRadCorrFlagsWater());
        Assert.assertNotSame((Object)rrData.getLowerBandIndexesLand(), (Object)SmileCorrectionAuxdataTest.rrData.getLowerBandIndexesLand());
        Assert.assertNotSame((Object)rrData.getLowerBandIndexesWater(), (Object)SmileCorrectionAuxdataTest.rrData.getLowerBandIndexesWater());
        Assert.assertNotSame((Object)rrData.getUpperBandIndexesLand(), (Object)SmileCorrectionAuxdataTest.rrData.getUpperBandIndexesLand());
        Assert.assertNotSame((Object)rrData.getUpperBandIndexesWater(), (Object)SmileCorrectionAuxdataTest.rrData.getUpperBandIndexesWater());
        Assert.assertNotSame((Object)rrData.getTheoreticalWavelengths(), (Object)SmileCorrectionAuxdataTest.rrData.getTheoreticalWavelengths());
        Assert.assertNotSame((Object)rrData.getTheoreticalSunSpectralFluxes(), (Object)SmileCorrectionAuxdataTest.rrData.getTheoreticalSunSpectralFluxes());
        Assert.assertNotSame((Object)rrData.getDetectorWavelengths(), (Object)SmileCorrectionAuxdataTest.rrData.getDetectorWavelengths());
        Assert.assertNotSame((Object)rrData.getDetectorSunSpectralFluxes(), (Object)SmileCorrectionAuxdataTest.rrData.getDetectorSunSpectralFluxes());
    }

    @Test
    public void testCurrentRrData() {
        Assert.assertEquals((Object)true, (Object)rrData.getRadCorrFlagsLand()[12]);
        Assert.assertEquals((long)12L, (long)rrData.getLowerBandIndexesLand()[12]);
        Assert.assertEquals((long)13L, (long)rrData.getUpperBandIndexesLand()[12]);
        Assert.assertEquals((Object)true, (Object)rrData.getRadCorrFlagsWater()[12]);
        Assert.assertEquals((long)12L, (long)rrData.getLowerBandIndexesWater()[12]);
        Assert.assertEquals((long)13L, (long)rrData.getUpperBandIndexesWater()[12]);
        Assert.assertEquals((double)865.0, (double)rrData.getTheoreticalWavelengths()[12], (double)1.0E-6);
        Assert.assertEquals((double)958.763, (double)rrData.getTheoreticalSunSpectralFluxes()[12], (double)1.0E-6);
        Assert.assertEquals((double)490.0209579, (double)rrData.getDetectorWavelengths()[20][2], (double)1.0E-6);
        Assert.assertEquals((double)1929.29938966317, (double)rrData.getDetectorSunSpectralFluxes()[20][2], (double)1.0E-10);
    }

    @Test
    public void testCurrentFrData() {
        Assert.assertEquals((Object)true, (Object)frData.getRadCorrFlagsLand()[2]);
        Assert.assertEquals((long)1L, (long)frData.getLowerBandIndexesLand()[2]);
        Assert.assertEquals((long)3L, (long)frData.getUpperBandIndexesLand()[2]);
        Assert.assertEquals((Object)true, (Object)frData.getRadCorrFlagsWater()[2]);
        Assert.assertEquals((long)1L, (long)frData.getLowerBandIndexesWater()[2]);
        Assert.assertEquals((long)3L, (long)frData.getUpperBandIndexesWater()[2]);
        Assert.assertEquals((double)490.0, (double)frData.getTheoreticalWavelengths()[2], (double)1.0E-6);
        Assert.assertEquals((double)1929.26, (double)frData.getTheoreticalSunSpectralFluxes()[2], (double)1.0E-6);
        Assert.assertEquals((double)490.1104498, (double)frData.getDetectorWavelengths()[20][2], (double)1.0E-6);
        Assert.assertEquals((double)1930.1682671039, (double)frData.getDetectorSunSpectralFluxes()[20][2], (double)1.0E-10);
    }
}

