/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.equalization;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.Assert;
import org.esa.s3tbx.meris.radiometry.equalization.EqualizationLUT;
import org.junit.Test;

public class EqualizationLUTTest {
    @Test
    public void testGetCoefficients() throws IOException {
        Reader[] readers = new Reader[]{new StringReader("1.0 2.0 3.0\n4.0 5.0 6.0"), new StringReader("0.1 0.2 0.3\n0.4 0.5 0.6")};
        EqualizationLUT lut = new EqualizationLUT(readers);
        double[] expected = new double[]{1.0, 2.0, 3.0};
        this.compare(expected, lut.getCoefficients(0, 0));
        expected = new double[]{4.0, 5.0, 6.0};
        this.compare(expected, lut.getCoefficients(0, 1));
        expected = new double[]{0.1, 0.2, 0.3};
        this.compare(expected, lut.getCoefficients(1, 0));
        expected = new double[]{0.4, 0.5, 0.6};
        this.compare(expected, lut.getCoefficients(1, 1));
    }

    private void compare(double[] expected, double[] actualCoefficients) {
        Assert.assertEquals((Object)expected[0], (Object)actualCoefficients[0]);
        Assert.assertEquals((Object)expected[1], (Object)actualCoefficients[1]);
        Assert.assertEquals((Object)expected[2], (Object)actualCoefficients[2]);
    }
}

