/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.calibration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.esa.snap.dataio.envisat.DSD;
import org.esa.snap.dataio.envisat.Field;
import org.esa.snap.dataio.envisat.MerisRacProductFile;
import org.esa.snap.dataio.envisat.ProductFile;
import org.esa.snap.dataio.envisat.Record;
import org.esa.snap.dataio.envisat.RecordReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class AuxiliaryDataTest {
    private static final int FR_ELEMENT_COUNT = 3700;
    private static final int RR_ELEMENT_COUNT = 925;
    private static final String[] PRODUCT_RESOURCE_NAMES = new String[]{"MER_RAC_AXVACR20091016_154511_20021224_121445_20041213_220000", "MER_RAC_AXVACR20091023_105043_20020429_041400_20021224_121445", "MER_RAC_AXVIEC20050708_135224_20020321_193100_20021224_121445", "MER_RAC_AXVIEC20050708_135553_20021224_121445_20041213_220000", "MER_RAC_AXVIEC20050708_135806_20041213_220000_20141213_220000", "MER_RAC_AXVIEC20061009_084736_20061009_220000_20161009_220000"};
    private List<ProductFile> productFileList;

    @Test
    public void validGainFR() throws IOException {
        this.assertValidity("Gain_FR", 15, new String[]{"gain"}, new int[]{3700});
    }

    @Test
    public void validGainRR() throws IOException {
        this.assertValidity("Gain_RR", 15, new String[]{"gain"}, new int[]{925});
    }

    @Test
    public void validDegradationFR() throws IOException {
        this.assertValidity("Degradation_FR", 15, new String[]{"dsr_time", "beta", "gamma", "delta"}, new int[]{1, 3700, 3700, 3700});
    }

    @Test
    public void validDegradationRR() throws IOException {
        this.assertValidity("Degradation_RR", 15, new String[]{"dsr_time", "beta", "gamma", "delta"}, new int[]{1, 925, 925, 925});
    }

    @Test
    public void equalGains() throws IOException {
        for (int b = 0; b < 15; ++b) {
            this.testEquality("Gain_FR", b, "gain");
        }
    }

    @Test
    public void equalBetas() throws IOException {
        for (int b = 0; b < 15; ++b) {
            this.testEquality("Degradation_FR", 0, "beta");
        }
    }

    @Test
    public void equalGammas() throws IOException {
        for (int b = 0; b < 15; ++b) {
            this.testEquality("Degradation_FR", 0, "gamma");
        }
    }

    @Test
    public void equalDeltas() throws IOException {
        for (int b = 0; b < 15; ++b) {
            this.testEquality("Degradation_FR", 0, "delta");
        }
    }

    @Ignore
    @Test
    public void printGains() throws IOException {
        this.printToFile("Gain_FR", 0, "gain", new File("gains.csv"));
    }

    @Ignore
    @Test
    public void printBetas() throws IOException {
        this.printToFile("Degradation_FR", 0, "beta", new File("betas.csv"));
    }

    @Ignore
    @Test
    public void printGammas() throws IOException {
        this.printToFile("Degradation_FR", 0, "gamma", new File("gammas.csv"));
    }

    @Ignore
    @Test
    public void printDeltas() throws IOException {
        this.printToFile("Degradation_FR", 0, "delta", new File("deltas.csv"));
    }

    private void assertValidity(String datasetName, int recordCountExpected, String[] fieldNames, int[] fieldElementCountsExpected) throws IOException {
        for (ProductFile productFile : this.productFileList) {
            DSD dsd = productFile.getDSD(datasetName);
            Assert.assertNotNull((Object)dsd);
            RecordReader recordReader = productFile.getRecordReader(datasetName);
            Assert.assertNotNull((Object)recordReader);
            Assert.assertEquals((long)recordCountExpected, (long)recordReader.getNumRecords());
            Record record = recordReader.readRecord();
            Assert.assertNotNull((Object)record);
            for (int i = 0; i < fieldNames.length; ++i) {
                Field field = record.getField(fieldNames[i]);
                Assert.assertNotNull((Object)field);
                Assert.assertEquals((long)fieldElementCountsExpected[i], (long)field.getNumElems());
                if (field.isIntType()) continue;
                for (int k = 0; k < fieldElementCountsExpected[i]; ++k) {
                    float value = field.getElemFloat(k);
                    Assert.assertFalse((String)MessageFormat.format("Expected valid value, actual value of ''{0}[{1}]'' is NaN", field.getName(), k), (boolean)Float.isNaN(value));
                    Assert.assertFalse((String)MessageFormat.format("Expected valid value, actual value of ''{0}[{1}]'' is infinite", field.getName(), k), (boolean)Float.isInfinite(value));
                    Assert.assertTrue((String)MessageFormat.format("Expected value in (0, 1], actual value of ''{0}[{1}]'' is {2}", field.getName(), k, Float.valueOf(value)), (value > 0.0f && value <= 1.0f ? 1 : 0) != 0);
                }
            }
        }
    }

    private void testEquality(String datasetName, int recordIndex, String fieldName) throws IOException {
        ArrayList<float[]> arrayList = new ArrayList<float[]>(6);
        for (ProductFile productFile : this.productFileList) {
            RecordReader recordReader = productFile.getRecordReader(datasetName);
            Record record = recordReader.readRecord(recordIndex);
            arrayList.add((float[])record.getField(fieldName).getElems());
        }
        for (int i = 0; i < 3700; ++i) {
            Assert.assertEquals((double)((float[])arrayList.get(0))[i], (double)((float[])arrayList.get(1))[i], (double)1.0E-8);
            Assert.assertEquals((double)((float[])arrayList.get(2))[i], (double)((float[])arrayList.get(3))[i], (double)1.0E-8);
            Assert.assertEquals((double)((float[])arrayList.get(3))[i], (double)((float[])arrayList.get(4))[i], (double)1.0E-8);
            Assert.assertEquals((double)((float[])arrayList.get(4))[i], (double)((float[])arrayList.get(5))[i], (double)1.0E-8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void printToFile(String datasetName, int recordIndex, String fieldName, File file) throws IOException {
        ArrayList<float[]> arrayList = new ArrayList<float[]>(6);
        for (ProductFile productFile : this.productFileList) {
            RecordReader recordReader = productFile.getRecordReader(datasetName);
            Record record = recordReader.readRecord(recordIndex);
            arrayList.add((float[])record.getField(fieldName).getElems());
        }
        try (PrintStream ps = new PrintStream(file);){
            void var7_10;
            for (ProductFile productFile : this.productFileList) {
                ps.print(productFile.getFile().getName() + ",");
            }
            ps.println();
            boolean bl = false;
            while (var7_10 < 3700) {
                for (float[] array : arrayList) {
                    ps.print(array[var7_10] + ",");
                }
                ps.println();
                ++var7_10;
            }
        }
    }

    @Before
    public void initProductFiles() throws URISyntaxException, IOException {
        this.productFileList = new ArrayList<ProductFile>(6);
        for (String productFileName : PRODUCT_RESOURCE_NAMES) {
            InputStream stream = this.getClass().getResourceAsStream(productFileName);
            MerisRacProductFile productFile = new MerisRacProductFile((ImageInputStream)new MemoryCacheImageInputStream(stream));
            this.productFileList.add((ProductFile)productFile);
        }
    }

    @After
    public void closeProductFiles() throws IOException {
        for (ProductFile productFile : this.productFileList) {
            productFile.close();
        }
    }
}

