/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.equalization;

import org.esa.s3tbx.meris.radiometry.equalization.ReprocessingVersion;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.junit.Assert;
import org.junit.Test;

public class ReprocessingVersionTest {
    @Test
    public void testParseReprocessingVersion_RR() {
        Assert.assertEquals((Object)ReprocessingVersion.AUTO_DETECT, (Object)ReprocessingVersion.detectReprocessingVersion((String)"MER_RAC_AXVIEC20050606_071652_20021224_121445_20041213_220000", (boolean)true));
        Assert.assertEquals((Object)ReprocessingVersion.REPROCESSING_2, (Object)ReprocessingVersion.detectReprocessingVersion((String)"MER_RAC_AXVIEC20050607_071652_20021224_121445_20041213_220000", (boolean)true));
        Assert.assertEquals((Object)ReprocessingVersion.REPROCESSING_2, (Object)ReprocessingVersion.detectReprocessingVersion((String)"MER_RAC_AXVIEC20070302", (boolean)true));
        Assert.assertEquals((Object)ReprocessingVersion.REPROCESSING_2, (Object)ReprocessingVersion.detectReprocessingVersion((String)"MER_RAC_AXVACR20091007_171024_20061009_220000_20161009_220000", (boolean)true));
        Assert.assertEquals((Object)ReprocessingVersion.REPROCESSING_3, (Object)ReprocessingVersion.detectReprocessingVersion((String)"MER_RAC_AXVACR20091008_171024_20061009_220000_20161009_220000", (boolean)true));
        Assert.assertEquals((Object)ReprocessingVersion.REPROCESSING_3, (Object)ReprocessingVersion.detectReprocessingVersion((String)"MER_RAC_AXVACR20111008", (boolean)true));
    }

    @Test
    public void testParseReprocessingVersion_FR() {
        Assert.assertEquals((Object)ReprocessingVersion.AUTO_DETECT, (Object)ReprocessingVersion.detectReprocessingVersion((String)"MER_RAC_AXVIEC20050707_135806_20041213_220000_20141213_220000", (boolean)false));
        Assert.assertEquals((Object)ReprocessingVersion.REPROCESSING_2, (Object)ReprocessingVersion.detectReprocessingVersion((String)"MER_RAC_AXVIEC20050708_135806_20041213_220000_20141213_220000", (boolean)false));
        Assert.assertEquals((Object)ReprocessingVersion.REPROCESSING_2, (Object)ReprocessingVersion.detectReprocessingVersion((String)"MER_RAC_AXVIEC20070302", (boolean)false));
        Assert.assertEquals((Object)ReprocessingVersion.REPROCESSING_2, (Object)ReprocessingVersion.detectReprocessingVersion((String)"MER_RAC_AXVACR20091007_171024_20061009_220000_20161009_220000", (boolean)false));
        Assert.assertEquals((Object)ReprocessingVersion.REPROCESSING_3, (Object)ReprocessingVersion.detectReprocessingVersion((String)"MER_RAC_AXVACR20091008_171024_20061009_220000_20161009_220000", (boolean)false));
        Assert.assertEquals((Object)ReprocessingVersion.REPROCESSING_3, (Object)ReprocessingVersion.detectReprocessingVersion((String)"MER_RAC_AXVACR20111008", (boolean)false));
    }

    @Test
    public void testAutoDetectFromProduct() {
        Product product = new Product("dummy", "barz", 2, 2);
        MetadataElement root = product.getMetadataRoot();
        MetadataElement dsd = new MetadataElement("DSD");
        MetadataElement dsd23 = new MetadataElement("DSD.23");
        dsd.addElement(dsd23);
        root.addElement(dsd);
        dsd23.setAttributeString("DATASET_NAME", "RADIOMETRIC_CALIBRATION_FILE");
        dsd23.setAttributeString("FILE_NAME", "MER_RAC_AXVIEC20050708_135806_20041213_220000_20141213_220000");
        Assert.assertEquals((Object)ReprocessingVersion.REPROCESSING_2, (Object)ReprocessingVersion.autoDetect((Product)product));
        dsd23.setAttributeString("DATASET_NAME", "Radiometric calibration");
        dsd23.setAttributeString("FILE_NAME", "MER_RAC_AXVACR20091008_171024_20061009_220000_20161009_220000");
        Assert.assertEquals((Object)ReprocessingVersion.REPROCESSING_3, (Object)ReprocessingVersion.autoDetect((Product)product));
    }
}

