/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.equalization;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Date;
import org.esa.s3tbx.meris.radiometry.equalization.EqualizationAlgorithm;
import org.esa.s3tbx.meris.radiometry.equalization.EqualizationLUT;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Assert;
import org.junit.Test;

public class EqualizationAlgorithmTest {
    @Test
    public void testPerformEqualization() throws Exception {
        ProductData.UTC utc = ProductData.UTC.create((Date)new Date(), (long)0L);
        Reader[] readers = new Reader[]{new StringReader("1.0 2.0 3.0\n4.0 5.0 6.0"), new StringReader("0.1 0.2 0.3\n0.4 0.5 0.6")};
        EqualizationAlgorithm algorithm = new EqualizationAlgorithm(utc, new EqualizationLUT(readers));
        long date = algorithm.getJulianDate();
        double sample = 100.0;
        long squareDate = date * date;
        Assert.assertEquals((double)(sample / (1.0 + 2.0 * (double)date + 3.0 * (double)squareDate)), (double)algorithm.performEqualization(sample, 0, 0), (double)1.0E-6);
        Assert.assertEquals((double)(sample / (4.0 + 5.0 * (double)date + 6.0 * (double)squareDate)), (double)algorithm.performEqualization(sample, 0, 1), (double)1.0E-6);
        Assert.assertEquals((double)(sample / (0.1 + 0.2 * (double)date + 0.3 * (double)squareDate)), (double)algorithm.performEqualization(sample, 1, 0), (double)1.0E-6);
        Assert.assertEquals((double)(sample / (0.4 + 0.5 * (double)date + 0.6 * (double)squareDate)), (double)algorithm.performEqualization(sample, 1, 1), (double)1.0E-6);
    }

    @Test
    public void testGetJulianDate() throws ParseException, IOException {
        ProductData.UTC utc = ProductData.UTC.parse((String)"12-10-2006", (String)"dd-MM-yyyy");
        EqualizationAlgorithm algorithm = new EqualizationAlgorithm(utc, new EqualizationLUT(new Reader[0]));
        long expectedJD = EqualizationAlgorithm.toJulianDay((int)2006, (int)9, (int)12) - EqualizationAlgorithm.toJulianDay((int)2002, (int)4, (int)1);
        Assert.assertEquals((long)expectedJD, (long)algorithm.getJulianDate());
    }

    @Test
    public void testToJulianDay() {
        Assert.assertEquals((long)2455414L, (long)EqualizationAlgorithm.toJulianDay((int)2010, (int)7, (int)6));
        Assert.assertEquals((long)2452365L, (long)EqualizationAlgorithm.toJulianDay((int)2002, (int)3, (int)1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionSpectralIndexToSmall() throws Exception {
        EqualizationAlgorithm algorithm = new EqualizationAlgorithm(new ProductData.UTC(), new EqualizationLUT(new Reader[0]));
        algorithm.performEqualization(0.0, -1, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionSpectralIndexToBig() throws Exception {
        EqualizationAlgorithm algorithm = new EqualizationAlgorithm(new ProductData.UTC(), new EqualizationLUT(new Reader[0]));
        algorithm.performEqualization(0.0, 15, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExceptionDetectorIndexToSmall() throws Exception {
        EqualizationAlgorithm algorithm = new EqualizationAlgorithm(new ProductData.UTC(), new EqualizationLUT(new Reader[0]));
        algorithm.performEqualization(0.0, 15, -1);
    }
}

