/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.calibration;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.esa.s3tbx.meris.radiometry.calibration.CalibrationAlgorithm;
import org.esa.s3tbx.meris.radiometry.calibration.Resolution;
import org.junit.Assert;
import org.junit.Test;

public class CalibrationAlgorithmTest {
    @Test
    public void calibration() throws IOException, URISyntaxException {
        String oldRacResource = "MER_RAC_AXVIEC20050708_135553_20021224_121445_20041213_220000";
        String newRacResource = "MER_RAC_AXVACR20091016_154511_20021224_121445_20041213_220000";
        InputStream oldRacStream = this.getClass().getResourceAsStream("MER_RAC_AXVIEC20050708_135553_20021224_121445_20041213_220000");
        InputStream newRacStream = this.getClass().getResourceAsStream("MER_RAC_AXVACR20091016_154511_20021224_121445_20041213_220000");
        CalibrationAlgorithm calibrationAlgorithm = new CalibrationAlgorithm(Resolution.RR, 1247.4, oldRacStream, newRacStream);
        double sourceRadiance = 119.61037;
        double targetRadiance = 120.02557;
        Assert.assertEquals((double)120.02557, (double)calibrationAlgorithm.calibrate(0, 759, 119.61037), (double)1.0E-4);
    }
}

