/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry;

import java.awt.Color;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.jexp.ParseException;

class TestHelper {
    public static final int SCENE_WIDTH = 10;
    public static final int SCENE_HEIGHT = 10;

    TestHelper() {
    }

    public static Product createL1bProduct(String resolutionString) throws ParseException, java.text.ParseException {
        boolean isFSG = resolutionString.equals("FSG");
        String productType = String.format("MER_%s_1P", resolutionString);
        Product product = new Product("MERIS-TEST-PRODUCT", productType, 10, 10);
        float[] MERIS_WAVELENGTHS = new float[]{412.0f, 442.0f, 490.0f, 510.0f, 560.0f, 620.0f, 665.0f, 681.0f, 705.0f, 753.0f, 760.0f, 775.0f, 865.0f, 890.0f, 900.0f};
        for (int i = 0; i < 15; ++i) {
            Band band = product.addBand(String.format("radiance_%d", i + 1), "X");
            band.setSpectralBandIndex(i);
            band.setSpectralWavelength(MERIS_WAVELENGTHS[i]);
            band.setData(band.createCompatibleRasterData());
        }
        TestHelper.addBandToProduct(product, "l1_flags", 10);
        TestHelper.addBandToProduct(product, "detector_index", 21);
        if (isFSG) {
            product.addBand("corr_longitude", "X/10", 31);
            product.addBand("corr_latitude", "60 - Y/10", 31);
            product.addBand("altitude", "10", 11);
        }
        float[] tiePointData = new float[100];
        product.addTiePointGrid(new TiePointGrid("sun_zenith", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("sun_azimuth", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("view_zenith", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("view_azimuth", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("dem_alt", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("atm_press", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("ozone", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("latitude", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("longitude", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("dem_rough", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("lat_corr", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("lon_corr", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("zonal_wind", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("merid_wind", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        product.addTiePointGrid(new TiePointGrid("rel_hum", 10, 10, 0.0, 0.0, 1.0, 1.0, tiePointData));
        FlagCoding l1_flags = new FlagCoding("l1_flags");
        l1_flags.addFlag("COSMETIC", 1, "No Description.");
        l1_flags.addFlag("DUPLICATED", 2, "No Description.");
        l1_flags.addFlag("GLINT_RISK", 4, "No Description.");
        l1_flags.addFlag("SUSPECT", 8, "No Description.");
        l1_flags.addFlag("LAND_OCEAN", 16, "No Description.");
        l1_flags.addFlag("BRIGHT", 32, "No Description.");
        l1_flags.addFlag("COASTLINE", 64, "No Description.");
        l1_flags.addFlag("INVALID", 128, "No Description.");
        product.getBand("l1_flags").setSampleCoding((SampleCoding)l1_flags);
        product.getFlagCodingGroup().add((ProductNode)l1_flags);
        ProductNodeGroup maskGroup = product.getMaskGroup();
        maskGroup.add((ProductNode)TestHelper.mask("coastline", "l1_flags.COASTLINE"));
        maskGroup.add((ProductNode)TestHelper.mask("land_ocean", "l1_flags.LAND_OCEAN"));
        maskGroup.add((ProductNode)TestHelper.mask("water", "NOT l1_flags.LAND_OCEAN"));
        maskGroup.add((ProductNode)TestHelper.mask("cosmetic", "l1_flags.COSMETIC"));
        maskGroup.add((ProductNode)TestHelper.mask("duplicated", "l1_flags.DUPLICATED"));
        maskGroup.add((ProductNode)TestHelper.mask("glint_risk", "l1_flags.GLINT_RISK"));
        maskGroup.add((ProductNode)TestHelper.mask("suspect", "l1_flags.SUSPECT"));
        maskGroup.add((ProductNode)TestHelper.mask("bright", "l1_flags.BRIGHT"));
        maskGroup.add((ProductNode)TestHelper.mask("invalid", "l1_flags.INVALID"));
        product.setStartTime(ProductData.UTC.parse((String)"12-Mar-2003 13:45:36"));
        product.setEndTime(ProductData.UTC.parse((String)"12-Mar-2003 13:48:12"));
        MetadataElement sph = new MetadataElement("SPH");
        ProductData sphData = ProductData.createInstance((String)String.format("MER_%s_1P SPECIFIC HEADER", resolutionString));
        MetadataAttribute sphDescriptor = new MetadataAttribute("SPH_DESCRIPTOR", sphData, true);
        sph.addAttribute(sphDescriptor);
        product.getMetadataRoot().addElement(sph);
        MetadataElement mph = new MetadataElement("MPH");
        ProductData mphData = ProductData.createInstance((String)(product.getName() + ".N1"));
        MetadataAttribute mphDescriptor = new MetadataAttribute("PRODUCT", mphData, true);
        mph.addAttribute(mphDescriptor);
        product.getMetadataRoot().addElement(mph);
        MetadataElement dsd23 = new MetadataElement("DSD.23");
        dsd23.addAttribute(new MetadataAttribute("DATASET_NAME", (ProductData)new ProductData.ASCII("RADIOMETRIC_CALIBRATION_FILE"), true));
        dsd23.addAttribute(new MetadataAttribute("FILE_NAME", (ProductData)new ProductData.ASCII("MER_RAC_AXVIEC20050708_135806_20041213_220000_20141213_220000"), true));
        MetadataElement dsd = new MetadataElement("DSD");
        dsd.addElement(dsd23);
        product.getMetadataRoot().addElement(dsd);
        if (isFSG) {
            product.setSceneGeoCoding((GeoCoding)GeoCodingFactory.createPixelGeoCoding((Band)product.getBand("corr_latitude"), (Band)product.getBand("corr_longitude"), null, (int)3));
        } else {
            product.setSceneGeoCoding((GeoCoding)new TiePointGeoCoding(product.getTiePointGrid("latitude"), product.getTiePointGrid("longitude")));
        }
        return product;
    }

    private static Mask mask(String name, String expression) {
        return Mask.BandMathsType.create((String)name, null, (int)10, (int)10, (String)expression, (Color)Color.green, (double)0.5);
    }

    private static Band addBandToProduct(Product product, String name, int dataType) {
        Band band = product.addBand(name, dataType);
        band.setData(band.createCompatibleRasterData());
        return band;
    }
}

