/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry;

import org.esa.s3tbx.meris.radiometry.MerisRadiometryCorrectionOp;
import org.esa.s3tbx.meris.radiometry.TestHelper;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.junit.Test;

public class MerisRadiometryCorrectionOpTest {
    @Test
    public void testWithFSGBandsAtBeginning() throws Exception {
        Product fsg = TestHelper.createL1bProduct("FSG");
        this.moveFSGBandsAtTheBeginning(fsg);
        MerisRadiometryCorrectionOp correctionOp = new MerisRadiometryCorrectionOp();
        correctionOp.setParameterDefaultValues();
        correctionOp.setSourceProduct(fsg);
        Product targetProduct = correctionOp.getTargetProduct();
        targetProduct.getBandAt(0).getGeophysicalImage().getData();
    }

    void moveFSGBandsAtTheBeginning(Product fsg) {
        Band corrLon = (Band)fsg.getBandGroup().get("corr_longitude");
        fsg.getBandGroup().remove((ProductNode)corrLon);
        Band corrLat = (Band)fsg.getBandGroup().get("corr_latitude");
        fsg.getBandGroup().remove((ProductNode)corrLat);
        fsg.getBandGroup().add(0, (ProductNode)corrLat);
        fsg.getBandGroup().add(0, (ProductNode)corrLon);
    }
}

