/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.operator.cloud.internal;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;

public abstract class ProcessingNode
implements ProductReader {
    private Product sourceProduct;
    private Product targetProduct;
    private Rectangle frameRectangle = null;
    private Map<String, ProductData> frameDataMap = new HashMap<String, ProductData>(31);

    protected ProcessingNode() {
    }

    protected Product getSourceProduct() {
        return this.sourceProduct;
    }

    public Product createTargetProduct() {
        this.targetProduct = this.createTargetProductImpl();
        this.targetProduct.setProductReader((ProductReader)this);
        return this.targetProduct;
    }

    public ProductData getFrameData(String targetBandName) {
        Band targetBand = this.getTargetBand(targetBandName);
        ProductData frameData = targetBand != null ? this.getFrameData(targetBand) : null;
        return frameData;
    }

    public Band getTargetBand(String targetBandName) {
        return this.targetProduct.getBand(targetBandName);
    }

    public ProductData getFrameData(Band targetBand) {
        if (this.frameRectangle == null) {
            return null;
        }
        ProductData frameData = this.frameDataMap.get(targetBand.getName());
        int numElems = this.frameRectangle.width * this.frameRectangle.height;
        if (frameData == null || frameData.getNumElems() != numElems) {
            frameData = targetBand.createCompatibleProductData(numElems);
            this.frameDataMap.put(targetBand.getName(), frameData);
        }
        return frameData;
    }

    public void startProcessing() throws Exception {
    }

    protected abstract Product createTargetProductImpl();

    protected abstract void processFrame(int var1, int var2, int var3, int var4, ProgressMonitor var5) throws IOException;

    protected void clearFrameDataMap() {
        this.frameDataMap.clear();
    }

    public void setUp(Map config) throws IOException {
    }

    private void setFrameRectangle(int frameX, int frameY, int frameW, int frameH) {
        this.frameRectangle = new Rectangle(frameX, frameY, frameW, frameH);
    }

    private synchronized void readFrameData(Band targetBand, int frameX, int frameY, int frameW, int frameH, ProductData targetData) throws IOException {
        if (this.isNewFrame(frameX, frameY, frameW, frameH)) {
            this.setFrameRectangle(frameX, frameY, frameW, frameH);
            this.processFrame(frameX, frameY, frameW, frameH, ProgressMonitor.NULL);
        }
        ProductData frameData = this.getFrameData(targetBand);
        this.copyFrameData(frameData, targetData, frameX, frameY, frameW, frameH);
    }

    private boolean isNewFrame(int frameX, int frameY, int frameW, int frameH) {
        return this.frameRectangle == null || !this.frameRectangle.contains(frameX, frameY, frameW, frameH);
    }

    private void copyFrameData(ProductData sourceData, ProductData targetData, int targetX, int targetY, int targetW, int targetH) throws IOException {
        Object sourceElems = sourceData.getElems();
        Object targetElems = targetData.getElems();
        int targetNumElems = targetData.getNumElems();
        if (sourceElems.getClass().equals(targetElems.getClass())) {
            if (this.frameRectangle.x == targetX && this.frameRectangle.y == targetY && this.frameRectangle.width == targetW && this.frameRectangle.height == targetH) {
                System.arraycopy(sourceElems, 0, targetElems, 0, targetNumElems);
            } else {
                int offsetY = targetY - this.frameRectangle.y;
                int sourceIndex = this.frameRectangle.width * offsetY + targetX;
                int targetIndex = 0;
                for (int y = offsetY; y < offsetY + targetH; ++y) {
                    System.arraycopy(sourceElems, sourceIndex, targetElems, targetIndex, targetW);
                    sourceIndex += this.frameRectangle.width;
                    targetIndex += targetW;
                }
            }
        } else {
            throw new IOException("unsupported type conversion");
        }
    }

    public Product readProductNodes(Object input, ProductSubsetDef subsetDef) throws IOException {
        if (subsetDef != null) {
            throw new IllegalArgumentException("subsetDef != null (subsets are not supported)");
        }
        if (!(input instanceof Product)) {
            throw new IllegalArgumentException("illegal input type");
        }
        this.sourceProduct = (Product)input;
        return this.createTargetProduct();
    }

    public void readBandRasterData(Band targetBand, int frameX, int frameY, int frameW, int frameH, ProductData targetData, ProgressMonitor pm) throws IOException {
        this.readFrameData(targetBand, frameX, frameY, frameW, frameH, targetData);
    }

    public void close() throws IOException {
        this.clearFrameDataMap();
    }

    public ProductReaderPlugIn getReaderPlugIn() {
        throw new IllegalStateException("Should never be asked for reader plugin");
    }

    public Object getInput() {
        throw new IllegalStateException("Should never be asked for input");
    }

    public final ProductSubsetDef getSubsetDef() {
        throw new IllegalStateException("Should never be asked for subset definition");
    }
}

