/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.operator.cloud;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.esa.s3tbx.operator.cloud.CloudPN;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.envisat.EnvisatConstants;

@OperatorMetadata(alias="CloudProb", category="Optical/Pre-Processing", version="1.7", authors="Rene Preusker (Algorithm), Tom Block (BEAM Implementation), Thomas Storm (GPF conversion)", copyright="Copyright (C) 2004-2014 by ESA, FUB and Brockmann Consult", description="Applies a clear sky conservative cloud detection algorithm.")
public class CloudOperator
extends Operator {
    @SourceProduct(alias="source", label="Source product", description="The MERIS Level 1b source product.")
    private Product l1bProduct;
    @TargetProduct(label="Cloud product")
    private Product targetProduct;
    private CloudPN cloudNode;
    private Product tempCloudProduct;

    public void initialize() {
        this.setLogger(Logger.getLogger("beam.processor.cloud"));
        this.getLogger().info("Starting request...");
        this.initCloudNode();
        try {
            this.initOutputProduct();
        }
        catch (IOException | ParseException e) {
            throw new OperatorException("Unable to initialise output product.", e);
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        for (Map.Entry<Band, Tile> entry : targetTiles.entrySet()) {
            this.checkForCancellation();
            Band targetBand = entry.getKey();
            Tile targetTile = entry.getValue();
            Band sourceBand = this.tempCloudProduct.getBand(targetBand.getName());
            Rectangle targetRect = targetTile.getRectangle();
            ProductData rawSamples = this.getSourceTile((RasterDataNode)sourceBand, targetRect).getRawSamples();
            targetTile.setRawSamples(rawSamples);
        }
    }

    private void initCloudNode() {
        try {
            this.installAuxdata();
        }
        catch (IOException e) {
            throw new OperatorException("Unable to install auxiliary data.", (Throwable)e);
        }
        HashMap<String, String> cloudConfig = new HashMap<String, String>();
        cloudConfig.put("config_file_name", "cloud_config.txt");
        cloudConfig.put("invalid_expression", "l1_flags.INVALID");
        this.cloudNode = new CloudPN(this.getAuxdataInstallationPath().toString());
        try {
            this.cloudNode.setUp(cloudConfig);
        }
        catch (IOException e) {
            throw new OperatorException("Failed to initialise cloud source: " + e.getMessage(), (Throwable)e);
        }
    }

    void installAuxdata() throws IOException {
        Path auxdataDirPath = this.getAuxdataInstallationPath();
        Path sourcePath = ResourceInstaller.findModuleCodeBasePath(((Object)((Object)this)).getClass()).resolve("auxdata");
        new ResourceInstaller(sourcePath, auxdataDirPath).install(".*", ProgressMonitor.NULL);
    }

    Path getAuxdataInstallationPath() {
        return SystemUtils.getAuxDataPath().resolve("meris/cloud-op").toAbsolutePath();
    }

    private void initOutputProduct() throws IOException, ParseException {
        if (!EnvisatConstants.MERIS_L1_TYPE_PATTERN.matcher(this.l1bProduct.getProductType()).matches()) {
            throw new OperatorException("Product type '" + this.l1bProduct.getProductType() + "' is not supported." + "It must be a MERIS Level 1b product.");
        }
        this.tempCloudProduct = this.cloudNode.readProductNodes(this.l1bProduct, null);
        this.targetProduct = this.cloudNode.createTargetProductImpl();
        ProductUtils.copyFlagBands((Product)this.l1bProduct, (Product)this.targetProduct, (boolean)true);
        ProductUtils.copyTiePointGrids((Product)this.l1bProduct, (Product)this.targetProduct);
        ProductUtils.copyGeoCoding((Product)this.l1bProduct, (Product)this.targetProduct);
        ProductUtils.copyMetadata((Product)this.l1bProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.l1bProduct.getStartTime());
        this.targetProduct.setEndTime(this.l1bProduct.getEndTime());
        this.cloudNode.startProcessing();
        this.getLogger().info("Output product successfully initialised");
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CloudOperator.class);
        }
    }
}

