/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.operator.cloud;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class CentralWavelengthProvider {
    private static final String CENTRAL_WAVELENGTH_FILE_NAME = "central_wvl_rr.txt";
    private static final int DETECTOR_LENGTH_RR = 925;
    private static final int DETECTOR_LENGTH_FR = 3700;
    private float[] centralWavelenthRr = new float[925];

    public void readAuxData(File auxDataDir) throws IOException {
        File cwvlFile = new File(auxDataDir, CENTRAL_WAVELENGTH_FILE_NAME);
        FileInputStream inputStream = new FileInputStream(cwvlFile);
        this.readCW(inputStream);
        ((InputStream)inputStream).close();
    }

    public void readCW(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        for (int i = 0; i < this.centralWavelenthRr.length; ++i) {
            String line = bufferedReader.readLine();
            line = line.trim();
            this.centralWavelenthRr[i] = Float.parseFloat(line);
        }
    }

    public float[] getCentralWavelength(String productType) {
        if (productType.startsWith("MER_RR")) {
            return this.centralWavelenthRr;
        }
        if (productType.startsWith("MER_F")) {
            return this.generateCentralWavelengthFr();
        }
        throw new IllegalArgumentException("'The product has an unsupported product type: " + productType);
    }

    private float[] generateCentralWavelengthFr() {
        float[] cwFr = new float[3700];
        for (int camera = 0; camera < 5; ++camera) {
            int frCameraOffset = camera * 740;
            int rrCameraOffset = camera * 185;
            for (int frIdx = 0; frIdx < 740; ++frIdx) {
                float vector = (float)frIdx / 4.0f + 0.125f;
                float rrVector = 0.5f + vector;
                int rrIndex = (int)rrVector;
                float weight = rrVector % 1.0f;
                if (rrIndex == 0) {
                    ++rrIndex;
                    weight -= 1.0f;
                }
                if (rrIndex >= 185) {
                    rrIndex = 184;
                    weight += 1.0f;
                }
                float x1 = this.centralWavelenthRr[rrCameraOffset + rrIndex - 1];
                float x2 = this.centralWavelenthRr[rrCameraOffset + rrIndex];
                cwFr[frIdx + frCameraOffset] = x1 + (x2 - x1) * weight;
            }
        }
        return cwFr;
    }
}

