/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.metadata;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Logger;
import org.esa.snap.core.util.SystemUtils;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ResourceResolver
implements LSResourceResolver {
    private final Logger logger = SystemUtils.LOG;
    private final String schemaBasePath;
    private final ClassLoader classLoader;
    private Map<String, String> pathMap = new HashMap<String, String>();

    public ResourceResolver(String schemaBasePath, ClassLoader classLoader) {
        this.schemaBasePath = schemaBasePath;
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        String baseResourceName = null;
        String baseResourcePath = null;
        String currentResourceName = systemId.substring(systemId.lastIndexOf("/") + 1);
        if (this.pathMap.containsKey(currentResourceName)) return null;
        if (baseURI != null) {
            baseResourceName = baseURI.substring(baseURI.lastIndexOf("/") + 1);
        }
        if (systemId.startsWith("./")) {
            systemId = systemId.substring(2, systemId.length());
        }
        baseResourcePath = this.pathMap.containsKey(baseResourceName) ? this.pathMap.get(baseResourceName) : this.schemaBasePath;
        String normalizedPath = this.getNormalizedPath(baseResourcePath, systemId);
        try (InputStream resourceAsStream = this.classLoader.getResourceAsStream(normalizedPath);){
            if (systemId.contains("/")) {
                this.pathMap.put(currentResourceName, normalizedPath.substring(0, normalizedPath.lastIndexOf("/") + 1));
            } else {
                this.pathMap.put(systemId, baseResourcePath);
            }
            Scanner s = new Scanner(resourceAsStream).useDelimiter("\\A");
            String s1 = s.next().replaceAll("\\n", " ").replace("\\t", " ").replaceAll("\\s+", " ").replaceAll("[^\\x20-\\x7e]", "");
            ByteArrayInputStream is = new ByteArrayInputStream(s1.getBytes());
            Input input = new Input(publicId, systemId, is);
            return input;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getNormalizedPath(String basePath, String relativePath) {
        if (!relativePath.startsWith("../")) {
            return basePath + relativePath;
        }
        while (relativePath.startsWith("../")) {
            basePath = basePath.substring(0, basePath.substring(0, basePath.length() - 1).lastIndexOf("/") + 1);
            relativePath = relativePath.substring(3);
        }
        return basePath + relativePath;
    }

    private class Input
    implements LSInput {
        private String publicId;
        private String systemId;
        private BufferedInputStream inputStream;

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getStringData() {
            BufferedInputStream bufferedInputStream = this.inputStream;
            synchronized (bufferedInputStream) {
                try {
                    byte[] input = new byte[this.inputStream.available()];
                    this.inputStream.read(input);
                    String contents = new String(input);
                    return contents;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ResourceResolver.this.logger.severe("Exception " + e);
                    return null;
                }
            }
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        public BufferedInputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(BufferedInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public Input(String publicId, String sysId, InputStream input) {
            this.publicId = publicId;
            this.systemId = sysId;
            this.inputStream = new BufferedInputStream(input);
        }
    }
}

