/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff.level2;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.esa.s3tbx.dataio.landsat.metadata.XmlMetadata;
import org.esa.s3tbx.dataio.landsat.metadata.XmlMetadataParser;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.geotools.graph.util.geom.Coordinate2D;

public class LandsatLevel2Metadata
extends XmlMetadata {
    private static final float[] ETM_PLUS_WAVELENGTHS = new float[]{485.0f, 560.0f, 660.0f, 835.0f, 1650.0f, 11450.0f, 2220.0f, 710.0f};
    private static final float[] ETM_PLUS_BANDWIDTHS = new float[]{70.0f, 80.0f, 60.0f, 130.0f, 200.0f, 2100.0f, 260.0f, 380.0f};
    private static final float[] TM_WAVELENGTHS = new float[]{490.0f, 560.0f, 660.0f, 830.0f, 1670.0f, 11500.0f, 2240.0f, 710.0f};
    private static final float[] TM_BANDWIDTHS = new float[]{66.0f, 82.0f, 67.0f, 128.0f, 217.0f, 1000.0f, 252.0f, 380.0f};
    private static final float[] L8_WAVELENGTHS = new float[]{440.0f, 480.0f, 560.0f, 655.0f, 865.0f, 1610.0f, 2200.0f, 590.0f, 1370.0f, 10895.0f, 12005.0f};
    private static final float[] L8_BANDWIDTHS = new float[]{20.0f, 60.0f, 60.0f, 30.0f, 30.0f, 80.0f, 180.0f, 180.0f, 20.0f, 590.0f, 1010.0f};

    public LandsatLevel2Metadata(String name) {
        super(name);
    }

    @Override
    public String getFileName() {
        return this.name;
    }

    @Override
    public String getProductName() {
        String name = this.getAttributeValue("/espa_metadata/global_metadata/product_id", "NO_NAME") + " - Level 2";
        this.rootElement.setDescription(name);
        return name;
    }

    @Override
    public String getProductDescription() {
        return this.getProductName();
    }

    @Override
    public String getFormatName() {
        return null;
    }

    @Override
    public String getMetadataProfile() {
        return null;
    }

    @Override
    public int getRasterWidth() {
        MetadataElement[] bandElements;
        int width = 0;
        for (MetadataElement bandElement : bandElements = this.getRootElement().getElement("bands").getElements()) {
            int auxWidth = Integer.parseInt(bandElement.getAttribute("nsamps").getData().toString());
            if (auxWidth <= width) continue;
            width = auxWidth;
        }
        return width;
    }

    @Override
    public int getRasterHeight() {
        MetadataElement[] bandElements;
        int height = 0;
        for (MetadataElement bandElement : bandElements = this.getRootElement().getElement("bands").getElements()) {
            int auxHeight = Integer.parseInt(bandElement.getAttribute("nlines").getData().toString());
            if (auxHeight <= height) continue;
            height = auxHeight;
        }
        return height;
    }

    @Override
    public String[] getRasterFileNames() {
        MetadataElement[] bandElements;
        ArrayList<String> fileNamesArray = new ArrayList<String>();
        for (MetadataElement bandElement : bandElements = this.getRootElement().getElement("bands").getElements()) {
            String name = bandElement.getAttribute("file_name").getData().toString();
            fileNamesArray.add(name);
        }
        return fileNamesArray.toArray(new String[fileNamesArray.size()]);
    }

    @Override
    public ProductData.UTC getProductStartTime() {
        return this.getCenterTime();
    }

    @Override
    public ProductData.UTC getProductEndTime() {
        return this.getCenterTime();
    }

    @Override
    public ProductData.UTC getCenterTime() {
        String timeString = this.getRootElement().getElement("global_metadata").getAttribute("scene_center_time").getData().toString();
        String dateString = this.getRootElement().getElement("global_metadata").getAttribute("acquisition_date").getData().toString();
        try {
            if (dateString != null && timeString != null) {
                timeString = timeString.substring(0, 12);
                DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss.SSS");
                Date date = dateFormat.parse(dateString + " " + timeString);
                String milliSeconds = timeString.substring(timeString.length() - 3);
                return ProductData.UTC.create((Date)date, (long)(Long.parseLong(milliSeconds) * 1000L));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int getNumBands() {
        MetadataElement[] bandElements = this.getRootElement().getElement("bands").getElements();
        return bandElements.length;
    }

    public Coordinate2D getUpperLeft() {
        MetadataElement[] metadataElements;
        for (MetadataElement corner_point : metadataElements = this.getRootElement().getElement("global_metadata").getElement("projection_information").getElements()) {
            if (!corner_point.getName().equals("corner_point") || !corner_point.getAttribute("location").getData().toString().equals("UL")) continue;
            double x = Double.parseDouble(corner_point.getAttribute("x").getData().toString());
            double y = Double.parseDouble(corner_point.getAttribute("y").getData().toString());
            return new Coordinate2D(x, y);
        }
        return null;
    }

    public String getBandName(String filename) {
        MetadataElement[] bandElements;
        for (MetadataElement bandElement : bandElements = this.getRootElement().getElement("bands").getElements()) {
            String name = bandElement.getAttribute("file_name").getData().toString();
            if (!filename.equals(name)) continue;
            return bandElement.getAttribute("name").getData().toString();
        }
        return null;
    }

    public double getScalingFactor(String filename) {
        MetadataElement[] bandElements;
        for (MetadataElement bandElement : bandElements = this.getRootElement().getElement("bands").getElements()) {
            MetadataAttribute attribute;
            String name = bandElement.getAttribute("file_name").getData().toString();
            if (!filename.equals(name) || (attribute = bandElement.getAttribute("scale_factor")) == null) continue;
            return Double.parseDouble(bandElement.getAttribute("scale_factor").getData().toString());
        }
        return 1.0;
    }

    public double getScalingOffset(String filename) {
        return 0.0;
    }

    public float getWavelength(String filename) {
        String instrument = this.getInstrument();
        int index1 = filename.indexOf("sr_band");
        int index2 = filename.indexOf(".tif");
        if (index1 < 0 || index2 < index1) {
            return 0.0f;
        }
        Integer.parseInt(filename.substring(index1 + "sr_band".length(), index2));
        int band = Integer.parseInt(filename.substring(index1 + "sr_band".length(), index2)) - 1;
        if (instrument.startsWith("OLI")) {
            return L8_WAVELENGTHS[band];
        }
        if (instrument.startsWith("TM")) {
            return TM_WAVELENGTHS[band];
        }
        if (instrument.startsWith("ETM")) {
            return ETM_PLUS_WAVELENGTHS[band];
        }
        return 0.0f;
    }

    public float getBandwidth(String filename) {
        String instrument = this.getInstrument();
        int index1 = filename.indexOf("sr_band");
        int index2 = filename.indexOf(".tif");
        if (index1 < 0 || index2 < index1) {
            return 0.0f;
        }
        Integer.parseInt(filename.substring(index1 + "sr_band".length(), index2));
        int band = Integer.parseInt(filename.substring(index1 + "sr_band".length(), index2)) - 1;
        if (instrument.startsWith("OLI")) {
            return L8_BANDWIDTHS[band];
        }
        if (instrument.startsWith("TM")) {
            return TM_BANDWIDTHS[band];
        }
        if (instrument.startsWith("ETM")) {
            return ETM_PLUS_BANDWIDTHS[band];
        }
        return 0.0f;
    }

    public String getBandDescription(String filename) {
        MetadataElement[] bandElements;
        for (MetadataElement bandElement : bandElements = this.getRootElement().getElement("bands").getElements()) {
            String name = bandElement.getAttribute("file_name").getData().toString();
            if (!filename.equals(name)) continue;
            return bandElement.getAttribute("long_name").getData().toString();
        }
        return null;
    }

    public boolean isReflectanceBand(String filename) {
        MetadataElement[] bandElements;
        for (MetadataElement bandElement : bandElements = this.getRootElement().getElement("bands").getElements()) {
            String name = bandElement.getAttribute("file_name").getData().toString();
            if (!filename.equals(name)) continue;
            return bandElement.getAttribute("product").getData().toString().equals("sr_refl") && bandElement.getAttribute("name").getData().toString().startsWith("sr_band") && bandElement.getAttribute("category").getData().toString().equals("image");
        }
        return false;
    }

    public boolean isSaturationBand(String filename) {
        MetadataElement[] bandElements;
        for (MetadataElement bandElement : bandElements = this.getRootElement().getElement("bands").getElements()) {
            String name = bandElement.getAttribute("file_name").getData().toString();
            if (!filename.equals(name)) continue;
            return bandElement.getAttribute("product").getData().toString().equals("toa_refl") && bandElement.getAttribute("name").getData().toString().equals("radsat_qa") && bandElement.getAttribute("category").getData().toString().equals("qa");
        }
        return false;
    }

    public boolean isAerosolBand(String filename) {
        MetadataElement[] bandElements;
        for (MetadataElement bandElement : bandElements = this.getRootElement().getElement("bands").getElements()) {
            String name = bandElement.getAttribute("file_name").getData().toString();
            if (!filename.equals(name)) continue;
            return bandElement.getAttribute("product").getData().toString().equals("sr_refl") && bandElement.getAttribute("name").getData().toString().equals("sr_aerosol") && bandElement.getAttribute("category").getData().toString().equals("qa");
        }
        return false;
    }

    public boolean isQualityBand(String filename) {
        MetadataElement[] bandElements;
        for (MetadataElement bandElement : bandElements = this.getRootElement().getElement("bands").getElements()) {
            String name = bandElement.getAttribute("file_name").getData().toString();
            if (!filename.equals(name)) continue;
            return bandElement.getAttribute("product").getData().toString().equals("level2_qa") && bandElement.getAttribute("name").getData().toString().equals("pixel_qa") && bandElement.getAttribute("category").getData().toString().equals("qa");
        }
        return false;
    }

    public boolean isAtmosBand(String filename) {
        MetadataElement[] bandElements;
        for (MetadataElement bandElement : bandElements = this.getRootElement().getElement("bands").getElements()) {
            String name = bandElement.getAttribute("file_name").getData().toString();
            if (!filename.equals(name)) continue;
            return bandElement.getAttribute("product").getData().toString().equals("sr_refl") && bandElement.getAttribute("name").getData().toString().equals("sr_atmos_opacity") && bandElement.getAttribute("category").getData().toString().equals("image");
        }
        return false;
    }

    public boolean isCloudBand(String filename) {
        MetadataElement[] bandElements;
        for (MetadataElement bandElement : bandElements = this.getRootElement().getElement("bands").getElements()) {
            String name = bandElement.getAttribute("file_name").getData().toString();
            if (!filename.equals(name)) continue;
            return bandElement.getAttribute("product").getData().toString().equals("sr_refl") && bandElement.getAttribute("name").getData().toString().equals("sr_cloud_qa") && bandElement.getAttribute("category").getData().toString().equals("qa");
        }
        return false;
    }

    public String getSatellite() {
        String name = this.getAttributeValue("/espa_metadata/global_metadata/satellite", "LANDSAT_8");
        return name;
    }

    public String getInstrument() {
        String name = this.getAttributeValue("/espa_metadata/global_metadata/instrument", "OLI_TIRS");
        return name;
    }

    public FlagCoding createSaturationFlagCoding(String bandName) {
        FlagCoding flagCoding = new FlagCoding("saturation");
        flagCoding.addFlag("data_fill_flag", 1, "Designated Fill");
        flagCoding.addFlag("Band1_saturated", 2, "Band 1 Data Saturation Flag");
        flagCoding.addFlag("Band2_saturated", 4, "Band 2 Data Saturation Flag");
        flagCoding.addFlag("Band3_saturated", 8, "Band 3 Data Saturation Fla ");
        flagCoding.addFlag("Band4_saturated", 16, "Band 4 Data Saturation Flag");
        flagCoding.addFlag("Band5_saturated", 32, "Band 5 Data Saturation Flag");
        flagCoding.addFlag("Band6_saturated", 64, "Band 6 Data Saturation Flag");
        flagCoding.addFlag("Band7_saturated", 128, "Band 7 Data Saturation Flag");
        if (this.getSatellite().equals("LANDSAT_8")) {
            flagCoding.addFlag("Band8_saturated", 256, "N/A");
            flagCoding.addFlag("Band9_saturated", 512, "Band 9 Data Saturation Flag");
            flagCoding.addFlag("Band10_saturated", 1024, "Band 10 Data Saturation Flag");
            flagCoding.addFlag("Band11_saturated", 2048, "Band 11 Data Saturation Flag");
        }
        return flagCoding;
    }

    public static class LandsatLevel2MetadataParser
    extends XmlMetadataParser<LandsatLevel2Metadata> {
        public LandsatLevel2MetadataParser(Class metadataFileClass) {
            super(metadataFileClass);
        }

        @Override
        protected boolean shouldValidateSchema() {
            return false;
        }
    }
}

