/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff.level2;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatColorIterator;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2Cloud;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;

public class LandsatLEDAPSCloud
implements LandsatL2Cloud {
    protected final LandsatColorIterator colorIterator = new LandsatColorIterator();

    @Override
    public FlagCoding createFlagCoding() {
        FlagCoding flagCoding = new FlagCoding("cloud_qa");
        flagCoding.addFlag("ddv", 1, "Dense dark vegetation");
        flagCoding.addFlag("cloud", 2, "Cloud");
        flagCoding.addFlag("cloud_shadow", 4, "Cloud Shadow");
        flagCoding.addFlag("adjacent_cloud", 8, "Adjacent to cloud");
        flagCoding.addFlag("snow", 16, "Snow");
        flagCoding.addFlag("land_water", 32, "Land/water");
        return flagCoding;
    }

    @Override
    public List<Mask> createMasks(int width, int height) {
        ArrayList<Mask> masks = new ArrayList<Mask>();
        masks.add(Mask.BandMathsType.create((String)"cloud_qa_DDV", (String)"Dense dark vegetation", (int)width, (int)height, (String)"cloud_qa.ddv", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"cloud_qa_Cloud", (String)"Cloud", (int)width, (int)height, (String)"cloud_qa.cloud", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"cloud_qa_cloud_shadow", (String)"Cloud shadow", (int)width, (int)height, (String)"cloud_qa.cloud_shadow", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"cloud_qa_adjacent_cloud", (String)"Adjacent to cloud", (int)width, (int)height, (String)"cloud_qa.adjacent_cloud", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"cloud_qa_snow", (String)"Snow", (int)width, (int)height, (String)"cloud_qa.snow", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"cloud_qa_land_water", (String)"Land/water", (int)width, (int)height, (String)"cloud_qa.land_water", (Color)this.colorIterator.next(), (double)0.5));
        return masks;
    }
}

