/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff.level2;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.VirtualDir;
import com.bc.ceres.glevel.MultiLevelImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatTypeInfo;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2Aerosol;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2AerosolFactory;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2Cloud;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2CloudFactory;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2GeotiffReaderPlugin;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2QA;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2QAFactory;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2Saturation;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2SaturationFactory;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatLevel2Metadata;
import org.esa.s3tbx.dataio.landsat.metadata.XmlMetadataParser;
import org.esa.s3tbx.dataio.landsat.metadata.XmlMetadataParserFactory;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;

public class LandsatL2GeotiffReader
extends AbstractProductReader {
    private VirtualDir virtualDir;
    protected final Logger logger = SystemUtils.LOG;
    private String basePath;
    protected LandsatLevel2Metadata metadata = null;
    protected LandsatL2Saturation l2saturation = null;
    protected LandsatL2QA l2qa = null;
    protected LandsatL2Aerosol l2aerosol = null;
    protected LandsatL2Cloud l2cloud = null;
    private List<Product> bandProducts = new ArrayList<Product>();

    public LandsatL2GeotiffReader(ProductReaderPlugIn readerPlugin) {
        super(readerPlugin);
    }

    protected Product readProductNodesImpl() throws IOException {
        try {
            this.virtualDir = LandsatL2GeotiffReaderPlugin.getInput(this.getInput());
            if (this.virtualDir == null) {
                throw new FileNotFoundException(this.getInput().toString());
            }
        }
        catch (IOException e) {
            throw new FileNotFoundException(this.getInput().toString());
        }
        this.initializeBasePath();
        XmlMetadataParserFactory.registerParser(LandsatLevel2Metadata.class, new XmlMetadataParser(LandsatLevel2Metadata.class));
        InputStream metadataInputStream = this.getInputStreamXml();
        if (metadataInputStream == null) {
            throw new IOException(String.format("Unable to read metadata file from product: %s", this.getInput().toString()));
        }
        try {
            this.metadata = (LandsatLevel2Metadata)XmlMetadataParserFactory.getParser(LandsatLevel2Metadata.class).parse(metadataInputStream);
        }
        catch (Exception e) {
            throw new IOException(String.format("Unable to parse metadata file: %s", this.getInput().toString()));
        }
        if (metadataInputStream != null) {
            try {
                metadataInputStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.l2saturation = LandsatL2SaturationFactory.create(this.metadata);
        this.l2qa = LandsatL2QAFactory.create(this.metadata);
        this.l2aerosol = LandsatL2AerosolFactory.create(this.metadata);
        this.l2cloud = LandsatL2CloudFactory.create(this.metadata);
        Product product = new Product(this.metadata.getProductName(), "LANDSAT_LEVEL2", this.metadata.getRasterWidth(), this.metadata.getRasterHeight());
        product.setDescription(this.metadata.getProductDescription());
        product.getMetadataRoot().addElement(this.metadata.getRootElement());
        File fileLocation = null;
        try {
            fileLocation = this.virtualDir.getTempDir();
        }
        catch (IOException e) {
            this.logger.warning(e.getMessage());
        }
        if (fileLocation == null) {
            fileLocation = new File(this.virtualDir.getBasePath());
        }
        product.setFileLocation(fileLocation);
        ProductData.UTC utcCenter = this.metadata.getCenterTime();
        product.setStartTime(utcCenter);
        product.setEndTime(utcCenter);
        for (String imageName : this.metadata.getRasterFileNames()) {
            if (this.metadata.isReflectanceBand(imageName)) {
                this.addReflectanceImage(product, imageName);
                continue;
            }
            if (this.metadata.isSaturationBand(imageName) && this.l2saturation != null) {
                this.addSaturationBand(product, imageName);
                continue;
            }
            if (this.metadata.isAerosolBand(imageName) && this.l2aerosol != null) {
                this.addAerosolBand(product, imageName);
                continue;
            }
            if (this.metadata.isQualityBand(imageName) && this.l2qa != null) {
                this.addQualityBand(product, imageName);
                continue;
            }
            if (this.metadata.isAtmosBand(imageName)) {
                this.addAtmosImage(product, imageName);
                continue;
            }
            if (this.metadata.isCloudBand(imageName) && this.l2cloud != null) {
                this.addCloudBand(product, imageName);
                continue;
            }
            this.logger.warning(String.format("Unknown type of band: %s", imageName));
        }
        return product;
    }

    protected void readBandRasterDataImpl(int i, int i1, int i2, int i3, int i4, int i5, Band band, int i6, int i7, int i8, int i9, ProductData productData, ProgressMonitor progressMonitor) throws IOException {
    }

    private InputStream getInputStreamXml() {
        String xmlFile = "";
        try {
            String[] files = null;
            for (String file : files = this.virtualDir.listAllFiles()) {
                if (!file.endsWith(".xml") || !LandsatTypeInfo.isLandsatL2(file)) continue;
                xmlFile = file;
                return this.virtualDir.getInputStream(file);
            }
        }
        catch (IOException e) {
            this.logger.warning(String.format("Unable to get input stream: %s", xmlFile));
        }
        return null;
    }

    private void addReflectanceImage(Product product, String fileName) throws IOException {
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        File bandFile = this.virtualDir.getFile(this.basePath + fileName);
        ProductReader productReader = plugIn.createReaderInstance();
        Product bandProduct = productReader.readProductNodes((Object)bandFile, null);
        if (bandProduct != null) {
            this.bandProducts.add(bandProduct);
            Band srcBand = bandProduct.getBandAt(0);
            String bandName = this.metadata.getBandName(fileName);
            Band band = this.addBandToProduct(bandName, srcBand, product);
            band.setScalingFactor(this.metadata.getScalingFactor(fileName));
            band.setScalingOffset(this.metadata.getScalingOffset(fileName));
            band.setNoDataValue(0.0);
            band.setNoDataValueUsed(true);
            band.setSpectralWavelength(this.metadata.getWavelength(fileName));
            band.setSpectralBandwidth(this.metadata.getBandwidth(fileName));
            band.setDescription(this.metadata.getBandDescription(fileName));
            band.setUnit(" ");
            MultiLevelImage sourceImage = bandProduct.getBandAt(0).getSourceImage();
            band.setSourceImage(sourceImage);
            band.setGeoCoding(bandProduct.getSceneGeoCoding());
        }
    }

    private void addAtmosImage(Product product, String fileName) throws IOException {
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        File bandFile = this.virtualDir.getFile(this.basePath + fileName);
        ProductReader productReader = plugIn.createReaderInstance();
        Product bandProduct = productReader.readProductNodes((Object)bandFile, null);
        if (bandProduct != null) {
            this.bandProducts.add(bandProduct);
            Band srcBand = bandProduct.getBandAt(0);
            String bandName = this.metadata.getBandName(fileName);
            Band band = this.addBandToProduct(bandName, srcBand, product);
            band.setScalingFactor(this.metadata.getScalingFactor(fileName));
            band.setScalingOffset(this.metadata.getScalingOffset(fileName));
            band.setDescription(this.metadata.getBandDescription(fileName));
            band.setUnit(" ");
            MultiLevelImage sourceImage = bandProduct.getBandAt(0).getSourceImage();
            band.setSourceImage(sourceImage);
            band.setGeoCoding(bandProduct.getSceneGeoCoding());
        }
    }

    private void addSaturationBand(Product product, String fileName) throws IOException {
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        File bandFile = this.virtualDir.getFile(this.basePath + fileName);
        ProductReader productReader = plugIn.createReaderInstance();
        Product bandProduct = productReader.readProductNodes((Object)bandFile, null);
        if (bandProduct != null) {
            this.bandProducts.add(bandProduct);
            Band srcBand = bandProduct.getBandAt(0);
            String bandName = "saturation";
            Band band = this.addBandToProduct(bandName, srcBand, product);
            band.setDescription("Saturation Band");
            FlagCoding flagCoding = this.l2saturation.createFlagCoding(bandName);
            band.setSampleCoding((SampleCoding)flagCoding);
            product.getFlagCodingGroup().add((ProductNode)flagCoding);
            List<Mask> masks = this.l2saturation.createMasks(band.getRasterWidth(), band.getRasterHeight());
            for (Mask mask : masks) {
                product.getMaskGroup().add((ProductNode)mask);
            }
            MultiLevelImage sourceImage = bandProduct.getBandAt(0).getSourceImage();
            band.setSourceImage(sourceImage);
            band.setGeoCoding(bandProduct.getSceneGeoCoding());
        }
    }

    private void addQualityBand(Product product, String imageName) throws IOException {
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        File bandFile = this.virtualDir.getFile(this.basePath + imageName);
        ProductReader productReader = plugIn.createReaderInstance();
        Product bandProduct = productReader.readProductNodes((Object)bandFile, null);
        if (bandProduct != null) {
            this.bandProducts.add(bandProduct);
            Band srcBand = bandProduct.getBandAt(0);
            String bandName = "pixel_qa";
            Band band = this.addBandToProduct(bandName, srcBand, product);
            band.setDescription("Quality Band");
            FlagCoding flagCoding = this.l2qa.createFlagCoding();
            band.setSampleCoding((SampleCoding)flagCoding);
            product.getFlagCodingGroup().add((ProductNode)flagCoding);
            List<Mask> masks = this.l2qa.createMasks(band.getRasterWidth(), band.getRasterHeight());
            for (Mask mask : masks) {
                product.getMaskGroup().add((ProductNode)mask);
            }
            MultiLevelImage sourceImage = bandProduct.getBandAt(0).getSourceImage();
            band.setSourceImage(sourceImage);
            band.setGeoCoding(bandProduct.getSceneGeoCoding());
        }
    }

    private void addCloudBand(Product product, String imageName) throws IOException {
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        File bandFile = this.virtualDir.getFile(this.basePath + imageName);
        ProductReader productReader = plugIn.createReaderInstance();
        Product bandProduct = productReader.readProductNodes((Object)bandFile, null);
        if (bandProduct != null) {
            this.bandProducts.add(bandProduct);
            Band srcBand = bandProduct.getBandAt(0);
            String bandName = "cloud_qa";
            Band band = this.addBandToProduct(bandName, srcBand, product);
            band.setDescription("Cloud QA Band");
            FlagCoding flagCoding = this.l2cloud.createFlagCoding();
            band.setSampleCoding((SampleCoding)flagCoding);
            product.getFlagCodingGroup().add((ProductNode)flagCoding);
            List<Mask> masks = this.l2cloud.createMasks(band.getRasterWidth(), band.getRasterHeight());
            for (Mask mask : masks) {
                product.getMaskGroup().add((ProductNode)mask);
            }
            MultiLevelImage sourceImage = bandProduct.getBandAt(0).getSourceImage();
            band.setSourceImage(sourceImage);
            band.setGeoCoding(bandProduct.getSceneGeoCoding());
        }
    }

    private void addAerosolBand(Product product, String imageName) throws IOException {
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        File bandFile = this.virtualDir.getFile(this.basePath + imageName);
        ProductReader productReader = plugIn.createReaderInstance();
        Product bandProduct = productReader.readProductNodes((Object)bandFile, null);
        if (bandProduct != null) {
            this.bandProducts.add(bandProduct);
            Band srcBand = bandProduct.getBandAt(0);
            String bandName = "aerosol_flags";
            Band band = this.addBandToProduct(bandName, srcBand, product);
            band.setDescription("Aerosol Mask");
            FlagCoding flagCoding = this.l2aerosol.createFlagCoding();
            band.setSampleCoding((SampleCoding)flagCoding);
            product.getFlagCodingGroup().add((ProductNode)flagCoding);
            List<Mask> masks = this.l2aerosol.createMasks(band.getRasterWidth(), band.getRasterHeight());
            for (Mask mask : masks) {
                product.getMaskGroup().add((ProductNode)mask);
            }
            MultiLevelImage sourceImage = bandProduct.getBandAt(0).getSourceImage();
            band.setSourceImage(sourceImage);
            band.setGeoCoding(bandProduct.getSceneGeoCoding());
        }
    }

    protected void initializeBasePath() throws IOException {
        String[] fileList;
        File fileInput = LandsatL2GeotiffReaderPlugin.getFileInput(this.getInput());
        if (fileInput != null && fileInput.exists() && LandsatL2GeotiffReaderPlugin.isMetadataFilename(fileInput.getName())) {
            this.basePath = "";
            return;
        }
        for (String filePath : fileList = this.virtualDir.listAllFiles()) {
            if (!LandsatL2GeotiffReaderPlugin.isMetadataFilename(filePath)) continue;
            this.basePath = new File(filePath).getParent();
            this.basePath = this.basePath == null ? "" : this.basePath + "/";
            return;
        }
    }

    private Band addBandToProduct(String bandName, Band srcBand, Product product) {
        Band band = new Band(bandName, srcBand.getDataType(), srcBand.getRasterWidth(), srcBand.getRasterHeight());
        product.addBand(band);
        return band;
    }
}

