/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff.level2;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatColorIterator;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2Saturation;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;

public class Landsat8L2Saturation
implements LandsatL2Saturation {
    protected final LandsatColorIterator colorIterator = new LandsatColorIterator();

    @Override
    public FlagCoding createFlagCoding(String bandName) {
        FlagCoding flagCoding = new FlagCoding("saturation");
        flagCoding.addFlag("data_fill_flag", 1, "Designated Fill");
        flagCoding.addFlag("Band1_saturated", 2, "Band 1 Data Saturation Flag");
        flagCoding.addFlag("Band2_saturated", 4, "Band 2 Data Saturation Flag");
        flagCoding.addFlag("Band3_saturated", 8, "Band 3 Data Saturation Fla ");
        flagCoding.addFlag("Band4_saturated", 16, "Band 4 Data Saturation Flag");
        flagCoding.addFlag("Band5_saturated", 32, "Band 5 Data Saturation Flag");
        flagCoding.addFlag("Band6_saturated", 64, "Band 6 Data Saturation Flag");
        flagCoding.addFlag("Band7_saturated", 128, "Band 7 Data Saturation Flag");
        flagCoding.addFlag("Band8_saturated", 256, "N/A");
        flagCoding.addFlag("Band9_saturated", 512, "Band 9 Data Saturation Flag");
        flagCoding.addFlag("Band10_saturated", 1024, "Band 10 Data Saturation Flag");
        flagCoding.addFlag("Band11_saturated", 2048, "Band 11 Data Saturation Flag");
        return flagCoding;
    }

    @Override
    public List<Mask> createMasks(int width, int height) {
        ArrayList<Mask> masks = new ArrayList<Mask>();
        masks.add(Mask.BandMathsType.create((String)"No saturation", (String)"No bands contain saturation", (int)width, (int)height, (String)"not saturation.data_fill_flag", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Band 1 saturated", (String)"Band 1 saturated", (int)width, (int)height, (String)"saturation.Band1_saturated", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Band 2 saturated", (String)"Band 2 saturated", (int)width, (int)height, (String)"saturation.Band2_saturated", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Band 3 saturated", (String)"Band 3 saturated", (int)width, (int)height, (String)"saturation.Band3_saturated", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Band 4 saturated", (String)"Band 4 saturated", (int)width, (int)height, (String)"saturation.Band4_saturated", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Band 5 saturated", (String)"Band 5 saturated", (int)width, (int)height, (String)"saturation.Band5_saturated", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Band 6 saturated", (String)"Band 6 saturated", (int)width, (int)height, (String)"saturation.Band6_saturated", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Band 7 saturated", (String)"Band 7 saturated", (int)width, (int)height, (String)"saturation.Band7_saturated", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Band 9 saturated", (String)"Band 9 saturated", (int)width, (int)height, (String)"saturation.Band9_saturated", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Band 10 saturated", (String)"Band 10 saturated", (int)width, (int)height, (String)"saturation.Band10_saturated", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Band 11 saturated", (String)"Band 11 saturated", (int)width, (int)height, (String)"saturation.Band11_saturated", (Color)this.colorIterator.next(), (double)0.5));
        return masks;
    }
}

