/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff.level2;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatColorIterator;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2QA;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;

public class Landsat8L2QA
implements LandsatL2QA {
    protected final LandsatColorIterator colorIterator = new LandsatColorIterator();

    @Override
    public FlagCoding createFlagCoding() {
        FlagCoding flagCoding = new FlagCoding("pixel_qa");
        flagCoding.addFlag("fill", 1, "Fill");
        flagCoding.addFlag("clear", 2, "Clear");
        flagCoding.addFlag("water", 4, "Water");
        flagCoding.addFlag("cloud_shadow", 8, "Cloud Shadow");
        flagCoding.addFlag("snow", 16, "Snow");
        flagCoding.addFlag("cloud", 32, "Cloud");
        flagCoding.addFlag("cloud_confidence_one", 64, "Cloud confidence bit one");
        flagCoding.addFlag("cloud_confidence_two", 128, "Cloud confidence bit two");
        flagCoding.addFlag("cirrus_confidence_one", 256, "Cirrus confidence bit one");
        flagCoding.addFlag("cirrus_confidence_two", 512, "Cirrus confidence bit two");
        flagCoding.addFlag("terrain_oclusion", 1024, "Terrain Occlusion");
        return flagCoding;
    }

    @Override
    public List<Mask> createMasks(int width, int height) {
        ArrayList<Mask> masks = new ArrayList<Mask>();
        masks.add(Mask.BandMathsType.create((String)"Fill", (String)"Fill", (int)width, (int)height, (String)"pixel_qa.fill", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Clear", (String)"Clear", (int)width, (int)height, (String)"pixel_qa.clear", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Water", (String)"Water", (int)width, (int)height, (String)"pixel_qa.water", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Cloud_Shadow", (String)"Cloud Shadow", (int)width, (int)height, (String)"pixel_qa.cloud_shadow", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Snow", (String)"Snow", (int)width, (int)height, (String)"pixel_qa.snow", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Cloud", (String)"Cloud", (int)width, (int)height, (String)"pixel_qa.cloud", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Cloud_Confidence_None", (String)"Cloud Confidence None", (int)width, (int)height, (String)"not pixel_qa.cloud_confidence_one and not pixel_qa.cloud_confidence_two", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Cloud_Confidence_Low", (String)"Cloud Confidence Low", (int)width, (int)height, (String)"not pixel_qa.cloud_confidence_one and pixel_qa.cloud_confidence_two", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Cloud_Confidence_Medium", (String)"Cloud Confidence Medium", (int)width, (int)height, (String)"pixel_qa.cloud_confidence_one and not pixel_qa.cloud_confidence_two", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Cloud_Confidence_High", (String)"Cloud Confidence High", (int)width, (int)height, (String)"pixel_qa.cloud_confidence_one and pixel_qa.cloud_confidence_two", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Cirrus_Confidence_None", (String)"Cirrus Confidence None", (int)width, (int)height, (String)"not pixel_qa.cirrus_confidence_one and not pixel_qa.cirrus_confidence_two", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Cirrus_Confidence_Low", (String)"Cirrus Confidence Low", (int)width, (int)height, (String)"not pixel_qa.cirrus_confidence_one and pixel_qa.cirrus_confidence_two", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Cirrus_Confidence_Medium", (String)"Cirrus Confidence Medium", (int)width, (int)height, (String)"pixel_qa.cirrus_confidence_one and not pixel_qa.cirrus_confidence_two", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Cirrus_Confidence_High", (String)"Cirrus Confidence High", (int)width, (int)height, (String)"pixel_qa.cirrus_confidence_one and pixel_qa.cirrus_confidence_two", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Terrain_Oclusion", (String)"Terrain Oclusion", (int)width, (int)height, (String)"pixel_qa.terrain_oclusion", (Color)this.colorIterator.next(), (double)0.5));
        return masks;
    }
}

