/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff.level2;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatColorIterator;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatL2Aerosol;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;

public class Landsat8L2Aerosol
implements LandsatL2Aerosol {
    protected final LandsatColorIterator colorIterator = new LandsatColorIterator();

    @Override
    public FlagCoding createFlagCoding() {
        FlagCoding flagCoding = new FlagCoding("aerosol_flags");
        flagCoding.addFlag("fill", 1, "Fill");
        flagCoding.addFlag("valid_aerosol_retrieval", 2, "valid aerosol retrieval (center pixel of NxN window)");
        flagCoding.addFlag("water", 4, "water pixel (or water pixel was used in the fill-the-window interpolation)");
        flagCoding.addFlag("cloud_cirrus", 8, "Cloud or cirrus");
        flagCoding.addFlag("cloud_shadow", 16, "Cloud Shadow");
        flagCoding.addFlag("non_center", 32, "non-center window pixel for which aerosol was interpolated from surrounding NxN center pixels");
        flagCoding.addFlag("aerosol_level_one", 64, "Aerosol level bit one");
        flagCoding.addFlag("aerosol_level_two", 128, "Aerosol level bit two");
        return flagCoding;
    }

    @Override
    public List<Mask> createMasks(int width, int height) {
        ArrayList<Mask> masks = new ArrayList<Mask>();
        masks.add(Mask.BandMathsType.create((String)"Aerosol_Fill", (String)"Fill", (int)width, (int)height, (String)"aerosol_flags.fill", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Aerosol_Valid", (String)"Valid aerosol retrieval", (int)width, (int)height, (String)"aerosol_flags.valid_aerosol_retrieval", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Aerosol_Water", (String)"water pixel", (int)width, (int)height, (String)"aerosol_flags.water", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Aerosol_cloud_cirrus", (String)"cloud/cirrus", (int)width, (int)height, (String)"aerosol_flags.cloud_cirrus", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Aerosol_cloud_shadow", (String)"cloud shadow", (int)width, (int)height, (String)"aerosol_flags.cloud_shadow", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"Aerosol_non_center", (String)"non-center window pixel for which aerosol was interpolated from surrounding NxN center pixels", (int)width, (int)height, (String)"aerosol_flags.non_center", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"aerosol_level_climatology", (String)"Aerosol level climatology", (int)width, (int)height, (String)"not aerosol_flags.aerosol_level_one and not aerosol_flags.aerosol_level_two", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"aerosol_level_low", (String)"Aerosol level low", (int)width, (int)height, (String)"not aerosol_flags.aerosol_level_one and aerosol_flags.aerosol_level_two", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"aerosol_level_medium", (String)"Aerosol level medium", (int)width, (int)height, (String)"aerosol_flags.aerosol_level_one and not aerosol_flags.aerosol_level_two", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"aerosol_level_high", (String)"Aerosol level high", (int)width, (int)height, (String)"aerosol_flags.aerosol_level_one and aerosol_flags.aerosol_level_two", (Color)this.colorIterator.next(), (double)0.5));
        return masks;
    }
}

