/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.esa.s3tbx.dataio.landsat.geotiff.AbstractLandsatQA;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;

public class PreCollectionLandsatQA
extends AbstractLandsatQA {
    @Override
    public FlagCoding createFlagCoding(String bandName) {
        FlagCoding flagCoding = new FlagCoding(bandName);
        flagCoding.addFlag("designated_fill", 1, "Designated Fill");
        flagCoding.addFlag("dropped_frame", 2, "Dropped Frame");
        flagCoding.addFlag("terrain_occlusion", 4, "Terrain Occlusion");
        flagCoding.addFlag("reserved_1", 8, "Reserved for a future 1-bit class artifact designation");
        flagCoding.addFlag("water_confidence_one", 16, "Water confidence bit one");
        flagCoding.addFlag("water_confidence_two", 32, "Water confidence bit two");
        flagCoding.addFlag("reserved_2_one", 64, "Reserved for a future 2-bit class artifact designation");
        flagCoding.addFlag("reserved_2_two", 128, "Reserved for a future 2-bit class artifact designation");
        flagCoding.addFlag("reserved_3_one", 256, "Reserved for a future 2-bit class artifact designation");
        flagCoding.addFlag("reserved_3_two", 512, "Reserved for a future 2-bit class artifact designation");
        flagCoding.addFlag("snow_ice_confidence_one", 1024, "Snow/ice confidence bit one");
        flagCoding.addFlag("snow_ice_confidence_two", 2048, "Snow/ice confidence bit two");
        flagCoding.addFlag("cirrus_confidence_one", 4096, "Cirrus confidence bit one");
        flagCoding.addFlag("cirrus_confidence_two", 8192, "Cirrus confidence bit two");
        flagCoding.addFlag("cloud_confidence_one", 16384, "Cloud confidence bit one");
        flagCoding.addFlag("cloud_confidence_two", 32768, "Cloud confidence bit two");
        return flagCoding;
    }

    @Override
    public List<Mask> createMasks(Dimension size) {
        ArrayList<Mask> masks = new ArrayList<Mask>();
        int width = size.width;
        int height = size.height;
        masks.add(Mask.BandMathsType.create((String)"designated_fill", (String)"Designated Fill", (int)width, (int)height, (String)"flags.designated_fill", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"dropped_frame", (String)"Dropped Frame", (int)width, (int)height, (String)"flags.dropped_frame", (Color)this.colorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"terrain_occlusion", (String)"Terrain Occlusion", (int)width, (int)height, (String)"flags.terrain_occlusion", (Color)this.colorIterator.next(), (double)0.5));
        masks.addAll(this.createDefaultConfidenceMasks("water_confidence", "Water confidence", width, height));
        masks.addAll(this.createDefaultConfidenceMasks("snow_ice_confidence", "Snow/ice confidence", width, height));
        masks.addAll(this.createDefaultConfidenceMasks("cirrus_confidence", "Cirrus confidence", width, height));
        masks.addAll(this.createDefaultConfidenceMasks("cloud_confidence", "Cloud confidence", width, height));
        return masks;
    }
}

