/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

public class LandsatTypeInfo {
    private static final String COLLECTION_FILENAME_REGEX = "L[COTEM]\\d{2}_L1\\w{2}_\\d{3}\\d{3}_\\d{8}_\\d{8}_\\d{2}_(T1|T2|RT)";
    private static final String ESA_COLLECTION_FILENAME_REGEX = "L[COTEM]\\d{2}_L1\\w{2}_\\d{3}\\d{3}_\\d{8}_\\d{8}_\\d{2}_(T1|T2|RT)_(MTI|KIS)";
    private static final String L4_FILENAME_REGEX = "LT4\\d{13}\\w{3}\\d{2}";
    private static final String L5_FILENAME_REGEX = "LT5\\d{13}\\w{3}\\d{2}";
    private static final String L7_FILENAME_REGEX = "LE7\\d{13}\\w{3}\\d{2}";
    private static final String L8_FILENAME_REGEX = "L[OTC]8\\d{13}\\w{3}\\d{2}";
    private static final String MSS_FILENAME_REGEX = "LM[1-5]\\d{13}\\w{3}\\d{2}";
    private static final String L5LEGACY_FILENAME_REGEX_1 = "LT5\\d{13}\\w{3}\\d{2}";
    private static final String L5LEGACY_FILENAME_REGEX_2 = "L5\\d{6}_\\d{11}";
    private static final String L7LEGACY_FILENAME_REGEX_1 = "LE7\\d{13}\\w{3}\\d{2}";
    private static final String L7LEGACY_FILENAME_REGEX_2 = "L7\\d{7}_\\d{11}";
    private static final String LANDSAT_LEVEL2_FILENAME_REGEX = "L[COTEM]\\d{2}\\d{16}(T1|T2|RT)-SC\\d{14}";
    private static final String LANDSAT_LEVEL2_METADATA_FILENAME_REGEX = "L[COTEM]\\d{2}_L1\\w{2}_\\d{3}\\d{3}_\\d{8}_\\d{8}_\\d{2}_(T1|T2|RT)";

    private LandsatTypeInfo() {
    }

    public static boolean isLandsat(String fileName) {
        for (LandsatType type : LandsatType.values()) {
            if (!type.matchesFileNamepattern(fileName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLandsatL2(String fileName) {
        for (LandsatL2Type type : LandsatL2Type.values()) {
            if (!type.matchesFileNamepattern(fileName)) continue;
            return true;
        }
        return false;
    }

    static boolean isLandsatCollection(String fileName) {
        return LandsatType.LANDSAT_COLLECTION.matchesFileNamepattern(fileName);
    }

    static boolean isESALandsatCollection(String fileName) {
        return LandsatType.ESA_LANDSAT_COLLECTION.matchesFileNamepattern(fileName);
    }

    static boolean isMss(String fileName) {
        return LandsatType.LANDSAT_MSS.matchesFileNamepattern(fileName);
    }

    static boolean isLandsat4(String fileName) {
        return LandsatType.LANDSAT4.matchesFileNamepattern(fileName);
    }

    static boolean isLandsat5Legacy(String fileName) {
        return LandsatType.LANDSAT5_LEGACY.matchesFileNamepattern(fileName);
    }

    static boolean isLandsat5(String fileName) {
        return LandsatType.LANDSAT5.matchesFileNamepattern(fileName);
    }

    static boolean isLandsat7Legacy(String fileName) {
        return LandsatType.LANDSAT7_LEGACY.matchesFileNamepattern(fileName);
    }

    static boolean isLandsat7(String fileName) {
        return LandsatType.LANDSAT7.matchesFileNamepattern(fileName);
    }

    static boolean isLandsat8(String fileName) {
        return LandsatType.LANDSAT8.matchesFileNamepattern(fileName);
    }

    public static boolean isLandsatLevel2(String fileName) {
        return LandsatL2Type.LANDSAT_LEVEL2.matchesFileNamepattern(fileName);
    }

    private static String getCompressionExtension() {
        return "\\.(tar\\.gz|tgz|tar\\.bz|tbz|tar\\.bz2|tbz2|zip|ZIP)";
    }

    private static String getTxtExtension() {
        return "\\.(txt|TXT)";
    }

    private static String getXmlExtension() {
        return "\\.(xml|XML)";
    }

    private static enum LandsatL2Type {
        LANDSAT_LEVEL2{

            @Override
            boolean matchesFileNamepattern(String filename) {
                return filename.matches("L[COTEM]\\d{2}_L1\\w{2}_\\d{3}\\d{3}_\\d{8}_\\d{8}_\\d{2}_(T1|T2|RT)" + LandsatTypeInfo.getXmlExtension()) || filename.matches(LandsatTypeInfo.LANDSAT_LEVEL2_FILENAME_REGEX + LandsatTypeInfo.getCompressionExtension());
            }
        };


        abstract boolean matchesFileNamepattern(String var1);
    }

    private static enum LandsatType {
        LANDSAT_COLLECTION{

            @Override
            boolean matchesFileNamepattern(String filename) {
                return filename.matches("L[COTEM]\\d{2}_L1\\w{2}_\\d{3}\\d{3}_\\d{8}_\\d{8}_\\d{2}_(T1|T2|RT)_MTL" + LandsatTypeInfo.getTxtExtension()) || filename.matches("L[COTEM]\\d{2}_L1\\w{2}_\\d{3}\\d{3}_\\d{8}_\\d{8}_\\d{2}_(T1|T2|RT)" + LandsatTypeInfo.getCompressionExtension());
            }
        }
        ,
        LANDSAT_MSS{

            @Override
            boolean matchesFileNamepattern(String filename) {
                return filename.matches("LM[1-5]\\d{13}\\w{3}\\d{2}_MTL" + LandsatTypeInfo.getTxtExtension());
            }
        }
        ,
        LANDSAT4{

            @Override
            boolean matchesFileNamepattern(String filename) {
                return filename.matches("LT4\\d{13}\\w{3}\\d{2}_MTL" + LandsatTypeInfo.getTxtExtension()) || filename.matches(LandsatTypeInfo.L4_FILENAME_REGEX + LandsatTypeInfo.getCompressionExtension());
            }
        }
        ,
        LANDSAT5{

            @Override
            boolean matchesFileNamepattern(String filename) {
                return filename.matches("LT5\\d{13}\\w{3}\\d{2}_MTL" + LandsatTypeInfo.getTxtExtension()) || filename.matches("LT5\\d{13}\\w{3}\\d{2}" + LandsatTypeInfo.getCompressionExtension());
            }
        }
        ,
        LANDSAT5_LEGACY{

            @Override
            boolean matchesFileNamepattern(String filename) {
                return filename.matches("LT5\\d{13}\\w{3}\\d{2}_MTL" + LandsatTypeInfo.getTxtExtension()) || filename.matches("L5\\d{6}_\\d{11}_MTL" + LandsatTypeInfo.getTxtExtension()) || filename.matches("LT5\\d{13}\\w{3}\\d{2}" + LandsatTypeInfo.getCompressionExtension());
            }
        }
        ,
        LANDSAT7{

            @Override
            boolean matchesFileNamepattern(String filename) {
                return filename.matches("LE7\\d{13}\\w{3}\\d{2}_MTL" + LandsatTypeInfo.getTxtExtension()) || filename.matches("LE7\\d{13}\\w{3}\\d{2}" + LandsatTypeInfo.getCompressionExtension());
            }
        }
        ,
        LANDSAT7_LEGACY{

            @Override
            boolean matchesFileNamepattern(String filename) {
                return filename.matches("LE7\\d{13}\\w{3}\\d{2}_MTL" + LandsatTypeInfo.getTxtExtension()) || filename.matches("L7\\d{7}_\\d{11}_MTL" + LandsatTypeInfo.getTxtExtension()) || filename.matches("LE7\\d{13}\\w{3}\\d{2}" + LandsatTypeInfo.getCompressionExtension());
            }
        }
        ,
        LANDSAT8{

            @Override
            boolean matchesFileNamepattern(String filename) {
                return filename.matches("L[OTC]8\\d{13}\\w{3}\\d{2}_MTL" + LandsatTypeInfo.getTxtExtension()) || filename.matches(LandsatTypeInfo.L8_FILENAME_REGEX + LandsatTypeInfo.getCompressionExtension());
            }
        }
        ,
        ESA_LANDSAT_COLLECTION{

            @Override
            boolean matchesFileNamepattern(String filename) {
                return filename.matches("L[COTEM]\\d{2}_L1\\w{2}_\\d{3}\\d{3}_\\d{8}_\\d{8}_\\d{2}_(T1|T2|RT)_(MTI|KIS)_MTL" + LandsatTypeInfo.getTxtExtension()) || filename.matches(LandsatTypeInfo.ESA_COLLECTION_FILENAME_REGEX + LandsatTypeInfo.getCompressionExtension());
            }
        };


        abstract boolean matchesFileNamepattern(String var1);
    }
}

